/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class IllegalCatchCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.catch";
    private final Set<String> illegalClassNames = Sets.newHashSet((Object[])new String[]{"Exception", "Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException", "java.lang.Throwable"});

    public void setIllegalClassNames(String ... classNames) {
        this.illegalClassNames.clear();
        for (String name : classNames) {
            this.illegalClassNames.add(name);
            int lastDot = name.lastIndexOf(46);
            if (lastDot <= 0 || lastDot >= name.length() - 1) continue;
            String shortName = name.substring(name.lastIndexOf(46) + 1);
            this.illegalClassNames.add(shortName);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{96};
    }

    @Override
    public void visitToken(DetailAST detailAST) {
        DetailAST parameterDef = detailAST.findFirstToken(21);
        DetailAST excTypeParent = parameterDef.findFirstToken(13);
        List<DetailAST> excTypes = IllegalCatchCheck.getAllExceptionTypes(excTypeParent);
        for (DetailAST excType : excTypes) {
            FullIdent ident = FullIdent.createFullIdent(excType);
            if (!this.illegalClassNames.contains(ident.getText())) continue;
            this.log(detailAST, MSG_KEY, ident.getText());
        }
    }

    private static List<DetailAST> getAllExceptionTypes(DetailAST parentToken) {
        DetailAST currentNode = parentToken.getFirstChild();
        LinkedList<DetailAST> exceptionTypes = new LinkedList<DetailAST>();
        if (currentNode.getType() == 112) {
            exceptionTypes.addAll(IllegalCatchCheck.getAllExceptionTypes(currentNode));
            currentNode = currentNode.getNextSibling();
            if (currentNode != null) {
                exceptionTypes.add(currentNode);
            }
        } else {
            exceptionTypes.add(currentNode);
            for (currentNode = currentNode.getNextSibling(); currentNode != null; currentNode = currentNode.getNextSibling()) {
                exceptionTypes.add(currentNode);
            }
        }
        return exceptionTypes;
    }
}

