/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.net.URL;
import java.util.Objects;
import javax.servlet.ServletContext;

public class ThemeHelper {
    public static final String TEMPLATE_EXTENSION_FTL = "ftl";
    public static final String TEMPLATE_EXTENSION_JSP = "jsp";
    public static final String TEMPLATE_EXTENSION_VM = "vm";

    public static String getResourcePath(ServletContext servletContext, Theme theme, String portletId, String path) {
        StringBundler sb = new StringBundler(11);
        String themeContextName = GetterUtil.getString(theme.getServletContextName());
        sb.append(themeContextName);
        String servletContextName = "";
        String contextPath = servletContext.getContextPath();
        if (!Objects.equals(PortalUtil.getPathContext(contextPath), PortalUtil.getPathContext())) {
            servletContextName = GetterUtil.getString(servletContext.getServletContextName());
        }
        int start = 0;
        if (path.startsWith("/")) {
            start = 1;
        }
        int end = path.lastIndexOf(46);
        String extension = theme.getTemplateExtension();
        if (extension.equals(TEMPLATE_EXTENSION_FTL)) {
            sb.append(theme.getFreeMarkerTemplateLoader());
            sb.append(theme.getTemplatesPath());
            if (Validator.isNotNull(servletContextName) && !path.startsWith("/".concat(servletContextName))) {
                sb.append("/");
                sb.append(servletContextName);
            }
            sb.append("/");
            sb.append(path.substring(start, end));
            sb.append(".");
            if (Validator.isNotNull(portletId)) {
                sb.append(portletId);
                sb.append(".");
            }
            sb.append(TEMPLATE_EXTENSION_FTL);
            return sb.toString();
        }
        if (extension.equals(TEMPLATE_EXTENSION_VM)) {
            sb.append(theme.getVelocityResourceListener());
            sb.append(theme.getTemplatesPath());
            if (Validator.isNotNull(servletContextName) && !path.startsWith("/".concat(servletContextName))) {
                sb.append("/");
                sb.append(servletContextName);
            }
            sb.append("/");
            sb.append(path.substring(start, end));
            sb.append(".");
            if (Validator.isNotNull(portletId)) {
                sb.append(portletId);
                sb.append(".");
            }
            sb.append(TEMPLATE_EXTENSION_VM);
            return sb.toString();
        }
        return path;
    }

    public static boolean resourceExists(ServletContext servletContext, Theme theme, String portletId, String path) throws Exception {
        Boolean exists = null;
        if (Validator.isNotNull(portletId)) {
            exists = ThemeHelper._resourceExists(servletContext, theme, portletId, path);
            if (!exists.booleanValue() && PortletConstants.hasInstanceId(portletId)) {
                String rootPortletId = PortletConstants.getRootPortletId(portletId);
                exists = ThemeHelper._resourceExists(servletContext, theme, rootPortletId, path);
            }
            if (!exists.booleanValue()) {
                exists = ThemeHelper._resourceExists(servletContext, theme, null, path);
            }
        }
        if (exists == null) {
            exists = ThemeHelper._resourceExists(servletContext, theme, portletId, path);
        }
        return exists;
    }

    private static boolean _resourceExists(ServletContext servletContext, Theme theme, String portletId, String path) throws Exception {
        if (Validator.isNull(path)) {
            return false;
        }
        String resourcePath = ThemeHelper.getResourcePath(servletContext, theme, portletId, path);
        String extension = theme.getTemplateExtension();
        if (extension.equals(TEMPLATE_EXTENSION_FTL)) {
            return TemplateResourceLoaderUtil.hasTemplateResource(TEMPLATE_EXTENSION_FTL, resourcePath);
        }
        if (extension.equals(TEMPLATE_EXTENSION_VM)) {
            return TemplateResourceLoaderUtil.hasTemplateResource(TEMPLATE_EXTENSION_VM, resourcePath);
        }
        URL url = null;
        if (theme.isWARFile()) {
            ServletContext themeServletContext = servletContext.getContext(theme.getContextPath());
            url = themeServletContext.getResource(resourcePath);
        } else {
            url = servletContext.getResource(resourcePath);
        }
        return url != null;
    }
}

