/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.language.UTF8Control;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassResourceBundleLoader;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleUtil {
    public static final ResourceBundle EMPTY_RESOURCE_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }

        @Override
        protected Object handleGetObject(String key) {
            return key;
        }
    };

    public static ResourceBundle getBundle(String baseName, Class<?> clazz) {
        return ResourceBundleUtil.getBundle(baseName, clazz.getClassLoader());
    }

    public static ResourceBundle getBundle(String baseName, ClassLoader classLoader) {
        return ResourceBundle.getBundle(baseName, Locale.getDefault(), classLoader, UTF8Control.INSTANCE);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, Class<?> clazz) {
        return ResourceBundleUtil.getBundle(baseName, locale, clazz.getClassLoader());
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) {
        return ResourceBundle.getBundle(baseName, locale, classLoader, UTF8Control.INSTANCE);
    }

    public static Map<Locale, String> getLocalizationMap(ResourceBundleLoader resourceBundleLoader, String key) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
            map.put(locale, ResourceBundleUtil.getString(resourceBundle, key));
        }
        return map;
    }

    @Deprecated
    public static Map<Locale, String> getLocalizationMap(String baseName, Class<?> clazz, String key) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            ResourceBundle resourceBundle = ResourceBundleUtil.getBundle(baseName, locale, clazz);
            map.put(locale, ResourceBundleUtil.getString(resourceBundle, key));
        }
        return map;
    }

    public static ResourceBundleLoader getResourceBundleLoader(String baseName, ClassLoader classLoader) {
        return new ClassResourceBundleLoader(baseName, classLoader);
    }

    @Deprecated
    public static String getString(ResourceBundle resourceBundle, Locale locale, String key, Object[] arguments) {
        return ResourceBundleUtil.getString(resourceBundle, key, arguments);
    }

    public static String getString(ResourceBundle resourceBundle, String key) {
        if (!resourceBundle.containsKey(key)) {
            return null;
        }
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public static String getString(ResourceBundle resourceBundle, String key, Object ... arguments) {
        String value = ResourceBundleUtil.getString(resourceBundle, key);
        if (value == null) {
            return null;
        }
        if (ArrayUtil.isNotEmpty(arguments)) {
            MessageFormat messageFormat = new MessageFormat(value, resourceBundle.getLocale());
            value = messageFormat.format(arguments);
        }
        return value;
    }

    @Deprecated
    public static void loadResourceBundles(Map<String, ResourceBundle> resourceBundles, Locale locale, ResourceBundleLoader resourceBundleLoader) {
        String languageId = LocaleUtil.toLanguageId(locale);
        ResourceBundleUtil.loadResourceBundles(resourceBundles, languageId, resourceBundleLoader);
    }

    @Deprecated
    public static void loadResourceBundles(Map<String, ResourceBundle> resourceBundles, String languageId, ResourceBundleLoader resourceBundleLoader) {
        LinkedList<ResourceBundle> currentResourceBundles = new LinkedList<ResourceBundle>();
        for (String currentLanguageId : ResourceBundleUtil._getLanguageIds(languageId)) {
            ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(currentLanguageId);
            if (resourceBundle != null) {
                currentResourceBundles.addFirst(resourceBundle);
            } else if (currentResourceBundles.isEmpty()) continue;
            if (currentResourceBundles.size() == 1) {
                resourceBundles.put(currentLanguageId, (ResourceBundle)currentResourceBundles.peek());
                continue;
            }
            int size = currentResourceBundles.size();
            resourceBundles.put(currentLanguageId, new AggregateResourceBundle(currentResourceBundles.toArray(new ResourceBundle[size])));
        }
    }

    private static List<String> _getLanguageIds(String languageId) {
        ArrayList<String> languageIds = new ArrayList<String>();
        languageIds.add("");
        int index = 0;
        while ((index = languageId.indexOf(95, index + 1)) != -1) {
            languageIds.add(languageId.substring(0, index));
        }
        languageIds.add(languageId);
        return languageIds;
    }
}

