/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class EscapableLocalizableFunction
implements Serializable {
    private final boolean _escape;
    private final Map<Locale, String> _escapedValueMap = new HashMap<Locale, String>();
    private final Function<Locale, String> _function;

    public EscapableLocalizableFunction(Function<Locale, String> function) {
        this(function, true);
    }

    public EscapableLocalizableFunction(Function<Locale, String> function, boolean escape) {
        this._function = function;
        this._escape = escape;
    }

    public String getEscapedValue(Locale locale) {
        if (Validator.isNull(this._escapedValueMap.get(locale))) {
            if (this._escape) {
                this._escapedValueMap.put(locale, this.escape(locale));
            } else {
                this._escapedValueMap.put(locale, this.getOriginalValue(locale));
            }
        }
        return this._escapedValueMap.get(locale);
    }

    public String getOriginalValue(Locale locale) {
        return this._function.apply(locale);
    }

    protected String escape(Locale locale) {
        return HtmlUtil.escape(this.getOriginalValue(locale));
    }
}

