/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@ProviderType
public abstract class BaseTemplateHandler
implements TemplateHandler {
    @Override
    public Map<String, Object> getCustomContextObjects() {
        return Collections.emptyMap();
    }

    @Override
    public List<Element> getDefaultTemplateElements() throws Exception {
        String templatesConfigPath = this.getTemplatesConfigPath();
        if (Validator.isNull(templatesConfigPath)) {
            return Collections.emptyList();
        }
        Class<?> clazz = this.getClass();
        String xml = StringUtil.read(clazz.getClassLoader(), templatesConfigPath, false);
        Document document = UnsecureSAXReaderUtil.read(xml);
        Element rootElement = document.getRootElement();
        return rootElement.elements("template");
    }

    @Override
    public String getDefaultTemplateKey() {
        return null;
    }

    @Override
    public String[] getRestrictedVariables(String language) {
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager(language);
        if (templateManager != null) {
            return templateManager.getRestrictedVariables();
        }
        return new String[0];
    }

    @Override
    public String getTemplatesHelpContent(String language) {
        String content = "";
        try {
            Class<?> clazz = this.getClass();
            content = StringUtil.read(clazz.getClassLoader(), this.getTemplatesHelpPath(language));
        }
        catch (IOException ioe1) {
            try {
                content = StringUtil.read(PortalClassLoaderUtil.getClassLoader(), this.getTemplatesHelpPath(language));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return content;
    }

    @Override
    public String getTemplatesHelpPath(String language) {
        return PropsUtil.get(this.getTemplatesHelpPropertyKey(), new Filter(language));
    }

    @Override
    public String getTemplatesHelpPropertyKey() {
        return "portlet.display.templates.help";
    }

    protected String getTemplatesConfigPath() {
        return null;
    }
}

