/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.security.auth.tunnel.TunnelAuthenticationManagerUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProtectedClassLoaderObjectInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class TunnelUtil {
    private static final boolean _VERIFY_SSL_HOSTNAME = GetterUtil.getBoolean(PropsUtil.get(TunnelUtil.class.getName() + ".verify.ssl.hostname"));
    private static final Log _log = LogFactoryUtil.getLog(TunnelUtil.class);

    public static Object invoke(HttpPrincipal httpPrincipal, MethodHandler methodHandler) throws Exception {
        Object returnObject;
        block28: {
            HttpURLConnection httpURLConnection = TunnelUtil._getConnection(httpPrincipal);
            TunnelAuthenticationManagerUtil.setCredentials(httpPrincipal.getLogin(), httpURLConnection);
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(httpURLConnection.getOutputStream());){
                objectOutputStream.writeObject(new ObjectValuePair<HttpPrincipal, MethodHandler>(httpPrincipal, methodHandler));
            }
            returnObject = null;
            Thread thread = Thread.currentThread();
            try (ProtectedClassLoaderObjectInputStream objectInputStream = new ProtectedClassLoaderObjectInputStream(httpURLConnection.getInputStream(), AggregateClassLoader.getAggregateClassLoader(TunnelUtil.class.getClassLoader(), thread.getContextClassLoader()));){
                returnObject = objectInputStream.readObject();
            }
            catch (EOFException eofe) {
                if (!_log.isDebugEnabled()) break block28;
                _log.debug("Unable to read object", eofe);
            }
        }
        if (returnObject != null && returnObject instanceof Exception) {
            throw (Exception)returnObject;
        }
        return returnObject;
    }

    private static HttpURLConnection _getConnection(HttpPrincipal httpPrincipal) throws IOException {
        if (httpPrincipal == null || httpPrincipal.getUrl() == null) {
            return null;
        }
        URL url = new URL(httpPrincipal.getUrl() + "/api/liferay/do");
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        if (!_VERIFY_SSL_HOSTNAME && httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        httpURLConnection.setRequestProperty("Content-Type", "application/x-java-serialized-object");
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestMethod("POST");
        return httpURLConnection;
    }
}

