/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@JSON
public class ServiceContext
implements Cloneable,
Serializable {
    private boolean _addGroupPermissions;
    private boolean _addGuestPermissions;
    private long[] _assetCategoryIds;
    private boolean _assetEntryVisible = true;
    private long[] _assetLinkEntryIds;
    private double _assetPriority;
    private String[] _assetTagNames;
    private Map<String, Serializable> _attributes;
    private String _command;
    private long _companyId;
    private Date _createDate;
    private String _currentURL;
    private boolean _deriveDefaultPermissions;
    private Map<String, Serializable> _expandoBridgeAttributes;
    private boolean _failOnPortalException = true;
    private Date _formDate;
    private transient Map<String, String> _headers;
    private boolean _indexingEnabled = true;
    private String _languageId;
    private String _layoutFullURL;
    private String _layoutURL;
    private ModelPermissions _modelPermissions = new ModelPermissions();
    private Date _modifiedDate;
    private String _pathFriendlyURLPrivateGroup;
    private String _pathFriendlyURLPrivateUser;
    private String _pathFriendlyURLPublic;
    private String _pathMain;
    private Long _plid;
    private String _portalURL;
    private String _portletId;
    private PortletPreferencesIds _portletPreferencesIds;
    private String _remoteAddr;
    private String _remoteHost;
    private transient HttpServletRequest _request;
    private long _scopeGroupId;
    private boolean _signedIn;
    private TimeZone _timeZone;
    private String _userDisplayURL;
    private long _userId;
    private String _uuid;
    private int _workflowAction = 1;

    public ServiceContext() {
        this._attributes = new LinkedHashMap<String, Serializable>();
        this._expandoBridgeAttributes = new LinkedHashMap<String, Serializable>();
    }

    public Object clone() {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(this.isAddGroupPermissions());
        serviceContext.setAddGuestPermissions(this.isAddGuestPermissions());
        serviceContext.setAssetCategoryIds(this.getAssetCategoryIds());
        serviceContext.setAssetEntryVisible(this.isAssetEntryVisible());
        serviceContext.setAssetLinkEntryIds(this.getAssetLinkEntryIds());
        serviceContext.setAssetPriority(this.getAssetPriority());
        serviceContext.setAssetTagNames(this.getAssetTagNames());
        serviceContext.setAttributes(this.getAttributes());
        serviceContext.setCommand(this.getCommand());
        serviceContext.setCompanyId(this.getCompanyId());
        serviceContext.setCreateDate(this.getCreateDate());
        serviceContext.setCurrentURL(this.getCurrentURL());
        serviceContext.setExpandoBridgeAttributes(this.getExpandoBridgeAttributes());
        serviceContext.setFailOnPortalException(this.isFailOnPortalException());
        serviceContext.setGroupPermissions(this.getGroupPermissions());
        serviceContext.setGuestPermissions(this.getGuestPermissions());
        if (this._headers != null) {
            serviceContext.setHeaders(this._headers);
        }
        serviceContext.setIndexingEnabled(this.isIndexingEnabled());
        serviceContext.setLanguageId(this.getLanguageId());
        serviceContext.setLayoutFullURL(this.getLayoutFullURL());
        serviceContext.setLayoutURL(this.getLayoutURL());
        serviceContext.setModelPermissions((ModelPermissions)this._modelPermissions.clone());
        serviceContext.setModifiedDate(this.getModifiedDate());
        serviceContext.setPathFriendlyURLPrivateGroup(this.getPathFriendlyURLPrivateGroup());
        serviceContext.setPathFriendlyURLPrivateUser(this.getPathFriendlyURLPrivateUser());
        serviceContext.setPathFriendlyURLPublic(this.getPathFriendlyURLPublic());
        serviceContext.setPathMain(this.getPathMain());
        if (this._plid != null) {
            serviceContext.setPlid(this._plid);
        }
        serviceContext.setPortalURL(this.getPortalURL());
        serviceContext.setPortletPreferencesIds(this.getPortletPreferencesIds());
        serviceContext.setRemoteAddr(this.getRemoteAddr());
        serviceContext.setRemoteHost(this.getRemoteHost());
        serviceContext.setRequest(this.getRequest());
        serviceContext.setScopeGroupId(this.getScopeGroupId());
        serviceContext.setSignedIn(this.isSignedIn());
        if (this._userDisplayURL != null) {
            serviceContext.setUserDisplayURL(this._userDisplayURL);
        }
        serviceContext.setUserId(this.getUserId());
        serviceContext.setUuid(this.getUuid());
        serviceContext.setWorkflowAction(this.getWorkflowAction());
        return serviceContext;
    }

    public void deriveDefaultPermissions(long repositoryId, String modelName) throws PortalException {
        long siteGroupId = PortalUtil.getSiteGroupId(repositoryId);
        Group siteGroup = GroupLocalServiceUtil.getGroup(siteGroupId);
        Role defaultGroupRole = RoleLocalServiceUtil.getDefaultGroupRole(siteGroupId);
        ArrayList<String> groupPermissionsList = new ArrayList<String>();
        ArrayList<String> guestPermissionsList = new ArrayList<String>();
        String[] roleNames = new String[]{"Guest", defaultGroupRole.getName()};
        List<String> supportedActions = ResourceActionsUtil.getModelResourceActions(modelName);
        List<String> groupDefaultActions = ResourceActionsUtil.getModelResourceGroupDefaultActions(modelName);
        List<String> guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions(modelName);
        List<String> guestUnsupportedActions = ResourceActionsUtil.getModelResourceGuestUnsupportedActions(modelName);
        for (String roleName : roleNames) {
            for (String action : supportedActions) {
                if (roleName.equals("Guest") && !guestUnsupportedActions.contains(action) && guestDefaultActions.contains(action) && siteGroup.hasPublicLayouts()) {
                    guestPermissionsList.add(action);
                    continue;
                }
                if (!roleName.equals(defaultGroupRole.getName()) || !groupDefaultActions.contains(action)) continue;
                groupPermissionsList.add(action);
            }
        }
        String[] groupPermissions = groupPermissionsList.toArray(new String[groupPermissionsList.size()]);
        this.setGroupPermissions(groupPermissions);
        String[] guestPermissions = guestPermissionsList.toArray(new String[guestPermissionsList.size()]);
        this.setGuestPermissions(guestPermissions);
    }

    public long[] getAssetCategoryIds() {
        return this._assetCategoryIds;
    }

    public long[] getAssetLinkEntryIds() {
        return this._assetLinkEntryIds;
    }

    public double getAssetPriority() {
        return this._assetPriority;
    }

    public String[] getAssetTagNames() {
        return this._assetTagNames;
    }

    public Serializable getAttribute(String name) {
        return this._attributes.get(name);
    }

    public Map<String, Serializable> getAttributes() {
        return this._attributes;
    }

    public String getCommand() {
        return this._command;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public Date getCreateDate() {
        return this._createDate;
    }

    public Date getCreateDate(Date defaultCreateDate) {
        if (this._createDate != null) {
            return this._createDate;
        }
        if (defaultCreateDate != null) {
            return defaultCreateDate;
        }
        return new Date();
    }

    public String getCurrentURL() {
        return this._currentURL;
    }

    public Map<String, Serializable> getExpandoBridgeAttributes() {
        return this._expandoBridgeAttributes;
    }

    public Date getFormDate() {
        return this._formDate;
    }

    public String[] getGroupPermissions() {
        return this._modelPermissions.getActionIds("PLACEHOLDER_DEFAULT_GROUP_ROLE");
    }

    public long getGuestOrUserId() throws PortalException {
        long userId = this.getUserId();
        if (userId > 0L) {
            return userId;
        }
        long companyId = this.getCompanyId();
        if (companyId > 0L) {
            return UserLocalServiceUtil.getDefaultUserId(this.getCompanyId());
        }
        return 0L;
    }

    public String[] getGuestPermissions() {
        return this._modelPermissions.getActionIds("Guest");
    }

    @JSON(include=false)
    public Map<String, String> getHeaders() {
        if (this._headers == null && this._request != null) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            Enumeration enu = this._request.getHeaderNames();
            while (enu.hasMoreElements()) {
                String header = (String)enu.nextElement();
                String value = this._request.getHeader(header);
                headerMap.put(header, value);
            }
            this._headers = headerMap;
        }
        return this._headers;
    }

    public String getLanguageId() {
        if (this._languageId != null) {
            return this._languageId;
        }
        return LocaleUtil.toLanguageId(LocaleUtil.getMostRelevantLocale());
    }

    public String getLayoutFullURL() {
        return this._layoutFullURL;
    }

    public String getLayoutURL() {
        return this._layoutURL;
    }

    @JSON(include=false)
    public LiferayPortletRequest getLiferayPortletRequest() {
        if (this._request == null) {
            return null;
        }
        PortletRequest portletRequest = (PortletRequest)this._request.getAttribute("javax.portlet.request");
        if (portletRequest == null) {
            return null;
        }
        return PortalUtil.getLiferayPortletRequest(portletRequest);
    }

    @JSON(include=false)
    public LiferayPortletResponse getLiferayPortletResponse() {
        if (this._request == null) {
            return null;
        }
        PortletResponse portletResponse = (PortletResponse)this._request.getAttribute("javax.portlet.response");
        if (portletResponse == null) {
            return null;
        }
        return PortalUtil.getLiferayPortletResponse(portletResponse);
    }

    public Locale getLocale() {
        return LocaleUtil.fromLanguageId(this._languageId);
    }

    public ModelPermissions getModelPermissions() {
        return this._modelPermissions;
    }

    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public Date getModifiedDate(Date defaultModifiedDate) {
        if (this._modifiedDate != null) {
            return this._modifiedDate;
        }
        if (defaultModifiedDate != null) {
            return defaultModifiedDate;
        }
        return new Date();
    }

    public String getPathFriendlyURLPrivateGroup() {
        return this._pathFriendlyURLPrivateGroup;
    }

    public String getPathFriendlyURLPrivateUser() {
        return this._pathFriendlyURLPrivateUser;
    }

    public String getPathFriendlyURLPublic() {
        return this._pathFriendlyURLPublic;
    }

    public String getPathMain() {
        return this._pathMain;
    }

    public long getPlid() {
        if (this._plid == null) {
            this._plid = LayoutLocalServiceUtil.getDefaultPlid(this._scopeGroupId, false);
        }
        return this._plid;
    }

    public String getPortalURL() {
        return this._portalURL;
    }

    public String getPortletId() {
        if (this._portletId != null) {
            return this._portletId;
        }
        if (this._portletPreferencesIds == null) {
            return null;
        }
        return this._portletPreferencesIds.getPortletId();
    }

    public PortletPreferencesIds getPortletPreferencesIds() {
        if (this._portletPreferencesIds == null) {
            if (this._portletId == null) {
                return null;
            }
            try {
                this._portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds(this._request, this._portletId);
            }
            catch (PortalException pe) {
                ReflectionUtil.throwException(pe);
            }
        }
        return this._portletPreferencesIds;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    @JSON(include=false)
    public HttpServletRequest getRequest() {
        return this._request;
    }

    @JSON(include=false)
    public HttpServletResponse getResponse() {
        LiferayPortletResponse liferayPortletResponse = this.getLiferayPortletResponse();
        if (liferayPortletResponse == null) {
            return null;
        }
        return PortalUtil.getHttpServletResponse(liferayPortletResponse);
    }

    public String getRootPortletId() {
        String portletId = this.getPortletId();
        if (portletId == null) {
            return null;
        }
        return PortletConstants.getRootPortletId(portletId);
    }

    public Group getScopeGroup() throws PortalException {
        return GroupLocalServiceUtil.getGroup(this._scopeGroupId);
    }

    public long getScopeGroupId() {
        return this._scopeGroupId;
    }

    public ThemeDisplay getThemeDisplay() {
        if (this._request == null) {
            return null;
        }
        return (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public String getUserAgent() {
        if (this._request == null) {
            return null;
        }
        return this._request.getHeader("User-Agent");
    }

    public String getUserDisplayURL() {
        if (this._userDisplayURL == null) {
            ThemeDisplay themeDisplay = this.getThemeDisplay();
            if (themeDisplay == null) {
                return null;
            }
            User user = themeDisplay.getUser();
            try {
                this._userDisplayURL = user.getDisplayURL(themeDisplay);
            }
            catch (PortalException pe) {
                ReflectionUtil.throwException(pe);
            }
        }
        return this._userDisplayURL;
    }

    public long getUserId() {
        return this._userId;
    }

    public String getUuid() {
        String uuid = this._uuid;
        this._uuid = null;
        return uuid;
    }

    public String getUuidWithoutReset() {
        return this._uuid;
    }

    public int getWorkflowAction() {
        return this._workflowAction;
    }

    public boolean isAddGroupPermissions() {
        return this._addGroupPermissions;
    }

    public boolean isAddGuestPermissions() {
        return this._addGuestPermissions;
    }

    public boolean isAssetEntryVisible() {
        return this._assetEntryVisible;
    }

    public boolean isCommandAdd() {
        return Objects.equals(this._command, "add") || Objects.equals(this._command, "add_dynamic") || Objects.equals(this._command, "add_multiple") || Objects.equals(this._command, "add_webdav");
    }

    public boolean isCommandUpdate() {
        return Objects.equals(this._command, "update") || Objects.equals(this._command, "update_and_checkin") || Objects.equals(this._command, "update_webdav");
    }

    public boolean isDeriveDefaultPermissions() {
        return this._deriveDefaultPermissions;
    }

    public boolean isFailOnPortalException() {
        return this._failOnPortalException;
    }

    public boolean isIndexingEnabled() {
        return this._indexingEnabled;
    }

    public boolean isSignedIn() {
        return this._signedIn;
    }

    public void merge(ServiceContext serviceContext) {
        this.setAddGroupPermissions(serviceContext.isAddGroupPermissions());
        this.setAddGuestPermissions(serviceContext.isAddGuestPermissions());
        if (serviceContext.getAssetCategoryIds() != null) {
            this.setAssetCategoryIds(serviceContext.getAssetCategoryIds());
        }
        this.setAssetEntryVisible(serviceContext.isAssetEntryVisible());
        if (serviceContext.getAssetLinkEntryIds() != null) {
            this.setAssetLinkEntryIds(serviceContext.getAssetLinkEntryIds());
        }
        if (serviceContext.getAssetPriority() > 0.0) {
            this.setAssetPriority(serviceContext.getAssetPriority());
        }
        if (serviceContext.getAssetTagNames() != null) {
            this.setAssetTagNames(serviceContext.getAssetTagNames());
        }
        if (serviceContext.getAttributes() != null) {
            this.setAttributes(serviceContext.getAttributes());
        }
        if (Validator.isNotNull(serviceContext.getCommand())) {
            this.setCommand(serviceContext.getCommand());
        }
        if (serviceContext.getCompanyId() > 0L) {
            this.setCompanyId(serviceContext.getCompanyId());
        }
        if (serviceContext.getCreateDate() != null) {
            this.setCreateDate(serviceContext.getCreateDate());
        }
        if (Validator.isNotNull(serviceContext.getCurrentURL())) {
            this.setCurrentURL(serviceContext.getCurrentURL());
        }
        this.setDeriveDefaultPermissions(serviceContext.isDeriveDefaultPermissions());
        if (serviceContext.getExpandoBridgeAttributes() != null) {
            this.setExpandoBridgeAttributes(serviceContext.getExpandoBridgeAttributes());
        }
        this.setFailOnPortalException(serviceContext.isFailOnPortalException());
        if (serviceContext.getGroupPermissions() != null) {
            this.setGroupPermissions(serviceContext.getGroupPermissions());
        }
        if (serviceContext.getGuestPermissions() != null) {
            this.setGuestPermissions(serviceContext.getGuestPermissions());
        }
        if (serviceContext._headers != null) {
            this.setHeaders(serviceContext._headers);
        }
        this.setIndexingEnabled(serviceContext.isIndexingEnabled());
        this.setLanguageId(serviceContext.getLanguageId());
        if (Validator.isNotNull(serviceContext.getLayoutFullURL())) {
            this.setLayoutFullURL(serviceContext.getLayoutFullURL());
        }
        if (Validator.isNotNull(serviceContext.getLayoutURL())) {
            this.setLayoutURL(serviceContext.getLayoutURL());
        }
        if (serviceContext.getModifiedDate() != null) {
            this.setModifiedDate(serviceContext.getModifiedDate());
        }
        if (Validator.isNotNull(serviceContext.getPathFriendlyURLPrivateGroup())) {
            this.setPathFriendlyURLPrivateGroup(serviceContext.getPathFriendlyURLPrivateGroup());
        }
        if (Validator.isNotNull(serviceContext.getPathFriendlyURLPrivateUser())) {
            this.setPathFriendlyURLPrivateUser(serviceContext.getPathFriendlyURLPrivateUser());
        }
        if (Validator.isNotNull(serviceContext.getPathFriendlyURLPublic())) {
            this.setPathFriendlyURLPublic(serviceContext.getPathFriendlyURLPublic());
        }
        if (Validator.isNotNull(serviceContext.getPathMain())) {
            this.setPathMain(serviceContext.getPathMain());
        }
        if (serviceContext.getPlid() > 0L) {
            this.setPlid(serviceContext.getPlid());
        }
        if (Validator.isNotNull(serviceContext.getPortalURL())) {
            this.setPortalURL(serviceContext.getPortalURL());
        }
        if (serviceContext.getPortletPreferencesIds() != null) {
            this.setPortletPreferencesIds(serviceContext.getPortletPreferencesIds());
        }
        if (Validator.isNotNull(serviceContext.getRemoteAddr())) {
            this.setRemoteAddr(serviceContext.getRemoteAddr());
        }
        if (Validator.isNotNull(serviceContext.getRemoteHost())) {
            this.setRemoteHost(serviceContext.getRemoteHost());
        }
        if (serviceContext.getScopeGroupId() > 0L) {
            this.setScopeGroupId(serviceContext.getScopeGroupId());
        }
        this.setSignedIn(serviceContext.isSignedIn());
        if (serviceContext.getTimeZone() != null) {
            this.setTimeZone(serviceContext.getTimeZone());
        }
        if (Validator.isNotNull(serviceContext._userDisplayURL)) {
            this.setUserDisplayURL(serviceContext._userDisplayURL);
        }
        if (serviceContext.getUserId() > 0L) {
            this.setUserId(serviceContext.getUserId());
        }
        if (Validator.isNotNull(serviceContext._uuid)) {
            this.setUuid(serviceContext._uuid);
        }
        if (serviceContext.getWorkflowAction() > 0) {
            this.setWorkflowAction(serviceContext.getWorkflowAction());
        }
    }

    public Serializable removeAttribute(String name) {
        return this._attributes.remove(name);
    }

    public void setAddGroupPermissions(boolean addGroupPermissions) {
        this._addGroupPermissions = addGroupPermissions;
    }

    public void setAddGuestPermissions(boolean addGuestPermissions) {
        this._addGuestPermissions = addGuestPermissions;
    }

    public void setAssetCategoryIds(long[] assetCategoryIds) {
        this._assetCategoryIds = assetCategoryIds;
    }

    public void setAssetEntryVisible(boolean assetEntryVisible) {
        this._assetEntryVisible = assetEntryVisible;
    }

    public void setAssetLinkEntryIds(long[] assetLinkEntryIds) {
        this._assetLinkEntryIds = assetLinkEntryIds;
    }

    public void setAssetPriority(double assetPriority) {
        this._assetPriority = assetPriority;
    }

    public void setAssetTagNames(String[] assetTagNames) {
        this._assetTagNames = assetTagNames;
    }

    public void setAttribute(String name, Serializable value) {
        this._attributes.put(name, value);
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        this._attributes = attributes;
    }

    public void setCommand(String command) {
        this._command = command;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    public void setCurrentURL(String currentURL) {
        this._currentURL = currentURL;
    }

    public void setDeriveDefaultPermissions(boolean deriveDefaultPermissions) {
        this._deriveDefaultPermissions = deriveDefaultPermissions;
    }

    public void setExpandoBridgeAttributes(Map<String, Serializable> expandoBridgeAttributes) {
        this._expandoBridgeAttributes = expandoBridgeAttributes;
    }

    public void setFailOnPortalException(boolean failOnPortalException) {
        this._failOnPortalException = failOnPortalException;
    }

    public void setFormDate(Date formDate) {
        this._formDate = formDate;
    }

    public void setGroupPermissions(String[] groupPermissions) {
        this._modelPermissions.addRolePermissions("PLACEHOLDER_DEFAULT_GROUP_ROLE", groupPermissions);
    }

    public void setGuestPermissions(String[] guestPermissions) {
        this._modelPermissions.addRolePermissions("Guest", guestPermissions);
    }

    public void setHeaders(Map<String, String> headers) {
        this._headers = headers;
    }

    public void setIndexingEnabled(boolean indexingEnabled) {
        this._indexingEnabled = indexingEnabled;
    }

    public void setLanguageId(String languageId) {
        this._languageId = languageId;
    }

    public void setLayoutFullURL(String layoutFullURL) {
        this._layoutFullURL = layoutFullURL;
    }

    public void setLayoutURL(String layoutURL) {
        this._layoutURL = layoutURL;
    }

    public void setModelPermissions(ModelPermissions modelPermissions) {
        this._modelPermissions = modelPermissions;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._modifiedDate = modifiedDate;
    }

    public void setPathFriendlyURLPrivateGroup(String pathFriendlyURLPrivateGroup) {
        this._pathFriendlyURLPrivateGroup = pathFriendlyURLPrivateGroup;
    }

    public void setPathFriendlyURLPrivateUser(String pathFriendlyURLPrivateUser) {
        this._pathFriendlyURLPrivateUser = pathFriendlyURLPrivateUser;
    }

    public void setPathFriendlyURLPublic(String pathFriendlyURLPublic) {
        this._pathFriendlyURLPublic = pathFriendlyURLPublic;
    }

    public void setPathMain(String pathMain) {
        this._pathMain = pathMain;
    }

    public void setPlid(long plid) {
        this._plid = plid;
    }

    public void setPortalURL(String portalURL) {
        this._portalURL = portalURL;
    }

    public void setPortletId(String portletId) {
        this._portletId = portletId;
    }

    public void setPortletPreferencesIds(PortletPreferencesIds portletPreferencesIds) {
        this._portletPreferencesIds = portletPreferencesIds;
    }

    public void setRemoteAddr(String remoteAddr) {
        this._remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this._remoteHost = remoteHost;
    }

    public void setRequest(HttpServletRequest request) {
        this._request = request;
    }

    public void setScopeGroupId(long scopeGroupId) {
        this._scopeGroupId = scopeGroupId;
    }

    public void setSignedIn(boolean signedIn) {
        this._signedIn = signedIn;
    }

    public void setTimeZone(TimeZone timeZone) {
        this._timeZone = timeZone;
    }

    public void setUserDisplayURL(String userDisplayURL) {
        this._userDisplayURL = userDisplayURL;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public void setUuid(String uuid) {
        this._uuid = uuid;
    }

    public void setWorkflowAction(int workflowAction) {
        this._workflowAction = workflowAction;
    }

    public String translate(String pattern, Object ... arguments) {
        Locale locale = this.getLocale();
        return LanguageUtil.format(locale, pattern, arguments);
    }

    public void validateModifiedDate(AuditedModel auditedModel, Class<? extends PortalException> clazz) throws PortalException {
        int value = DateUtil.compareTo(auditedModel.getModifiedDate(), this._formDate);
        if (value > 0) {
            try {
                throw clazz.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie);
            }
        }
    }
}

