/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.proxy;

import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.proxy.IntrabandProxySkeleton;
import java.util.concurrent.ExecutorService;

public class AsyncIntrabandProxySkeleton
implements IntrabandProxySkeleton {
    private final ExecutorService _executorService;
    private final IntrabandProxySkeleton _intrabandProxySkeleton;

    public static IntrabandProxySkeleton createAsyncIntrabandProxySkeleton(String skeletonId, IntrabandProxySkeleton intrabandProxySkeleton) {
        ThreadPoolExecutor executorService = PortalExecutorManagerUtil.getPortalExecutor(skeletonId, false);
        if (executorService == null) {
            return intrabandProxySkeleton;
        }
        return new AsyncIntrabandProxySkeleton(executorService, intrabandProxySkeleton);
    }

    @Override
    public void dispatch(final RegistrationReference registrationReference, final Datagram datagram, final Deserializer deserializer) {
        this._executorService.execute(new Runnable(){

            @Override
            public void run() {
                AsyncIntrabandProxySkeleton.this._intrabandProxySkeleton.dispatch(registrationReference, datagram, deserializer);
            }
        });
    }

    private AsyncIntrabandProxySkeleton(ExecutorService executorService, IntrabandProxySkeleton intrabandProxySkeleton) {
        this._executorService = executorService;
        this._intrabandProxySkeleton = intrabandProxySkeleton;
    }
}

