/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.concurrent.ConcurrentMapperHashMap;
import com.liferay.portal.kernel.memory.FinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeManager;
import java.lang.ref.Reference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentReferenceKeyHashMap<K, V>
extends ConcurrentMapperHashMap<K, Reference<K>, V, V> {
    private final FinalizeAction _keyFinalizeAction = new FinalizeAction(){

        @Override
        public void doFinalize(Reference<?> reference) {
            ConcurrentReferenceKeyHashMap.this.innerConcurrentMap.remove(reference);
        }
    };
    private final FinalizeManager.ReferenceFactory _referenceFactory;

    public ConcurrentReferenceKeyHashMap(ConcurrentMap<Reference<K>, V> innerConcurrentMap, FinalizeManager.ReferenceFactory referenceFactory) {
        super(innerConcurrentMap);
        this._referenceFactory = referenceFactory;
    }

    public ConcurrentReferenceKeyHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel), referenceFactory);
    }

    public ConcurrentReferenceKeyHashMap(int initialCapacity, FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(initialCapacity), referenceFactory);
    }

    public ConcurrentReferenceKeyHashMap(Map<? extends K, ? extends V> map, FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(), referenceFactory);
        this.putAll(map);
    }

    public ConcurrentReferenceKeyHashMap(FinalizeManager.ReferenceFactory referenceFactory) {
        this(new ConcurrentHashMap(), referenceFactory);
    }

    @Override
    protected Reference<K> mapKey(K key) {
        return FinalizeManager.register(key, this._keyFinalizeAction, this._referenceFactory);
    }

    @Override
    protected Reference<K> mapKeyForQuery(K key) {
        return this._referenceFactory.createReference(key, null);
    }

    @Override
    protected V mapValue(K key, V value) {
        return value;
    }

    @Override
    protected V mapValueForQuery(V value) {
        return value;
    }

    @Override
    protected K unmapKey(Reference<K> reference) {
        K key = reference.get();
        reference.clear();
        return key;
    }

    @Override
    protected K unmapKeyForQuery(Reference<K> reference) {
        return reference.get();
    }

    @Override
    protected V unmapValue(V value) {
        return value;
    }

    @Override
    protected V unmapValueForQuery(V value) {
        return value;
    }
}

