/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache.key;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CacheKeyGeneratorUtil {
    private static Map<String, CacheKeyGenerator> _cacheKeyGenerators = new HashMap<String, CacheKeyGenerator>();
    private static CacheKeyGenerator _defaultCacheKeyGenerator;

    public static CacheKeyGenerator getCacheKeyGenerator() {
        return CacheKeyGeneratorUtil.getCacheKeyGenerator(null);
    }

    public static CacheKeyGenerator getCacheKeyGenerator(String cacheName) {
        PortalRuntimePermission.checkGetBeanProperty(CacheKeyGeneratorUtil.class);
        ThreadLocalCache<CacheKeyGenerator> threadLocalCacheKeyGenerators = ThreadLocalCacheManager.getThreadLocalCache(Lifecycle.ETERNAL, (Serializable)((Object)CacheKeyGeneratorUtil.class.getName()));
        CacheKeyGenerator cacheKeyGenerator = (CacheKeyGenerator)threadLocalCacheKeyGenerators.get(cacheName);
        if (cacheKeyGenerator != null) {
            return cacheKeyGenerator;
        }
        cacheKeyGenerator = _cacheKeyGenerators.get(cacheName);
        if (cacheKeyGenerator == null) {
            cacheKeyGenerator = _defaultCacheKeyGenerator;
        }
        cacheKeyGenerator = cacheKeyGenerator.clone();
        threadLocalCacheKeyGenerators.put(cacheName, cacheKeyGenerator);
        return cacheKeyGenerator;
    }

    public void setCacheKeyGenerators(Map<String, CacheKeyGenerator> cacheKeyGenerators) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _cacheKeyGenerators = cacheKeyGenerators;
    }

    public void setDefaultCacheKeyGenerator(CacheKeyGenerator defaultCacheKeyGenerator) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _defaultCacheKeyGenerator = defaultCacheKeyGenerator;
    }
}

