/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.io.DummyOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xuggler.XugglerInstallException;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.xuggler.XugglerImpl;
import com.xuggle.ferry.JNILibrary;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XugglerAutoInstallHelper {
    private static final Log _log = LogFactoryUtil.getLog(XugglerAutoInstallHelper.class);
    private static final Pattern _pattern = Pattern.compile("(.*)-\\d+-\\d+(\\.jar)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installNativeLibraries() throws ProcessException {
        if (XugglerAutoInstallHelper._isNativeLibraryInstalled()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Xuggler is already installed");
            }
            return;
        }
        String xugglerJarFile = XugglerAutoInstallHelper._getXugglerJarFileName();
        if (xugglerJarFile == null) {
            _log.error((Object)("Xuggler auto install is not supported on system: " + System.getProperty("os.name") + "/" + System.getProperty("os.arch")));
            return;
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        PortalClassLoaderUtil.setClassLoader((ClassLoader)ClassLoader.getSystemClassLoader());
        try {
            XugglerImpl xuggler = new XugglerImpl();
            try {
                xuggler.installNativeLibraries(xugglerJarFile);
            }
            catch (XugglerInstallException.MustBeURLClassLoader xie) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)xie, (Throwable)xie);
                }
            }
            catch (Exception e) {
                throw new ProcessException((Throwable)e);
            }
            if (xuggler.isNativeLibraryInstalled()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Xuggler installed successfully");
                }
            } else {
                _log.error((Object)"Xuggler auto install failed");
            }
        }
        finally {
            PortalClassLoaderUtil.setClassLoader((ClassLoader)classLoader);
        }
    }

    private static String _getXugglerJarFileName() {
        String bitmode = OSDetector.getBitmode();
        if (Validator.isNull((String)bitmode) || !bitmode.equals("32") && !bitmode.equals("64")) {
            return null;
        }
        if (OSDetector.isApple()) {
            return PropsUtil.get("xuggler.jar.file", new Filter(bitmode + "-mac"));
        }
        if (OSDetector.isLinux()) {
            return PropsUtil.get("xuggler.jar.file", new Filter(bitmode + "-linux"));
        }
        if (OSDetector.isWindows()) {
            return PropsUtil.get("xuggler.jar.file", new Filter(bitmode + "-win"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean _isNativeLibraryInstalled() {
        Properties properties = PropsUtil.getProperties("xuggler.jar.file", false);
        Set jarFiles = SetUtil.fromCollection(properties.values());
        jarFiles.remove(XugglerAutoInstallHelper._getXugglerJarFileName());
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Set urls = ClassPathUtil.getClassPathURLs((ClassLoader)contextClassLoader);
        Iterator iterator = urls.iterator();
        while (iterator.hasNext()) {
            File file;
            Matcher matcher;
            URL url = (URL)iterator.next();
            String protocol = url.getProtocol();
            if (!protocol.equals("file") || !(matcher = _pattern.matcher((file = new File(url.getPath())).getName())).matches() || !jarFiles.contains(matcher.replaceAll("$1$2"))) continue;
            file.delete();
            iterator.remove();
        }
        URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        currentThread.setContextClassLoader(urlClassLoader);
        try {
            Class<?> clazz = urlClassLoader.loadClass(IsNativeLibraryInstalledCallable.class.getName());
            Callable callable = (Callable)clazz.newInstance();
            boolean bl = (Boolean)callable.call();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public static class IsNativeLibraryInstalledCallable
    implements Callable<Boolean> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            PrintStream printStream = System.out;
            System.setOut(new PrintStream((OutputStream)new DummyOutputStream()));
            Package pkg = JNILibrary.class.getPackage();
            Logger logger = Logger.getLogger(pkg.getName());
            Level level = logger.getLevel();
            logger.setLevel(Level.OFF);
            String property = System.getProperty("java.util.logging.config.file");
            System.setProperty("java.util.logging.config.file", "configFile");
            XugglerImpl xuggler = new XugglerImpl();
            Field informAdministratorField = ReflectionUtil.getDeclaredField(XugglerImpl.class, (String)"_informAdministrator");
            informAdministratorField.setBoolean(xuggler, false);
            try {
                Boolean bl = xuggler.isNativeLibraryInstalled();
                return bl;
            }
            finally {
                if (property == null) {
                    System.clearProperty("java.util.logging.config.file");
                } else {
                    System.setProperty("java.util.logging.config.file", property);
                }
                logger.setLevel(level);
                System.setOut(printStream);
            }
        }
    }
}

