/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@OSGiBeanProperties
public class AssetCategoryIndexer
extends BaseIndexer<AssetCategory> {
    public static final String CLASS_NAME = AssetCategory.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(AssetCategoryIndexer.class);

    public AssetCategoryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetCategoryId", "companyId", "groupId", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        AssetCategory category = AssetCategoryLocalServiceUtil.getCategory((long)entryClassPK);
        return AssetCategoryPermission.contains(permissionChecker, category, "VIEW");
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long[] vocabularyIds;
        long[] parentCategoryIds = (long[])searchContext.getAttribute("parentCategoryIds");
        if (!ArrayUtil.isEmpty((long[])parentCategoryIds)) {
            TermsFilter parentCategoryTermsFilter = new TermsFilter("parentCategoryId");
            parentCategoryTermsFilter.addValues(ArrayUtil.toStringArray((long[])parentCategoryIds));
            contextBooleanFilter.add((Filter)parentCategoryTermsFilter, BooleanClauseOccur.MUST);
        }
        if (!ArrayUtil.isEmpty((long[])(vocabularyIds = (long[])searchContext.getAttribute("assetVocabularyIds")))) {
            TermsFilter vocabularyTermsFilter = new TermsFilter("assetVocabularyId");
            vocabularyTermsFilter.addValues(ArrayUtil.toStringArray((long[])vocabularyIds));
            contextBooleanFilter.add((Filter)vocabularyTermsFilter, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String title = (String)((Object)searchContext.getAttribute("title"));
        if (Validator.isNotNull((String)title)) {
            BooleanQueryImpl localizedQuery = new BooleanQueryImpl();
            searchContext.setAttribute("assetCategoryTitle", (Serializable)((Object)title));
            this.addSearchLocalizedTerm((BooleanQuery)localizedQuery, searchContext, "assetCategoryTitle", true);
            this.addSearchLocalizedTerm((BooleanQuery)localizedQuery, searchContext, "title", true);
            searchQuery.add((Query)localizedQuery, BooleanClauseOccur.SHOULD);
        }
    }

    protected void doDelete(AssetCategory assetCategory) throws Exception {
        this.deleteDocument(assetCategory.getCompanyId(), assetCategory.getCategoryId());
    }

    protected Document doGetDocument(AssetCategory assetCategory) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing asset category " + assetCategory));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)assetCategory);
        document.addKeyword("assetCategoryId", assetCategory.getCategoryId());
        ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>(1);
        categories.add(assetCategory);
        this.addSearchAssetCategoryTitles(document, "assetCategoryTitle", categories);
        document.addKeyword("parentCategoryId", assetCategory.getParentCategoryId());
        document.addKeyword("assetVocabularyId", assetCategory.getVocabularyId());
        Locale siteDefaultLocale = PortalUtil.getSiteDefaultLocale((long)assetCategory.getGroupId());
        this.addLocalizedField(document, "description", siteDefaultLocale, assetCategory.getDescriptionMap());
        document.addText("name", assetCategory.getName());
        this.addLocalizedField(document, "title", siteDefaultLocale, assetCategory.getTitleMap());
        document.addKeyword("leftCategoryId", assetCategory.getLeftCategoryId());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + assetCategory + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(AssetCategory assetCategory) throws Exception {
        Document document = this.getDocument(assetCategory);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)assetCategory.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        AssetCategory category = AssetCategoryLocalServiceUtil.getCategory((long)classPK);
        this.doReindex(category);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
    }

    protected void reindexCategories(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = AssetCategoryLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<AssetCategory>(){

            public void performAction(AssetCategory category) {
                block3: {
                    try {
                        Document document = AssetCategoryIndexer.this.getDocument(category);
                        if (document != null) {
                            indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                        }
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to index asset category " + category.getCategoryId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

