/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.permission;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.PortalUtil;

public class AssetEntryPermission {
    public static void check(PermissionChecker permissionChecker, AssetEntry entry, String actionId) throws PortalException {
        if (!AssetEntryPermission.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, PortalUtil.getClassName((long)entry.getClassNameId()), entry.getClassPK(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        AssetEntry entry = AssetEntryLocalServiceUtil.getEntry((long)entryId);
        AssetEntryPermission.check(permissionChecker, entry, actionId);
    }

    public static void check(PermissionChecker permissionChecker, String className, long classPK, String actionId) throws PortalException {
        if (!AssetEntryPermission.contains(permissionChecker, className, classPK, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, AssetEntry entry, String actionId) throws PortalException {
        String className = PortalUtil.getClassName((long)entry.getClassNameId());
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        try {
            return assetRendererFactory.hasPermission(permissionChecker, entry.getClassPK(), actionId);
        }
        catch (Exception e) {
            throw new PrincipalException.MustHavePermission(permissionChecker, className, entry.getClassPK(), (Throwable)e, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        AssetEntry entry = AssetEntryLocalServiceUtil.getEntry((long)entryId);
        return AssetEntryPermission.contains(permissionChecker, entry, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, String className, long classPK, String actionId) throws PortalException {
        AssetEntry entry = AssetEntryLocalServiceUtil.getEntry((String)className, (long)classPK);
        return AssetEntryPermission.contains(permissionChecker, entry, actionId);
    }
}

