/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_3;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class UpgradeOracle
extends UpgradeProcess {
    private static final int[] _ORIGINAL_DATA_LENGTH_VALUES = new int[]{75, 100, 150, 200, 255, 500, 1000, 1024, 2000, 4000};
    private static final Log _log = LogFactoryUtil.getLog(UpgradeOracle.class);
    private static final Set<String> _tableNames = new HashSet<String>(Arrays.asList("account_", "address", "announcementsdelivery", "announcementsentry", "announcementsflag", "assetcategory", "assetcategoryproperty", "assetentries_assetcategories", "assetentries_assettags", "assetentry", "assetlink", "assettag", "assettagstats", "assetvocabulary", "backgroundtask", "blogsentry", "blogsstatsuser", "bookmarksentry", "bookmarksfolder", "browsertracker", "classname_", "clustergroup", "company", "contact_", "counter", "country", "ddlrecord", "ddlrecordset", "ddlrecordversion", "ddmcontent", "ddmstoragelink", "ddmstructure", "ddmstructurelink", "ddmtemplate", "dlcontent", "dlfileentry", "dlfileentrymetadata", "dlfileentrytype", "dlfileentrytypes_dlfolders", "dlfilerank", "dlfileshortcut", "dlfileversion", "dlfolder", "dlsyncevent", "emailaddress", "expandocolumn", "expandorow", "expandotable", "expandovalue", "exportimportconfiguration", "group_", "groups_orgs", "groups_roles", "groups_usergroups", "image", "journalarticle", "journalarticleimage", "journalarticleresource", "journalcontentsearch", "journalfeed", "journalfolder", "layout", "layoutbranch", "layoutfriendlyurl", "layoutprototype", "layoutrevision", "layoutset", "layoutsetbranch", "layoutsetprototype", "listtype", "lock_", "mbban", "mbcategory", "mbdiscussion", "mbmailinglist", "mbmessage", "mbstatsuser", "mbthread", "mbthreadflag", "mdraction", "mdrrule", "mdrrulegroup", "mdrrulegroupinstance", "membershiprequest", "organization_", "orggrouprole", "orglabor", "passwordpolicy", "passwordpolicyrel", "passwordtracker", "phone", "pluginsetting", "pollschoice", "pollsquestion", "pollsvote", "portalpreferences", "portlet", "portletitem", "portletpreferences", "ratingsentry", "ratingsstats", "recentlayoutbranch", "recentlayoutrevision", "recentlayoutsetbranch", "region", "release_", "repository", "repositoryentry", "resourceaction", "resourceblock", "resourceblockpermission", "resourcepermission", "resourcetypepermission", "role_", "servicecomponent", "shoppingcart", "shoppingcategory", "shoppingcoupon", "shoppingitem", "shoppingitemfield", "shoppingitemprice", "shoppingorder", "shoppingorderitem", "socialactivity", "socialactivityachievement", "socialactivitycounter", "socialactivitylimit", "socialactivityset", "socialactivitysetting", "socialrelation", "socialrequest", "subscription", "systemevent", "team", "ticket", "trashentry", "trashversion", "usernotificationdelivery", "user_", "usergroup", "usergroupgrouprole", "usergrouprole", "usergroups_teams", "useridmapper", "usernotificationevent", "users_groups", "users_orgs", "users_roles", "users_teams", "users_usergroups", "usertracker", "usertrackerpath", "virtualhost", "webdavprops", "website", "wikinode", "wikipage", "wikipageresource", "workflowdefinitionlink", "workflowinstancelink"));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void alterVarchar2Columns() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select table_name, column_name, data_length from user_tab_columns where data_type = 'VARCHAR2' and char_used = 'B'");
             ResultSet rs = ps.executeQuery();){
            int buildNumber = this.getBuildNumber();
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (!_tableNames.contains(StringUtil.toLowerCase((String)tableName))) continue;
                String columnName = rs.getString(2);
                int dataLength = rs.getInt(3);
                if ((this.isBetweenBuildNumbers(buildNumber, 5209, 6000) || this.isBetweenBuildNumbers(buildNumber, 6005, 6200)) && !ArrayUtil.contains((int[])_ORIGINAL_DATA_LENGTH_VALUES, (int)dataLength)) {
                    dataLength /= 4;
                }
                try {
                    this.runSQL("alter table " + tableName + " modify " + columnName + " varchar2(" + dataLength + " char)");
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() != 1441) throw sqle;
                    if (!_log.isWarnEnabled()) continue;
                    StringBundler sb = new StringBundler(6);
                    sb.append("Unable to alter length of column ");
                    sb.append(columnName);
                    sb.append(" for table ");
                    sb.append(tableName);
                    sb.append(" because it contains values that are ");
                    sb.append("larger than the new column length");
                    _log.warn((Object)sb.toString());
                    continue;
                    return;
                }
            }
        }
    }

    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.ORACLE) {
            return;
        }
        this.alterVarchar2Columns();
    }

    /*
     * Exception decompiling
     */
    protected int getBuildNumber() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean isBetweenBuildNumbers(int buildNumber, int startBuildNumber, int endBuildNumber) {
        return buildNumber >= startBuildNumber && buildNumber < endBuildNumber;
    }
}

