/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.WorkflowInstanceLink;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class UpgradeSubscription
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeSubscription.class);
    private static final Map<String, String> _getGroupIdSQLPartsMap = new HashMap<String, String>();

    protected void addClassName(long classNameId, String className) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("insert into ClassName_ (mvccVersion, classNameId, value) values (?, ?, ?)");){
            ps.setLong(1, 0L);
            ps.setLong(2, classNameId);
            ps.setString(3, className);
            ps.executeUpdate();
        }
    }

    protected void deleteOrphanedSubscriptions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long classNameId = PortalUtil.getClassNameId((String)PortletPreferences.class.getName());
            this.runSQL("delete from Subscription where classNameId = " + classNameId + " and classPK not in (select portletPreferencesId from PortletPreferences)");
        }
    }

    protected void doUpgrade() throws Exception {
        this.deleteOrphanedSubscriptions();
        this.updateSubscriptionClassNames(Folder.class.getName(), DLFolder.class.getName());
        this.updateSubscriptionClassNames("com.liferay.portlet.journal.model.JournalArticle", "com.liferay.portlet.journal.model.JournalFolder");
        this.updateSubscriptionGroupIds();
    }

    protected long getClassNameId(String className) throws Exception {
        long classNameId = PortalUtil.getClassNameId((String)className);
        if (classNameId != 0L) {
            return classNameId;
        }
        classNameId = this.increment();
        this.addClassName(classNameId, className);
        return classNameId;
    }

    protected long getGroupId(long classNameId, long classPK) throws Exception {
        String className = PortalUtil.getClassName((long)classNameId);
        Object[] groupIdSQLParts = StringUtil.split((String)_getGroupIdSQLPartsMap.get(className));
        if (ArrayUtil.isEmpty((Object[])groupIdSQLParts)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to determine the group ID for the class name " + className));
            }
            return 0L;
        }
        String sql = "select " + (String)groupIdSQLParts[1] + " from " + (String)groupIdSQLParts[0] + " where " + (String)groupIdSQLParts[2] + " = ?";
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            ps.setLong(1, classPK);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    long l = rs.getLong("groupId");
                    return l;
                }
            }
        }
        return 0L;
    }

    protected boolean hasGroup(long groupId) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select count(*) from Group_ where groupId = ?");){
            ps.setLong(1, groupId);
            try (ResultSet rs = ps.executeQuery();){
                int count;
                if (rs.next() && (count = rs.getInt(1)) > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    protected void updateSubscriptionClassNames(String oldClassName, String newClassName) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(oldClassName);){
            StringBundler sb = new StringBundler(4);
            sb.append("update Subscription set classNameId = ");
            sb.append(this.getClassNameId(newClassName));
            sb.append(" where classNameId = ");
            sb.append(PortalUtil.getClassNameId((String)oldClassName));
            this.runSQL(sb.toString());
        }
    }

    @Deprecated
    protected void updateSubscriptionGroupId(long subscriptionId, long classNameId, long classPK) throws Exception {
    }

    protected void updateSubscriptionGroupIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select subscriptionId, classNameId, classPK from Subscription");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update Subscription set groupId = ? where subscriptionId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long classPK;
                long subscriptionId = rs.getLong("subscriptionId");
                long classNameId = rs.getLong("classNameId");
                long groupId = this.getGroupId(classNameId, classPK = rs.getLong("classPK"));
                if (groupId == 0L && this.hasGroup(classPK)) {
                    groupId = classPK;
                }
                if (groupId == 0L) continue;
                ps2.setLong(1, groupId);
                ps2.setLong(2, subscriptionId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    static {
        _getGroupIdSQLPartsMap.put(DLFileEntry.class.getName(), "DLFileEntry,groupId,fileEntryId");
        _getGroupIdSQLPartsMap.put(DLFileEntryType.class.getName(), "DLFileEntryType,groupId,fileEntryTypeId");
        _getGroupIdSQLPartsMap.put(DLFolder.class.getName(), "DLFolder,groupId,folderId");
        _getGroupIdSQLPartsMap.put(Layout.class.getName(), "Layout,groupId,plid");
        _getGroupIdSQLPartsMap.put(MBCategory.class.getName(), "MBCategory,groupId,categoryId");
        _getGroupIdSQLPartsMap.put(MBThread.class.getName(), "MBThread,groupId,threadId");
        _getGroupIdSQLPartsMap.put(WorkflowInstanceLink.class.getName(), "WorkflowInstanceLink,groupId,workflowInstanceId");
        _getGroupIdSQLPartsMap.put("com.liferay.blogs.kernel.model.BlogsEntry", "BlogsEntry,groupId,entryId");
        _getGroupIdSQLPartsMap.put("com.liferay.portlet.bookmarks.model.BookmarksEntry", "BookmarksEntry,groupId,entryId");
        _getGroupIdSQLPartsMap.put("com.liferay.portlet.bookmarks.model.BookmarksFolder", "BookmarksFolder,groupId,folderId");
        _getGroupIdSQLPartsMap.put("com.liferay.portlet.dynamic.data.mapping.kernel.DDMStructure", "DDMStructure,groupId,structureId");
        _getGroupIdSQLPartsMap.put("com.liferay.portlet.journal.model.JournalFolder", "JournalFolder,groupId,folderId");
        _getGroupIdSQLPartsMap.put("com.liferay.portlet.wiki.model.WikiNode", "WikiNode,groupId,nodeId");
        _getGroupIdSQLPartsMap.put("com.liferay.portlet.wiki.model.WikiPage", "WikiPage,groupId,resourcePrimKey");
    }
}

