/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.context;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.spring.bean.BeanReferenceRefreshUtil;
import com.liferay.portal.spring.context.PortletApplicationContext;
import com.liferay.portal.spring.context.PortletBeanFactoryCleaner;
import com.liferay.portal.spring.context.PortletBeanFactoryPostProcessor;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortletContextLoaderListener
extends ContextLoaderListener {
    private static final String _PORTAL_CONFIG_LOCATION_PARAM = "portalContextConfigLocation";
    private static final Log _log = LogFactoryUtil.getLog(PortletContextLoaderListener.class);

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        block2: {
            ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
            ServletContext servletContext = servletContextEvent.getServletContext();
            try {
                Class<?> beanLocatorUtilClass = Class.forName("com.liferay.util.bean.PortletBeanLocatorUtil", true, classLoader);
                Method setBeanLocatorMethod = beanLocatorUtilClass.getMethod("setBeanLocator", BeanLocator.class);
                setBeanLocatorMethod.invoke(beanLocatorUtilClass, new Object[]{null});
                PortletBeanLocatorUtil.setBeanLocator((String)servletContext.getServletContextName(), null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        super.contextDestroyed(servletContextEvent);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        MethodCache.reset();
        ServletContext servletContext = servletContextEvent.getServletContext();
        Object previousApplicationContext = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
        super.contextInitialized(servletContextEvent);
        PortletBeanFactoryCleaner.readBeans();
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        try {
            BeanReferenceRefreshUtil.refresh((BeanFactory)applicationContext.getAutowireCapableBeanFactory());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        BeanLocatorImpl beanLocatorImpl = new BeanLocatorImpl(classLoader, (ApplicationContext)applicationContext);
        beanLocatorImpl.setPACLServletContextName(servletContext.getServletContextName());
        try {
            Class<?> beanLocatorUtilClass = Class.forName("com.liferay.util.bean.PortletBeanLocatorUtil", true, classLoader);
            Method setBeanLocatorMethod = beanLocatorUtilClass.getMethod("setBeanLocator", BeanLocator.class);
            setBeanLocatorMethod.invoke(beanLocatorUtilClass, beanLocatorImpl);
            PortletBeanLocatorUtil.setBeanLocator((String)servletContext.getServletContextName(), (BeanLocator)beanLocatorImpl);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (previousApplicationContext == null) {
            servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        } else {
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, previousApplicationContext);
        }
    }

    protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext configurableWebApplicationContext) {
        String configLocation = servletContext.getInitParameter(_PORTAL_CONFIG_LOCATION_PARAM);
        configurableWebApplicationContext.setConfigLocation(configLocation);
        configurableWebApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PortletBeanFactoryPostProcessor());
    }

    protected Class<?> determineContextClass(ServletContext servletContext) {
        return PortletApplicationContext.class;
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) {
        return super.loadParentContext(servletContext);
    }
}

