/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.authverifier;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PropsUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthVerifierFilter
extends BasePortalFilter {
    private static final Log _log = LogFactoryUtil.getLog((String)AuthVerifierFilter.class.getName());
    private final Set<String> _hostsAllowed = new HashSet<String>();
    private boolean _httpsRequired;
    private final Map<String, Object> _initParametersMap = new HashMap<String, Object>();

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        Enumeration enu = filterConfig.getInitParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = filterConfig.getInitParameter(name);
            this._initParametersMap.put(name, value);
        }
        String portalPropertyPrefix = GetterUtil.getString((Object)this._initParametersMap.get("portal_property_prefix"));
        if (Validator.isNotNull((String)portalPropertyPrefix)) {
            Properties properties = PropsUtil.getProperties(portalPropertyPrefix, true);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this._initParametersMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (this._initParametersMap.containsKey("hosts.allowed")) {
            String[] hostsAllowed;
            String hostsAllowedString = (String)this._initParametersMap.get("hosts.allowed");
            for (String hostAllowed : hostsAllowed = StringUtil.split((String)hostsAllowedString)) {
                this._hostsAllowed.add(hostAllowed);
            }
            this._initParametersMap.remove("hosts.allowed");
        }
        if (this._initParametersMap.containsKey("https.required")) {
            this._httpsRequired = GetterUtil.getBoolean((Object)this._initParametersMap.get("https.required"));
            this._initParametersMap.remove("https.required");
        }
        if (this._initParametersMap.containsKey("use_permission_checker")) {
            this._initParametersMap.remove("use_permission_checker");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"use_permission_checker is deprecated");
            }
        }
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        if (!this._isAccessAllowed(request, response)) {
            return;
        }
        if (this._isApplySSL(request, response)) {
            return;
        }
        AccessControlUtil.initAccessControlContext((HttpServletRequest)request, (HttpServletResponse)response, this._initParametersMap);
        AuthVerifierResult.State state = AccessControlUtil.verifyRequest();
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        AuthVerifierResult authVerifierResult = accessControlContext.getAuthVerifierResult();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Auth verifier result " + authVerifierResult));
        }
        if (state == AuthVerifierResult.State.INVALID_CREDENTIALS) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Result state doesn't allow us to continue.");
            }
        } else if (state == AuthVerifierResult.State.NOT_APPLICABLE) {
            _log.error((Object)("Invalid state " + state));
        } else if (state == AuthVerifierResult.State.SUCCESS) {
            long userId = authVerifierResult.getUserId();
            AccessControlUtil.initContextUser((long)userId);
            String authType = MapUtil.getString((Map)accessControlContext.getSettings(), (String)"auth.type");
            ProtectedServletRequest protectedServletRequest = new ProtectedServletRequest(request, String.valueOf(userId), authType);
            accessControlContext.setRequest((HttpServletRequest)protectedServletRequest);
            Class<?> clazz = ((Object)((Object)this)).getClass();
            this.processFilter(clazz.getName(), (HttpServletRequest)protectedServletRequest, response, filterChain);
        } else {
            _log.error((Object)("Unimplemented state " + state));
        }
    }

    private boolean _isAccessAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String remoteAddr = request.getRemoteAddr();
        if (AccessControlUtil.isAccessAllowed((HttpServletRequest)request, this._hostsAllowed)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Access allowed for " + remoteAddr));
            }
            return true;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Access denied for " + remoteAddr));
        }
        response.sendError(403, "Access denied for " + remoteAddr);
        return false;
    }

    private boolean _isApplySSL(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this._httpsRequired || request.isSecure()) {
            return false;
        }
        if (_log.isDebugEnabled()) {
            String completeURL = HttpUtil.getCompleteURL((HttpServletRequest)request);
            _log.debug((Object)("Securing " + completeURL));
        }
        StringBundler redirectURL = new StringBundler(5);
        redirectURL.append("https://");
        redirectURL.append(request.getServerName());
        redirectURL.append(request.getServletPath());
        String queryString = request.getQueryString();
        if (Validator.isNotNull((String)queryString)) {
            redirectURL.append("?");
            redirectURL.append(request.getQueryString());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirect to " + redirectURL));
        }
        response.sendRedirect(redirectURL.toString());
        return true;
    }
}

