/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.announcements.kernel.model.AnnouncementsDelivery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredUserException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserFieldException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.membershippolicy.RoleMembershipPolicyUtil;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.security.membershippolicy.UserGroupMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.PasswordPolicyPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.service.permission.TeamPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupRolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.service.base.UserServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UserServiceImpl
extends UserServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(UserServiceImpl.class);

    public void addGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"ASSIGN_MEMBERS")) {
            User user;
            boolean hasPermission = false;
            if (userIds.length == 1 && (user = this.getUser()).getUserId() == userIds[0]) {
                int type;
                Group group = this.groupPersistence.findByPrimaryKey(groupId);
                if (user.getCompanyId() == group.getCompanyId() && (type = group.getType()) == 1) {
                    hasPermission = true;
                }
            }
            if (!hasPermission) {
                throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), groupId, new String[]{"ASSIGN_MEMBERS"});
            }
        }
        SiteMembershipPolicyUtil.checkMembership((long[])userIds, (long[])new long[]{groupId}, null);
        this.userLocalService.addGroupUsers(groupId, userIds);
        SiteMembershipPolicyUtil.propagateMembership((long[])userIds, (long[])new long[]{groupId}, null);
    }

    public void addOrganizationUsers(long organizationId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"ASSIGN_MEMBERS");
        this.validateOrganizationUsers(userIds);
        OrganizationMembershipPolicyUtil.checkMembership((long[])userIds, (long[])new long[]{organizationId}, null);
        this.userLocalService.addOrganizationUsers(organizationId, userIds);
        OrganizationMembershipPolicyUtil.propagateMembership((long[])userIds, (long[])new long[]{organizationId}, null);
    }

    public void addPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.addPasswordPolicyUsers(passwordPolicyId, userIds);
    }

    public void addRoleUsers(long roleId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        RoleMembershipPolicyUtil.checkRoles((long[])userIds, (long[])new long[]{roleId}, null);
        this.userLocalService.addRoleUsers(roleId, userIds);
        RoleMembershipPolicyUtil.propagateRoles((long[])userIds, (long[])new long[]{roleId}, null);
    }

    public void addTeamUsers(long teamId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.addTeamUsers(teamId, userIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User addUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            User user = this.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            return user;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User addUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            User user = this.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, addresses, emailAddresses, phones, websites, announcementsDelivers, sendEmail, serviceContext);
            return user;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public void addUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"ASSIGN_MEMBERS");
        UserGroupMembershipPolicyUtil.checkMembership((long[])userIds, (long[])new long[]{userGroupId}, null);
        this.userLocalService.addUserGroupUsers(userGroupId, userIds);
        UserGroupMembershipPolicyUtil.propagateMembership((long[])userIds, (long[])new long[]{userGroupId}, null);
    }

    public User addUserWithWorkflow(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        long creatorUserId;
        block2: {
            creatorUserId = 0L;
            try {
                creatorUserId = this.getGuestOrUserId();
            }
            catch (PrincipalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to get guest or current user ID", (Throwable)pe);
            }
        }
        this.checkAddUserPermission(creatorUserId, companyId, emailAddress, groupIds, organizationIds, roleIds, userGroupIds, serviceContext);
        User user = this.userLocalService.addUserWithWorkflow(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        this.checkMembership(new long[]{user.getUserId()}, groupIds, organizationIds, roleIds, userGroupIds);
        this.propagateMembership(new long[]{user.getUserId()}, groupIds, organizationIds, roleIds, userGroupIds);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User addUserWithWorkflow(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        boolean indexingEnabled = true;
        if (serviceContext != null) {
            indexingEnabled = serviceContext.isIndexingEnabled();
            serviceContext.setIndexingEnabled(false);
        }
        try {
            User user = this.addUserWithWorkflow(companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            UsersAdminUtil.updateAddresses((String)Contact.class.getName(), (long)user.getContactId(), addresses);
            UsersAdminUtil.updateEmailAddresses((String)Contact.class.getName(), (long)user.getContactId(), emailAddresses);
            UsersAdminUtil.updatePhones((String)Contact.class.getName(), (long)user.getContactId(), phones);
            UsersAdminUtil.updateWebsites((String)Contact.class.getName(), (long)user.getContactId(), websites);
            this.updateAnnouncementsDeliveries(user.getUserId(), announcementsDelivers);
            if (indexingEnabled) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
                indexer.reindex((Object)user);
            }
            User user2 = user;
            return user2;
        }
        finally {
            if (serviceContext != null) {
                serviceContext.setIndexingEnabled(indexingEnabled);
            }
        }
    }

    public void deletePortrait(long userId) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        this.userLocalService.deletePortrait(userId);
    }

    public void deleteRoleUser(long roleId, long userId) throws PortalException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.deleteRoleUser(roleId, userId);
    }

    public void deleteUser(long userId) throws PortalException {
        if (this.getUserId() == userId) {
            throw new RequiredUserException();
        }
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"DELETE");
        this.userLocalService.deleteUser(userId);
    }

    public List<User> getCompanyUsers(long companyId, int start, int end) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(companyId)) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this.userPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyUsersCount(long companyId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isCompanyAdmin(companyId)) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        return this.userPersistence.countByCompanyId(companyId);
    }

    public User getCurrentUser() throws PortalException {
        return this.getUser();
    }

    public long[] getGroupUserIds(long groupId) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW_MEMBERS");
        return this.userLocalService.getGroupUserIds(groupId);
    }

    public List<User> getGroupUsers(long groupId) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW_MEMBERS");
        return this.userLocalService.getGroupUsers(groupId);
    }

    public long[] getOrganizationUserIds(long organizationId) throws PortalException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"VIEW_MEMBERS");
        return this.userLocalService.getOrganizationUserIds(organizationId);
    }

    public List<User> getOrganizationUsers(long organizationId) throws PortalException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"VIEW_MEMBERS");
        return this.userLocalService.getOrganizationUsers(organizationId);
    }

    public long[] getRoleUserIds(long roleId) throws PortalException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"VIEW");
        return this.userLocalService.getRoleUserIds(roleId);
    }

    public User getUserByEmailAddress(long companyId, String emailAddress) throws PortalException {
        User user = this.userLocalService.getUserByEmailAddress(companyId, emailAddress);
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)user.getUserId(), (String)"VIEW");
        return user;
    }

    public User getUserById(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)user.getUserId(), (String)"VIEW");
        return user;
    }

    public User getUserByScreenName(long companyId, String screenName) throws PortalException {
        User user = this.userLocalService.getUserByScreenName(companyId, screenName);
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)user.getUserId(), (String)"VIEW");
        return user;
    }

    public List<User> getUserGroupUsers(long userGroupId) throws PortalException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"VIEW_MEMBERS");
        return this.userGroupPersistence.getUsers(userGroupId);
    }

    public long getUserIdByEmailAddress(long companyId, String emailAddress) throws PortalException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)user.getUserId(), (String)"VIEW");
        return user.getUserId();
    }

    public long getUserIdByScreenName(long companyId, String screenName) throws PortalException {
        User user = this.getUserByScreenName(companyId, screenName);
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)user.getUserId(), (String)"VIEW");
        return user.getUserId();
    }

    public boolean hasGroupUser(long groupId, long userId) throws PortalException {
        if (!UserPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW")) {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW_MEMBERS");
        }
        return this.userLocalService.hasGroupUser(groupId, userId);
    }

    public boolean hasRoleUser(long roleId, long userId) throws PortalException {
        if (!UserPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW")) {
            RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"VIEW_MEMBERS");
        }
        return this.userLocalService.hasRoleUser(roleId, userId);
    }

    public boolean hasRoleUser(long companyId, String name, long userId, boolean inherited) throws PortalException {
        if (!UserPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW")) {
            Role role = this.roleLocalService.getRole(companyId, name);
            RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)role.getRoleId(), (String)"VIEW_MEMBERS");
        }
        return this.userLocalService.hasRoleUser(companyId, name, userId, inherited);
    }

    public boolean sendPasswordByEmailAddress(long companyId, String emailAddress) throws PortalException {
        return this.userLocalService.sendPasswordByEmailAddress(companyId, emailAddress);
    }

    public boolean sendPasswordByScreenName(long companyId, String screenName) throws PortalException {
        return this.userLocalService.sendPasswordByScreenName(companyId, screenName);
    }

    public boolean sendPasswordByUserId(long userId) throws PortalException {
        return this.userLocalService.sendPasswordByUserId(userId);
    }

    public void setRoleUsers(long roleId, long[] userIds) throws PortalException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        Set unsetUserIds = SetUtil.fromArray((long[])this.rolePersistence.getUserPrimaryKeys(roleId));
        unsetUserIds.removeAll(SetUtil.fromArray((long[])userIds));
        if (!unsetUserIds.isEmpty()) {
            RoleMembershipPolicyUtil.checkRoles((long[])ArrayUtil.toLongArray((Collection)unsetUserIds), null, (long[])new long[]{roleId});
        }
        if (userIds.length > 0) {
            RoleMembershipPolicyUtil.checkRoles((long[])userIds, (long[])new long[]{roleId}, null);
        }
        this.userLocalService.setRoleUsers(roleId, userIds);
        if (!unsetUserIds.isEmpty()) {
            RoleMembershipPolicyUtil.propagateRoles((long[])ArrayUtil.toLongArray((Collection)unsetUserIds), null, (long[])new long[]{roleId});
        }
        if (userIds.length > 0) {
            RoleMembershipPolicyUtil.propagateRoles((long[])userIds, (long[])new long[]{roleId}, null);
        }
    }

    public void setUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"ASSIGN_MEMBERS");
        Set unsetUserIds = SetUtil.fromArray((long[])this.userGroupPersistence.getUserPrimaryKeys(userGroupId));
        unsetUserIds.removeAll(SetUtil.fromArray((long[])userIds));
        if (!unsetUserIds.isEmpty()) {
            UserGroupMembershipPolicyUtil.checkMembership((long[])ArrayUtil.toLongArray((Collection)unsetUserIds), null, (long[])new long[]{userGroupId});
        }
        if (userIds.length > 0) {
            UserGroupMembershipPolicyUtil.checkMembership((long[])userIds, (long[])new long[]{userGroupId}, null);
        }
        this.userLocalService.setUserGroupUsers(userGroupId, userIds);
        if (!unsetUserIds.isEmpty()) {
            UserGroupMembershipPolicyUtil.propagateMembership((long[])ArrayUtil.toLongArray((Collection)unsetUserIds), null, (long[])new long[]{userGroupId});
        }
        if (userIds.length > 0) {
            UserGroupMembershipPolicyUtil.propagateMembership((long[])userIds, (long[])new long[]{userGroupId}, null);
        }
    }

    public void unsetGroupTeamsUsers(long groupId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.unsetGroupTeamsUsers(groupId, userIds);
    }

    public void unsetGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException {
        userIds = UsersAdminUtil.filterUnsetGroupUserIds((PermissionChecker)this.getPermissionChecker(), (long)groupId, (long[])userIds);
        if (userIds.length == 0) {
            return;
        }
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"ASSIGN_MEMBERS")) {
            User user;
            boolean hasPermission = false;
            if (userIds.length == 1 && (user = this.getUser()).getUserId() == userIds[0]) {
                int type;
                Group group = this.groupPersistence.findByPrimaryKey(groupId);
                if (user.getCompanyId() == group.getCompanyId() && ((type = group.getType()) == 1 || type == 2)) {
                    hasPermission = true;
                }
            }
            if (!hasPermission) {
                throw new PrincipalException.MustHavePermission(permissionChecker, Group.class.getName(), groupId, new String[]{"ASSIGN_MEMBERS"});
            }
        }
        SiteMembershipPolicyUtil.checkMembership((long[])userIds, null, (long[])new long[]{groupId});
        this.userLocalService.unsetGroupUsers(groupId, userIds, serviceContext);
        SiteMembershipPolicyUtil.propagateMembership((long[])userIds, null, (long[])new long[]{groupId});
    }

    public void unsetOrganizationUsers(long organizationId, long[] userIds) throws PortalException {
        userIds = UsersAdminUtil.filterUnsetOrganizationUserIds((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (long[])userIds);
        if (userIds.length == 0) {
            return;
        }
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"ASSIGN_MEMBERS");
        OrganizationMembershipPolicyUtil.checkMembership((long[])userIds, null, (long[])new long[]{organizationId});
        this.userLocalService.unsetOrganizationUsers(organizationId, userIds);
        OrganizationMembershipPolicyUtil.propagateMembership((long[])userIds, null, (long[])new long[]{organizationId});
    }

    public void unsetPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.unsetPasswordPolicyUsers(passwordPolicyId, userIds);
    }

    public void unsetRoleUsers(long roleId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        RoleMembershipPolicyUtil.checkRoles((long[])userIds, null, (long[])new long[]{roleId});
        this.userLocalService.unsetRoleUsers(roleId, userIds);
        RoleMembershipPolicyUtil.propagateRoles((long[])userIds, null, (long[])new long[]{roleId});
    }

    public void unsetTeamUsers(long teamId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"ASSIGN_MEMBERS");
        this.userLocalService.unsetTeamUsers(teamId, userIds);
    }

    public void unsetUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        if (userIds.length == 0) {
            return;
        }
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"ASSIGN_MEMBERS");
        UserGroupMembershipPolicyUtil.checkMembership((long[])userIds, null, (long[])new long[]{userGroupId});
        this.userLocalService.unsetUserGroupUsers(userGroupId, userIds);
        UserGroupMembershipPolicyUtil.propagateMembership((long[])userIds, null, (long[])new long[]{userGroupId});
    }

    public User updateAgreedToTermsOfUse(long userId, boolean agreedToTermsOfUse) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updateAgreedToTermsOfUse(userId, agreedToTermsOfUse);
    }

    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2, ServiceContext serviceContext) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateEmailAddress(user, emailAddress2);
        return this.userLocalService.updateEmailAddress(userId, password, emailAddress1, emailAddress2, serviceContext);
    }

    public User updateIncompleteUser(long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, boolean updateUserInformation, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        long creatorUserId;
        block2: {
            creatorUserId = 0L;
            try {
                creatorUserId = this.getGuestOrUserId();
            }
            catch (PrincipalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to get guest or current user ID", (Throwable)pe);
            }
        }
        this.checkAddUserPermission(creatorUserId, companyId, emailAddress, null, null, null, null, serviceContext);
        return this.userLocalService.updateIncompleteUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, updateUserInformation, sendEmail, serviceContext);
    }

    public User updateLockoutById(long userId, boolean lockout) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"DELETE");
        return this.userLocalService.updateLockoutById(userId, lockout);
    }

    public User updateOpenId(long userId, String openId) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updateOpenId(userId, openId);
    }

    public void updateOrganizations(long userId, long[] organizationIds, ServiceContext serviceContext) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        this.checkOrganizations(userId, organizationIds);
        this.userLocalService.updateOrganizations(userId, organizationIds, serviceContext);
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updatePassword(userId, password1, password2, passwordReset);
    }

    public User updatePortrait(long userId, byte[] bytes) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updatePortrait(userId, bytes);
    }

    public User updateReminderQuery(long userId, String question, String answer) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updateReminderQuery(userId, question, answer);
    }

    public User updateScreenName(long userId, String screenName) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"UPDATE");
        return this.userLocalService.updateScreenName(userId, screenName);
    }

    @Deprecated
    public User updateStatus(long userId, int status) throws PortalException {
        return this.updateStatus(userId, status, new ServiceContext());
    }

    public User updateStatus(long userId, int status, ServiceContext serviceContext) throws PortalException {
        if (this.getUserId() == userId && status != 0) {
            throw new RequiredUserException();
        }
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"DELETE");
        return this.userLocalService.updateStatus(userId, status, serviceContext);
    }

    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, boolean portrait, byte[] portraitBytes, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, ServiceContext serviceContext) throws PortalException {
        long curUserId;
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (long[])organizationIds, (String)"UPDATE");
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (addresses != null) {
            UsersAdminUtil.updateAddresses((String)Contact.class.getName(), (long)user.getContactId(), addresses);
        }
        if (emailAddresses != null) {
            UsersAdminUtil.updateEmailAddresses((String)Contact.class.getName(), (long)user.getContactId(), emailAddresses);
        }
        if (phones != null) {
            UsersAdminUtil.updatePhones((String)Contact.class.getName(), (long)user.getContactId(), phones);
        }
        if (websites != null) {
            UsersAdminUtil.updateWebsites((String)Contact.class.getName(), (long)user.getContactId(), websites);
        }
        if (announcementsDelivers != null) {
            this.updateAnnouncementsDeliveries(user.getUserId(), announcementsDelivers);
        }
        if ((curUserId = this.getUserId()) == userId && !StringUtil.equalsIgnoreCase((String)(emailAddress = StringUtil.toLowerCase((String)StringUtil.trim((String)emailAddress))), (String)user.getEmailAddress())) {
            this.validateEmailAddress(user, emailAddress);
        }
        this.validateUpdatePermission(user, screenName, emailAddress, firstName, middleName, lastName, prefixId, suffixId, birthdayMonth, birthdayDay, birthdayYear, male, jobTitle);
        long[] oldGroupIds = user.getGroupIds();
        ArrayList<Long> addGroupIds = new ArrayList<Long>();
        List removeGroupIds = Collections.emptyList();
        if (groupIds != null) {
            removeGroupIds = ListUtil.toList((long[])oldGroupIds);
            for (long groupId : groupIds = this.checkGroups(userId, groupIds)) {
                if (ArrayUtil.contains((long[])oldGroupIds, (long)groupId)) {
                    removeGroupIds.remove(groupId);
                    continue;
                }
                addGroupIds.add(groupId);
            }
            if (!addGroupIds.isEmpty() || !removeGroupIds.isEmpty()) {
                SiteMembershipPolicyUtil.checkMembership((long[])new long[]{userId}, (long[])ArrayUtil.toLongArray(addGroupIds), (long[])ArrayUtil.toLongArray((Collection)removeGroupIds));
            }
        }
        long[] oldOrganizationIds = user.getOrganizationIds();
        ArrayList<Long> addOrganizationIds = new ArrayList<Long>();
        List removeOrganizationIds = Collections.emptyList();
        if (organizationIds != null) {
            removeOrganizationIds = ListUtil.toList((long[])oldOrganizationIds);
            for (long organizationId : organizationIds = this.checkOrganizations(userId, organizationIds)) {
                if (ArrayUtil.contains((long[])oldOrganizationIds, (long)organizationId)) {
                    removeOrganizationIds.remove(organizationId);
                    continue;
                }
                addOrganizationIds.add(organizationId);
            }
            if (!addOrganizationIds.isEmpty() || !removeOrganizationIds.isEmpty()) {
                OrganizationMembershipPolicyUtil.checkMembership((long[])new long[]{userId}, (long[])ArrayUtil.toLongArray(addOrganizationIds), (long[])ArrayUtil.toLongArray((Collection)removeOrganizationIds));
            }
        }
        long[] oldRoleIds = user.getRoleIds();
        ArrayList<Long> addRoleIds = new ArrayList<Long>();
        List removeRoleIds = Collections.emptyList();
        if (roleIds != null) {
            removeRoleIds = ListUtil.toList((long[])oldRoleIds);
            for (long roleId : roleIds = this.checkRoles(userId, roleIds)) {
                if (ArrayUtil.contains((long[])oldRoleIds, (long)roleId)) {
                    removeRoleIds.remove(roleId);
                    continue;
                }
                addRoleIds.add(roleId);
            }
            if (!addRoleIds.isEmpty() || !removeRoleIds.isEmpty()) {
                RoleMembershipPolicyUtil.checkRoles((long[])new long[]{userId}, (long[])ArrayUtil.toLongArray(addRoleIds), (long[])ArrayUtil.toLongArray((Collection)removeRoleIds));
            }
        }
        ArrayList<UserGroupRole> oldOrganizationUserGroupRoles = new ArrayList<UserGroupRole>();
        ArrayList<UserGroupRole> oldSiteUserGroupRoles = new ArrayList<UserGroupRole>();
        List oldUserGroupRoles = this.userGroupRolePersistence.findByUserId(userId);
        for (UserGroupRole oldUserGroupRole : oldUserGroupRoles) {
            Role role = oldUserGroupRole.getRole();
            if (role.getType() == 3) {
                oldOrganizationUserGroupRoles.add(oldUserGroupRole);
                continue;
            }
            if (role.getType() != 2) continue;
            oldSiteUserGroupRoles.add(oldUserGroupRole);
        }
        ArrayList<UserGroupRole> addOrganizationUserGroupRoles = new ArrayList<UserGroupRole>();
        List removeOrganizationUserGroupRoles = Collections.emptyList();
        ArrayList<UserGroupRole> addSiteUserGroupRoles = new ArrayList<UserGroupRole>();
        List removeSiteUserGroupRoles = Collections.emptyList();
        if (userGroupRoles != null) {
            userGroupRoles = this.checkUserGroupRoles(userId, userGroupRoles);
            removeOrganizationUserGroupRoles = ListUtil.copy(oldOrganizationUserGroupRoles);
            removeSiteUserGroupRoles = ListUtil.copy(oldSiteUserGroupRoles);
            for (UserGroupRole userGroupRole : userGroupRoles) {
                Role role = userGroupRole.getRole();
                if (role.getType() == 3) {
                    if (oldOrganizationUserGroupRoles.contains(userGroupRole)) {
                        removeOrganizationUserGroupRoles.remove(userGroupRole);
                        continue;
                    }
                    addOrganizationUserGroupRoles.add(userGroupRole);
                    continue;
                }
                if (role.getType() != 2) continue;
                if (oldSiteUserGroupRoles.contains(userGroupRole)) {
                    removeSiteUserGroupRoles.remove(userGroupRole);
                    continue;
                }
                addSiteUserGroupRoles.add(userGroupRole);
            }
            if (!addOrganizationUserGroupRoles.isEmpty() || !removeOrganizationUserGroupRoles.isEmpty()) {
                OrganizationMembershipPolicyUtil.checkRoles(addOrganizationUserGroupRoles, (List)removeOrganizationUserGroupRoles);
            }
            if (!addSiteUserGroupRoles.isEmpty() || !removeSiteUserGroupRoles.isEmpty()) {
                SiteMembershipPolicyUtil.checkRoles(addSiteUserGroupRoles, (List)removeSiteUserGroupRoles);
            }
        }
        long[] oldUserGroupIds = user.getUserGroupIds();
        ArrayList<Long> addUserGroupIds = new ArrayList<Long>();
        List removeUserGroupIds = Collections.emptyList();
        if (userGroupIds != null) {
            removeUserGroupIds = ListUtil.toList((long[])oldUserGroupIds);
            for (long userGroupId : userGroupIds = this.checkUserGroupIds(userId, userGroupIds)) {
                if (ArrayUtil.contains((long[])oldUserGroupIds, (long)userGroupId)) {
                    removeUserGroupIds.remove(userGroupId);
                    continue;
                }
                addUserGroupIds.add(userGroupId);
            }
            if (!addUserGroupIds.isEmpty() || !removeUserGroupIds.isEmpty()) {
                UserGroupMembershipPolicyUtil.checkMembership((long[])new long[]{userId}, (long[])ArrayUtil.toLongArray(addUserGroupIds), (long[])ArrayUtil.toLongArray((Collection)removeUserGroupIds));
            }
        }
        user = this.userLocalService.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, portrait, portraitBytes, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, serviceContext);
        if (!addGroupIds.isEmpty() || !removeGroupIds.isEmpty()) {
            SiteMembershipPolicyUtil.propagateMembership((long[])new long[]{user.getUserId()}, (long[])ArrayUtil.toLongArray(addGroupIds), (long[])ArrayUtil.toLongArray((Collection)removeGroupIds));
        }
        if (!addOrganizationIds.isEmpty() || !removeOrganizationIds.isEmpty()) {
            OrganizationMembershipPolicyUtil.propagateMembership((long[])new long[]{user.getUserId()}, (long[])ArrayUtil.toLongArray(addOrganizationIds), (long[])ArrayUtil.toLongArray((Collection)removeOrganizationIds));
        }
        if (!addRoleIds.isEmpty() || !removeRoleIds.isEmpty()) {
            RoleMembershipPolicyUtil.propagateRoles((long[])new long[]{user.getUserId()}, (long[])ArrayUtil.toLongArray(addRoleIds), (long[])ArrayUtil.toLongArray((Collection)removeRoleIds));
        }
        if (!addSiteUserGroupRoles.isEmpty() || !removeSiteUserGroupRoles.isEmpty()) {
            SiteMembershipPolicyUtil.propagateRoles(addSiteUserGroupRoles, (List)removeSiteUserGroupRoles);
        }
        if (!addOrganizationUserGroupRoles.isEmpty() || !removeOrganizationUserGroupRoles.isEmpty()) {
            OrganizationMembershipPolicyUtil.propagateRoles(addOrganizationUserGroupRoles, (List)removeOrganizationUserGroupRoles);
        }
        if (!addUserGroupIds.isEmpty() || !removeUserGroupIds.isEmpty()) {
            UserGroupMembershipPolicyUtil.propagateMembership((long[])new long[]{user.getUserId()}, (long[])ArrayUtil.toLongArray(addUserGroupIds), (long[])ArrayUtil.toLongArray((Collection)removeUserGroupIds));
        }
        return user;
    }

    @Deprecated
    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, List<AnnouncementsDelivery> announcementsDelivers, ServiceContext serviceContext) throws PortalException {
        return this.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, true, null, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, addresses, emailAddresses, phones, websites, announcementsDelivers, serviceContext);
    }

    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException {
        return this.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, true, null, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, null, null, null, null, null, serviceContext);
    }

    protected void checkAddUserPermission(long creatorUserId, long companyId, String emailAddress, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (groupIds != null) {
            this.checkGroups(0L, groupIds);
        }
        if (organizationIds != null) {
            this.checkOrganizations(0L, organizationIds);
        }
        if (roleIds != null) {
            this.checkRoles(0L, roleIds);
        }
        if (userGroupIds != null) {
            this.checkUserGroupIds(0L, userGroupIds);
        }
        boolean anonymousUser = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"anonymousUser");
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        if ((creatorUserId != 0L && creatorUserId != defaultUserId || !company.isStrangers() && !anonymousUser) && !PortalPermissionUtil.contains((PermissionChecker)(permissionChecker = this.getPermissionChecker()), (String)"ADD_USER") && !OrganizationPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long[])organizationIds, (String)"ASSIGN_MEMBERS")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Organization.class.getName(), 0L, new String[]{"ADD_USER", "ASSIGN_MEMBERS"});
        }
        if ((creatorUserId == 0L || creatorUserId == defaultUserId) && !company.isStrangersWithMx() && company.hasCompanyMx(emailAddress)) {
            throw new UserEmailAddressException.MustNotUseCompanyMx(emailAddress);
        }
    }

    protected long[] checkGroups(long userId, long[] groupIds) throws PortalException {
        long[] oldGroupIds = null;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        User user = null;
        if (userId != 0L) {
            user = this.userPersistence.findByPrimaryKey(userId);
            List oldGroups = this.groupLocalService.getUserGroups(userId);
            oldGroupIds = new long[oldGroups.size()];
            for (int i = 0; i < oldGroups.size(); ++i) {
                Group group = (Group)oldGroups.get(i);
                if (!ArrayUtil.contains((long[])groupIds, (long)group.getGroupId()) && (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"ASSIGN_MEMBERS") || SiteMembershipPolicyUtil.isMembershipProtected((PermissionChecker)permissionChecker, (long)user.getUserId(), (long)group.getGroupId()) || SiteMembershipPolicyUtil.isMembershipRequired((long)userId, (long)group.getGroupId()))) {
                    groupIds = ArrayUtil.append((long[])groupIds, (long)group.getGroupId());
                }
                oldGroupIds[i] = group.getGroupId();
            }
        }
        for (long groupId : groupIds) {
            if (oldGroupIds != null && ArrayUtil.contains((long[])oldGroupIds, (long)groupId)) continue;
            Group group = this.groupPersistence.findByPrimaryKey(groupId);
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (Group)group, (String)"ASSIGN_MEMBERS");
        }
        return groupIds;
    }

    protected void checkMembership(long[] userIds, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds) throws PortalException {
        if (groupIds != null) {
            SiteMembershipPolicyUtil.checkMembership((long[])userIds, (long[])groupIds, null);
        }
        if (organizationIds != null) {
            OrganizationMembershipPolicyUtil.checkMembership((long[])userIds, (long[])organizationIds, null);
        }
        if (roleIds != null) {
            RoleMembershipPolicyUtil.checkRoles((long[])userIds, (long[])roleIds, null);
        }
        if (userGroupIds != null) {
            UserGroupMembershipPolicyUtil.checkMembership((long[])userIds, (long[])userGroupIds, null);
        }
    }

    protected long[] checkOrganizations(long userId, long[] organizationIds) throws PortalException {
        long[] oldOrganizationIds = null;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (userId != 0L) {
            List oldOrganizations = this.organizationLocalService.getUserOrganizations(userId);
            oldOrganizationIds = new long[oldOrganizations.size()];
            for (int i = 0; i < oldOrganizations.size(); ++i) {
                Organization organization = (Organization)oldOrganizations.get(i);
                if (!ArrayUtil.contains((long[])organizationIds, (long)organization.getOrganizationId()) && (!OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"ASSIGN_MEMBERS") || OrganizationMembershipPolicyUtil.isMembershipProtected((PermissionChecker)permissionChecker, (long)userId, (long)organization.getOrganizationId()) || OrganizationMembershipPolicyUtil.isMembershipRequired((long)userId, (long)organization.getOrganizationId()))) {
                    organizationIds = ArrayUtil.append((long[])organizationIds, (long)organization.getOrganizationId());
                }
                oldOrganizationIds[i] = organization.getOrganizationId();
            }
        }
        for (long organizationId : organizationIds) {
            if (oldOrganizationIds != null && ArrayUtil.contains((long[])oldOrganizationIds, (long)organizationId)) continue;
            Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
            OrganizationPermissionUtil.check((PermissionChecker)permissionChecker, (Organization)organization, (String)"ASSIGN_MEMBERS");
        }
        return organizationIds;
    }

    protected long[] checkRoles(long userId, long[] roleIds) throws PortalException {
        long[] oldRoleIds = null;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (userId != 0L) {
            List oldRoles = this.roleLocalService.getUserRoles(userId);
            oldRoleIds = new long[oldRoles.size()];
            for (int i = 0; i < oldRoles.size(); ++i) {
                Role role = (Role)oldRoles.get(i);
                if (!(ArrayUtil.contains((long[])roleIds, (long)role.getRoleId()) || RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)role.getRoleId(), (String)"ASSIGN_MEMBERS") && !RoleMembershipPolicyUtil.isRoleRequired((long)userId, (long)role.getRoleId()))) {
                    roleIds = ArrayUtil.append((long[])roleIds, (long)role.getRoleId());
                }
                oldRoleIds[i] = role.getRoleId();
            }
        }
        for (long roleId : roleIds) {
            if (oldRoleIds != null && ArrayUtil.contains((long[])oldRoleIds, (long)roleId)) continue;
            RolePermissionUtil.check((PermissionChecker)permissionChecker, (long)roleId, (String)"ASSIGN_MEMBERS");
        }
        if (userId != 0L) {
            return UsersAdminUtil.addRequiredRoles((long)userId, (long[])roleIds);
        }
        return roleIds;
    }

    protected long[] checkUserGroupIds(long userId, long[] userGroupIds) throws PortalException {
        long[] oldUserGroupIds = null;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (userId != 0L) {
            List oldUserGroups = this.userGroupLocalService.getUserUserGroups(userId);
            oldUserGroupIds = new long[oldUserGroups.size()];
            for (int i = 0; i < oldUserGroups.size(); ++i) {
                UserGroup userGroup = (UserGroup)oldUserGroups.get(i);
                if (!(ArrayUtil.contains((long[])userGroupIds, (long)userGroup.getUserGroupId()) || UserGroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)userGroup.getUserGroupId(), (String)"ASSIGN_MEMBERS") && !UserGroupMembershipPolicyUtil.isMembershipRequired((long)userId, (long)userGroup.getUserGroupId()))) {
                    userGroupIds = ArrayUtil.append((long[])userGroupIds, (long)userGroup.getUserGroupId());
                }
                oldUserGroupIds[i] = userGroup.getUserGroupId();
            }
        }
        for (long userGroupId : userGroupIds) {
            if (oldUserGroupIds != null && ArrayUtil.contains((long[])oldUserGroupIds, (long)userGroupId)) continue;
            UserGroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)userGroupId, (String)"ASSIGN_MEMBERS");
        }
        return userGroupIds;
    }

    protected List<UserGroupRole> checkUserGroupRoles(long userId, List<UserGroupRole> userGroupRoles) throws PortalException {
        List oldUserGroupRoles = null;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (userId != 0L) {
            oldUserGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(userId);
            for (UserGroupRole oldUserGroupRole : oldUserGroupRoles) {
                Role role = oldUserGroupRole.getRole();
                Group group = oldUserGroupRole.getGroup();
                if (userGroupRoles.contains(oldUserGroupRole)) continue;
                if (role.getType() == 3) {
                    Organization organization = this.organizationPersistence.findByPrimaryKey(group.getOrganizationId());
                    if (UserGroupRolePermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (Role)role) && !OrganizationMembershipPolicyUtil.isRoleProtected((PermissionChecker)this.getPermissionChecker(), (long)userId, (long)organization.getOrganizationId(), (long)role.getRoleId()) && !OrganizationMembershipPolicyUtil.isRoleRequired((long)userId, (long)organization.getOrganizationId(), (long)role.getRoleId())) continue;
                    userGroupRoles.add(oldUserGroupRole);
                    continue;
                }
                if (role.getType() != 2 || userGroupRoles.contains(oldUserGroupRole) || UserGroupRolePermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (Role)role) && !SiteMembershipPolicyUtil.isRoleProtected((PermissionChecker)this.getPermissionChecker(), (long)userId, (long)group.getGroupId(), (long)role.getRoleId()) && !SiteMembershipPolicyUtil.isRoleRequired((long)userId, (long)group.getGroupId(), (long)role.getRoleId())) continue;
                userGroupRoles.add(oldUserGroupRole);
            }
        }
        for (UserGroupRole userGroupRole : userGroupRoles) {
            if (oldUserGroupRoles != null && oldUserGroupRoles.contains(userGroupRole)) continue;
            UserGroupRolePermissionUtil.check((PermissionChecker)permissionChecker, (long)userGroupRole.getGroupId(), (long)userGroupRole.getRoleId());
        }
        return userGroupRoles;
    }

    protected void propagateMembership(long[] userIds, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds) throws PortalException {
        if (groupIds != null) {
            SiteMembershipPolicyUtil.propagateMembership((long[])userIds, (long[])groupIds, null);
        }
        if (organizationIds != null) {
            OrganizationMembershipPolicyUtil.propagateMembership((long[])userIds, (long[])organizationIds, null);
        }
        if (roleIds != null) {
            RoleMembershipPolicyUtil.propagateRoles((long[])userIds, (long[])roleIds, null);
        }
        if (userGroupIds != null) {
            UserGroupMembershipPolicyUtil.propagateMembership((long[])userIds, (long[])userGroupIds, null);
        }
    }

    protected void updateAnnouncementsDeliveries(long userId, List<AnnouncementsDelivery> announcementsDeliveries) throws PortalException {
        for (AnnouncementsDelivery announcementsDelivery : announcementsDeliveries) {
            this.announcementsDeliveryService.updateDelivery(userId, announcementsDelivery.getType(), announcementsDelivery.getEmail(), announcementsDelivery.getSms(), announcementsDelivery.getWebsite());
        }
    }

    protected void validateEmailAddress(User user, String emailAddress) throws PortalException {
        Company company;
        if (!user.hasCompanyMx() && user.hasCompanyMx(emailAddress) && !(company = this.companyPersistence.findByPrimaryKey(user.getCompanyId())).isStrangersWithMx()) {
            throw new UserEmailAddressException.MustNotUseCompanyMx(emailAddress);
        }
    }

    protected void validateOrganizationUsers(long[] userIds) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!PropsValues.ORGANIZATIONS_ASSIGNMENT_STRICT || permissionChecker.isCompanyAdmin()) {
            return;
        }
        for (long userId : userIds) {
            boolean allowed = false;
            List organizations = this.organizationLocalService.getUserOrganizations(userId);
            for (Organization organization : organizations) {
                if (!OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_USERS")) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            throw new PrincipalException.MustHavePermission(permissionChecker, Organization.class.getName(), 0L, new String[]{"MANAGE_USERS"});
        }
    }

    protected void validateUpdatePermission(User user, String screenName, String emailAddress, String firstName, String middleName, String lastName, long prefixId, long suffixId, int birthdayMonth, int birthdayDay, int birthdayYear, boolean male, String jobTitle) throws PortalException {
        ArrayList<String> fields = new ArrayList<String>();
        Contact contact = user.getContact();
        Calendar birthday = CalendarFactoryUtil.getCalendar();
        birthday.setTime(contact.getBirthday());
        if (birthdayMonth != birthday.get(2) || birthdayDay != birthday.get(5) || birthdayYear != birthday.get(1)) {
            fields.add("birthday");
        }
        if (!StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            fields.add("emailAddress");
        }
        if (!StringUtil.equalsIgnoreCase((String)firstName, (String)user.getFirstName())) {
            fields.add("firstName");
        }
        if (male != contact.getMale()) {
            fields.add("gender");
        }
        if (!StringUtil.equalsIgnoreCase((String)jobTitle, (String)user.getJobTitle())) {
            fields.add("jobTitle");
        }
        if (!StringUtil.equalsIgnoreCase((String)lastName, (String)user.getLastName())) {
            fields.add("lastName");
        }
        if (!StringUtil.equalsIgnoreCase((String)middleName, (String)user.getMiddleName())) {
            fields.add("middleName");
        }
        if (prefixId != contact.getPrefixId()) {
            fields.add("prefix");
        }
        if (!StringUtil.equalsIgnoreCase((String)screenName, (String)user.getScreenName())) {
            fields.add("screenName");
        }
        if (suffixId != contact.getSuffixId()) {
            fields.add("suffix");
        }
        UserFieldException ufe = new UserFieldException();
        for (String field : fields) {
            if (UsersAdminUtil.hasUpdateFieldPermission((PermissionChecker)this.getPermissionChecker(), (User)this.getUser(), (User)user, (String)field)) continue;
            ufe.addField(field);
        }
        if (ufe.hasFields()) {
            throw ufe;
        }
    }
}

