/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.exception.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.PermissionedModel;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.impl.ResourceImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.ResourceLocalServiceBaseImpl;
import com.liferay.portal.util.ResourcePermissionsThreadLocal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.time.StopWatch;

public class ResourceLocalServiceImpl
extends ResourceLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ResourceLocalServiceImpl.class);

    public void addModelResources(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException {
        ModelPermissions modelPermissions = serviceContext.getModelPermissions();
        if (modelPermissions != null && !modelPermissions.isEmpty()) {
            this.addModelResources(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getUserId(), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), modelPermissions, this.getPermissionedModel(auditedModel));
        } else if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addResources(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getUserId(), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), false, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions(), this.getPermissionedModel(auditedModel));
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(this.getGroupId(auditedModel), auditedModel.getModelClassName());
            }
            this.addModelResources(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getUserId(), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), serviceContext.getModelPermissions(), this.getPermissionedModel(auditedModel));
        }
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, long primKey, ModelPermissions modelPermissions) throws PortalException {
        this.addModelResources(companyId, groupId, userId, name, String.valueOf(primKey), modelPermissions, null);
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.addModelResources(companyId, groupId, userId, name, String.valueOf(primKey), groupPermissions, guestPermissions, null);
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, String primKey, ModelPermissions modelPermissions) throws PortalException {
        this.addModelResources(companyId, groupId, userId, name, primKey, modelPermissions, null);
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.addModelResources(companyId, groupId, userId, name, primKey, groupPermissions, guestPermissions, null);
    }

    public void addResources(long companyId, long groupId, long userId, String name, long primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.addResources(companyId, groupId, userId, name, String.valueOf(primKey), portletActions, addGroupPermissions, addGuestPermissions, null);
    }

    public void addResources(long companyId, long groupId, long userId, String name, String primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.addResources(companyId, groupId, userId, name, primKey, portletActions, addGroupPermissions, addGuestPermissions, null);
    }

    public void addResources(long companyId, long groupId, String name, boolean portletActions) throws PortalException {
        this.addResources(companyId, groupId, 0L, name, null, portletActions, false, false);
    }

    public void deleteResource(AuditedModel auditedModel, int scope) throws PortalException {
        this.deleteResource(auditedModel.getCompanyId(), auditedModel.getModelClassName(), scope, String.valueOf(auditedModel.getPrimaryKeyObj()), this.getPermissionedModel(auditedModel));
    }

    public void deleteResource(long companyId, String name, int scope, long primKey) throws PortalException {
        this.deleteResource(companyId, name, scope, String.valueOf(primKey), null);
    }

    public void deleteResource(long companyId, String name, int scope, String primKey) throws PortalException {
        this.deleteResource(companyId, name, scope, primKey, null);
    }

    public Resource getResource(long companyId, String name, int scope, String primKey) {
        ResourceImpl resource = new ResourceImpl();
        resource.setCompanyId(companyId);
        resource.setName(name);
        resource.setScope(scope);
        resource.setPrimKey(primKey);
        return resource;
    }

    public boolean hasUserPermissions(long userId, long resourceId, List<Resource> resources, String actionId, long[] roleIds) throws PortalException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        int block = 1;
        boolean hasUserPermissions = this.resourcePermissionLocalService.hasResourcePermission(resources, roleIds, actionId);
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        return hasUserPermissions;
    }

    public void updateModelResources(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException {
        this.updateResources(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), serviceContext.getModelPermissions(), this.getPermissionedModel(auditedModel));
    }

    public void updateResources(long companyId, long groupId, String name, long primKey, ModelPermissions modelPermissions) throws PortalException {
        this.updateResources(companyId, groupId, name, String.valueOf(primKey), modelPermissions, null);
    }

    public void updateResources(long companyId, long groupId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.updateResources(companyId, groupId, name, String.valueOf(primKey), groupPermissions, guestPermissions, null);
    }

    public void updateResources(long companyId, long groupId, String name, String primKey, ModelPermissions modelPermissions) throws PortalException {
        this.updateResources(companyId, groupId, name, primKey, modelPermissions, null);
    }

    public void updateResources(long companyId, long groupId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        ModelPermissions modelPermissions = ModelPermissionsFactory.create((String[])groupPermissions, (String[])guestPermissions);
        this.updateResources(companyId, groupId, name, primKey, modelPermissions, null);
    }

    public void updateResources(long companyId, String name, int scope, String primKey, String newPrimKey) {
        if (!this.resourceBlockLocalService.isSupported(name)) {
            this.updateResourcePermissions(companyId, name, scope, primKey, newPrimKey);
        }
    }

    protected void addGroupPermissions(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions, PermissionedModel permissionedModel) throws PortalException {
        List actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceGroupDefaultActions((String)name) : ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
        String[] actionIds = actions.toArray(new String[actions.size()]);
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.addGroupPermissionsBlocks(groupId, resource, actions, permissionedModel);
        } else {
            this.addGroupPermissions(groupId, resource, actionIds);
        }
    }

    protected void addGroupPermissions(long groupId, Resource resource, String[] actionIds) throws PortalException {
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds);
    }

    protected void addGroupPermissionsBlocks(long groupId, Resource resource, List<String> actionIds, PermissionedModel permissionedModel) throws PortalException {
        if (permissionedModel == null) {
            throw new IllegalArgumentException("Permissioned model is null");
        }
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, role.getRoleId(), actionIds);
    }

    protected void addGuestPermissions(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions, PermissionedModel permissionedModel) throws PortalException {
        List actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceGuestDefaultActions((String)name) : ResourceActionsUtil.getModelResourceGuestDefaultActions((String)name);
        String[] actionIds = actions.toArray(new String[actions.size()]);
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.addGuestPermissionsBlocks(companyId, groupId, resource, actions, permissionedModel);
        } else {
            this.addGuestPermissions(companyId, resource, actionIds);
        }
    }

    protected void addGuestPermissions(long companyId, Resource resource, String[] actionIds) throws PortalException {
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), guestRole.getRoleId(), actionIds);
    }

    protected void addGuestPermissionsBlocks(long companyId, long groupId, Resource resource, List<String> actionIds, PermissionedModel permissionedModel) throws PortalException {
        if (permissionedModel == null) {
            throw new IllegalArgumentException("Permissioned model is null");
        }
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, guestRole.getRoleId(), actionIds);
    }

    protected void addModelResources(long companyId, long groupId, long userId, Resource resource, ModelPermissions modelPermissions, PermissionedModel permissionedModel) throws PortalException {
        block5: {
            String[] ownerPermissions;
            Role ownerRole;
            block4: {
                ownerRole = this.roleLocalService.getRole(companyId, "Owner");
                List ownerActionIds = ResourceActionsUtil.getModelResourceActions((String)resource.getName());
                ownerActionIds = ListUtil.copy((List)ownerActionIds);
                this.filterOwnerActions(resource.getName(), ownerActionIds);
                ownerPermissions = ownerActionIds.toArray(new String[ownerActionIds.size()]);
                if (!this.resourceBlockLocalService.isSupported(resource.getName())) break block4;
                if (permissionedModel == null) {
                    throw new IllegalArgumentException("Permissioned model is null");
                }
                this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, ownerRole.getRoleId(), ownerActionIds);
                if (modelPermissions == null) break block5;
                for (String roleName : modelPermissions.getRoleNames()) {
                    Role role = this.getRole(resource.getCompanyId(), groupId, roleName);
                    this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, role.getRoleId(), modelPermissions.getActionIdsList(roleName));
                }
                break block5;
            }
            this.resourcePermissionLocalService.setOwnerResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), ownerRole.getRoleId(), userId, ownerPermissions);
            if (modelPermissions != null) {
                for (String roleName : modelPermissions.getRoleNames()) {
                    Role role = this.getRole(resource.getCompanyId(), groupId, roleName);
                    this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), modelPermissions.getActionIds(roleName));
                }
            }
        }
    }

    protected void addModelResources(long companyId, long groupId, long userId, Resource resource, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException {
        ModelPermissions modelPermissions = ModelPermissionsFactory.create((String[])groupPermissions, (String[])guestPermissions);
        this.addModelResources(companyId, groupId, userId, resource, modelPermissions, permissionedModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addModelResources(long companyId, long groupId, long userId, String name, String primKey, ModelPermissions modelPermissions, PermissionedModel permissionedModel) throws PortalException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, false);
        if (primKey == null) {
            return;
        }
        Resource resource = this.getResource(companyId, name, 4, primKey);
        boolean flushResourceBlockEnabled = PermissionThreadLocal.isFlushResourceBlockEnabled((long)companyId, (long)groupId, (String)name);
        boolean flushResourcePermissionEnabled = PermissionThreadLocal.isFlushResourcePermissionEnabled((String)name, (String)primKey);
        PermissionThreadLocal.setFlushResourceBlockEnabled((long)companyId, (long)groupId, (String)name, (boolean)false);
        PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)false);
        try {
            this.addModelResources(companyId, groupId, userId, resource, modelPermissions, permissionedModel);
        }
        finally {
            PermissionThreadLocal.setFlushResourceBlockEnabled((long)companyId, (long)groupId, (String)name, (boolean)flushResourceBlockEnabled);
            PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)flushResourcePermissionEnabled);
            PermissionCacheUtil.clearResourceBlockCache(companyId, groupId, name);
            PermissionCacheUtil.clearResourcePermissionCache(4, name, primKey);
            IndexWriterHelperUtil.updatePermissionFields((String)name, (String)primKey);
        }
    }

    protected void addModelResources(long companyId, long groupId, long userId, String name, String primKey, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException {
        ModelPermissions modelPermissions = ModelPermissionsFactory.create((String[])groupPermissions, (String[])guestPermissions);
        this.addModelResources(companyId, groupId, userId, name, primKey, modelPermissions, permissionedModel);
    }

    protected void addResources(long companyId, long groupId, long userId, Resource resource, boolean portletActions, PermissionedModel permissionedModel) throws PortalException {
        List actionIds = null;
        if (portletActions) {
            actionIds = ResourceActionsUtil.getPortletResourceActions((String)resource.getName());
        } else {
            actionIds = ResourceActionsUtil.getModelResourceActions((String)resource.getName());
            actionIds = ListUtil.copy((List)actionIds);
            this.filterOwnerActions(resource.getName(), actionIds);
        }
        Role role = this.roleLocalService.getRole(companyId, "Owner");
        if (this.resourceBlockLocalService.isSupported(resource.getName())) {
            if (permissionedModel == null) {
                throw new IllegalArgumentException("Permissioned model is null");
            }
            this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, role.getRoleId(), actionIds);
        } else {
            this.resourcePermissionLocalService.setOwnerResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), userId, actionIds.toArray(new String[actionIds.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResources(long companyId, long groupId, long userId, String name, String primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions, PermissionedModel permissionedModel) throws PortalException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, portletActions);
        if (primKey == null) {
            return;
        }
        Resource resource = this.getResource(companyId, name, 4, primKey);
        boolean flushResourceBlockEnabled = PermissionThreadLocal.isFlushResourceBlockEnabled((long)companyId, (long)groupId, (String)name);
        boolean flushResourcePermissionEnabled = PermissionThreadLocal.isFlushResourcePermissionEnabled((String)name, (String)primKey);
        PermissionThreadLocal.setFlushResourceBlockEnabled((long)companyId, (long)groupId, (String)name, (boolean)false);
        PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)false);
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, 4, primKey);
        ResourcePermissionsThreadLocal.setResourcePermissions(resourcePermissions);
        try {
            this.addResources(companyId, groupId, userId, resource, portletActions, permissionedModel);
            if (groupId > 0L && addGroupPermissions) {
                this.addGroupPermissions(companyId, groupId, userId, name, resource, portletActions, permissionedModel);
            }
            if (addGuestPermissions) {
                this.addGuestPermissions(companyId, groupId, userId, name, resource, portletActions, permissionedModel);
            }
        }
        finally {
            ResourcePermissionsThreadLocal.setResourcePermissions(null);
            PermissionThreadLocal.setFlushResourceBlockEnabled((long)companyId, (long)groupId, (String)name, (boolean)flushResourceBlockEnabled);
            PermissionThreadLocal.setFlushResourcePermissionEnabled((String)name, (String)primKey, (boolean)flushResourcePermissionEnabled);
            PermissionCacheUtil.clearResourceBlockCache(companyId, groupId, name);
            PermissionCacheUtil.clearResourcePermissionCache(4, name, primKey);
            IndexWriterHelperUtil.updatePermissionFields((String)name, (String)primKey);
        }
    }

    protected void deleteResource(long companyId, String name, int scope, String primKey, PermissionedModel permissionedModel) throws PortalException {
        if (this.resourceBlockLocalService.isSupported(name)) {
            if (permissionedModel == null) {
                throw new IllegalArgumentException("Permissioned model is null");
            }
            this.resourceBlockLocalService.releasePermissionedModelResourceBlock(permissionedModel);
            return;
        }
        this.resourcePermissionLocalService.deleteResourcePermissions(companyId, name, scope, primKey);
    }

    protected void filterOwnerActions(String name, List<String> actionIds) {
        List defaultOwnerActions = ResourceActionsUtil.getModelResourceOwnerDefaultActions((String)name);
        if (defaultOwnerActions.isEmpty()) {
            return;
        }
        Iterator<String> itr = actionIds.iterator();
        while (itr.hasNext()) {
            String actionId = itr.next();
            if (defaultOwnerActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    protected long getGroupId(AuditedModel auditedModel) {
        long groupId = 0L;
        if (auditedModel instanceof GroupedModel) {
            GroupedModel groupedModel = (GroupedModel)auditedModel;
            groupId = BeanPropertiesUtil.getLongSilent((Object)groupedModel, (String)"resourceGroupId", (long)groupedModel.getGroupId());
        }
        return groupId;
    }

    protected PermissionedModel getPermissionedModel(AuditedModel auditedModel) {
        PermissionedModel permissionedModel = null;
        if (auditedModel instanceof PermissionedModel) {
            permissionedModel = (PermissionedModel)auditedModel;
        }
        return permissionedModel;
    }

    protected Role getRole(long companyId, long groupId, String roleName) throws PortalException {
        if (roleName.equals("PLACEHOLDER_DEFAULT_GROUP_ROLE")) {
            if (groupId == 0L) {
                throw new NoSuchRoleException("Specify a group ID other than 0 for role name PLACEHOLDER_DEFAULT_GROUP_ROLE");
            }
            return this.roleLocalService.getDefaultGroupRole(groupId);
        }
        return this.roleLocalService.getRole(companyId, roleName);
    }

    protected void logHasUserPermissions(long userId, long resourceId, String actionId, StopWatch stopWatch, int block) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Checking user permissions block " + block + " for " + userId + " " + resourceId + " " + actionId + " takes " + stopWatch.getTime() + " ms"));
    }

    protected void updateResourceBlocks(long companyId, long groupId, Resource resource, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException {
        if (permissionedModel == null) {
            throw new IllegalArgumentException("Permissioned model is null");
        }
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourceBlockLocalService.setIndividualScopePermissions(companyId, groupId, resource.getName(), permissionedModel, role.getRoleId(), Arrays.asList(groupPermissions));
        role = this.roleLocalService.getRole(companyId, "Guest");
        this.resourceBlockLocalService.setIndividualScopePermissions(companyId, groupId, resource.getName(), permissionedModel, role.getRoleId(), Arrays.asList(guestPermissions));
    }

    protected void updateResourceBlocks(long groupId, Resource resource, ModelPermissions modelPermissions, PermissionedModel permissionedModel) throws PortalException {
        if (permissionedModel == null) {
            throw new IllegalArgumentException("Permissioned model is null");
        }
        for (String roleName : modelPermissions.getRoleNames()) {
            Role role = this.getRole(resource.getCompanyId(), groupId, roleName);
            this.resourceBlockLocalService.setIndividualScopePermissions(role.getCompanyId(), groupId, resource.getName(), permissionedModel, role.getRoleId(), modelPermissions.getActionIdsList(roleName));
        }
    }

    protected void updateResourcePermissions(long companyId, long groupId, Resource resource, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), groupPermissions);
        role = this.roleLocalService.getRole(companyId, "Guest");
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), guestPermissions);
    }

    protected void updateResourcePermissions(long groupId, Resource resource, ModelPermissions modelPermissions) throws PortalException {
        for (String roleName : modelPermissions.getRoleNames()) {
            Role role = this.getRole(resource.getCompanyId(), groupId, roleName);
            List actionIds = modelPermissions.getActionIdsList(roleName);
            this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds.toArray(new String[actionIds.size()]));
        }
    }

    protected void updateResourcePermissions(long companyId, String name, int scope, String primKey, String newPrimKey) {
        List resourcePermissions = this.resourcePermissionLocalService.getResourcePermissions(companyId, name, scope, primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourcePermission.setPrimKey(newPrimKey);
            resourcePermission.setPrimKeyId(GetterUtil.getLong((String)newPrimKey));
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission);
        }
    }

    protected void updateResources(long companyId, long groupId, String name, String primKey, ModelPermissions modelPermissions, PermissionedModel permissionedModel) throws PortalException {
        Resource resource = this.getResource(companyId, name, 4, primKey);
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.updateResourceBlocks(groupId, resource, modelPermissions, permissionedModel);
        } else {
            this.updateResourcePermissions(groupId, resource, modelPermissions);
        }
    }

    protected void updateResources(long companyId, long groupId, String name, String primKey, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException {
        Resource resource = this.getResource(companyId, name, 4, primKey);
        if (groupPermissions == null) {
            groupPermissions = new String[]{};
        }
        if (guestPermissions == null) {
            guestPermissions = new String[]{};
        }
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.updateResourceBlocks(companyId, groupId, resource, groupPermissions, guestPermissions, permissionedModel);
        } else {
            this.updateResourcePermissions(companyId, groupId, resource, groupPermissions, guestPermissions);
        }
    }

    protected void validate(String name, boolean portletActions) throws PortalException {
        List<String> actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceActions((String)name) : ResourceActionsUtil.getModelResourceActions((String)name);
        if (ListUtil.isEmpty((List)actions)) {
            List resourceActions;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Checking other resource actions because no model or portlet resource actions found for " + name));
            }
            if (ListUtil.isEmpty((List)(resourceActions = this.resourceActionLocalService.getResourceActions(name)))) {
                throw new NoSuchResourceActionException("There are no actions associated with the resource " + name);
            }
            actions = new ArrayList<String>(resourceActions.size());
            for (ResourceAction resourceAction : resourceActions) {
                actions.add(resourceAction.getActionId());
            }
        }
    }
}

