/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchPortletItemException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletItemNameException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.PortletItemLocalServiceBaseImpl;
import java.util.List;

public class PortletItemLocalServiceImpl
extends PortletItemLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortletItemLocalServiceImpl.class);

    public PortletItem addPortletItem(long userId, long groupId, String name, String portletId, String className) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.validate(name);
        long portletItemId = this.counterLocalService.increment();
        PortletItem portletItem = this.portletItemPersistence.create(portletItemId);
        portletItem.setGroupId(groupId);
        portletItem.setCompanyId(user.getCompanyId());
        portletItem.setUserId(user.getUserId());
        portletItem.setUserName(user.getFullName());
        portletItem.setName(name);
        portletItem.setPortletId(portletId);
        portletItem.setClassNameId(classNameId);
        this.portletItemPersistence.update((BaseModel)portletItem);
        return portletItem;
    }

    public PortletItem getPortletItem(long groupId, String name, String portletId, String className) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.portletItemPersistence.findByG_N_P_C(groupId, name, portletId, classNameId);
    }

    public List<PortletItem> getPortletItems(long groupId, String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.portletItemPersistence.findByG_C(groupId, classNameId);
    }

    public List<PortletItem> getPortletItems(long groupId, String portletId, String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.portletItemPersistence.findByG_P_C(groupId, portletId, classNameId);
    }

    public PortletItem updatePortletItem(long userId, long groupId, String name, String portletId, String className) throws PortalException {
        PortletItem portletItem = null;
        try {
            User user = this.userPersistence.findByPrimaryKey(userId);
            portletItem = this.getPortletItem(groupId, name, portletId, PortletPreferences.class.getName());
            portletItem.setUserId(userId);
            portletItem.setUserName(user.getFullName());
            this.portletItemPersistence.update((BaseModel)portletItem);
        }
        catch (NoSuchPortletItemException nspie) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nspie, (Throwable)nspie);
            }
            portletItem = this.addPortletItem(userId, groupId, name, portletId, PortletPreferences.class.getName());
        }
        return portletItem;
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new PortletItemNameException();
        }
    }
}

