/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredLayoutException;
import com.liferay.portal.kernel.exception.SitemapChangeFrequencyException;
import com.liferay.portal.kernel.exception.SitemapIncludeException;
import com.liferay.portal.kernel.exception.SitemapPagePriorityException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutModel;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.LayoutReference;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.LayoutComparator;
import com.liferay.portal.kernel.util.comparator.LayoutPriorityComparator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.service.base.LayoutLocalServiceBaseImpl;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.portal.util.PropsValues;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutLocalServiceImpl
extends LayoutLocalServiceBaseImpl {
    @BeanReference(type=LayoutLocalServiceHelper.class)
    protected LayoutLocalServiceHelper layoutLocalServiceHelper;
    private static final Log _log = LogFactoryUtil.getLog(LayoutLocalServiceImpl.class);
    private static final ThreadLocal<Long> _virtualLayoutTargetGroupId = new AutoResetThreadLocal(LayoutLocalServiceImpl.class + "._virtualLayoutTargetGroupId", () -> 0L);

    public static String getCounterName(long groupId, boolean privateLayout) {
        StringBundler sb = new StringBundler(5);
        sb.append(Layout.class.getName());
        sb.append("#");
        sb.append(groupId);
        sb.append("#");
        sb.append(privateLayout);
        return sb.toString();
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        LayoutTypePortlet layoutTypePortlet;
        User user = this.userPersistence.findByPrimaryKey(userId);
        long layoutId = this.getNextLayoutId(groupId, privateLayout);
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        friendlyURLMap = this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = friendlyURLMap.get(LocaleUtil.getSiteDefault());
        int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, null, -1);
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURLMap, serviceContext);
        Date now = new Date();
        long plid = this.counterLocalService.increment();
        Layout layout = this.layoutPersistence.create(plid);
        layout.setUuid(serviceContext.getUuid());
        layout.setGroupId(groupId);
        layout.setCompanyId(user.getCompanyId());
        layout.setUserId(user.getUserId());
        layout.setUserName(user.getFullName());
        layout.setCreateDate(serviceContext.getCreateDate(now));
        layout.setModifiedDate(serviceContext.getModifiedDate(now));
        layout.setPrivateLayout(privateLayout);
        layout.setLayoutId(layoutId);
        layout.setParentLayoutId(parentLayoutId);
        layout.setNameMap(nameMap);
        layout.setTitleMap(titleMap);
        layout.setDescriptionMap(descriptionMap);
        layout.setKeywordsMap(keywordsMap);
        layout.setRobotsMap(robotsMap);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        layout.setPriority(priority);
        boolean layoutUpdateable = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutUpdateable", (boolean)true);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(typeSettings);
        if (!layoutUpdateable) {
            typeSettingsProperties.put("layoutUpdateable", String.valueOf(layoutUpdateable));
        }
        if (privateLayout) {
            typeSettingsProperties.put("privateLayout", String.valueOf(privateLayout));
        }
        this.validateTypeSettingsProperties(layout, typeSettingsProperties);
        layout.setTypeSettingsProperties(typeSettingsProperties);
        String layoutPrototypeUuid = ParamUtil.getString((ServiceContext)serviceContext, (String)"layoutPrototypeUuid");
        boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutPrototypeLinkEnabled", (boolean)PropsValues.LAYOUT_PROTOTYPE_LINK_ENABLED_DEFAULT);
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
            layout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
        }
        if (type.equals("portlet") && Validator.isNull((String)(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).getLayoutTemplateId())) {
            layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.LAYOUT_DEFAULT_TEMPLATE_ID, false);
        }
        layout.setExpandoBridgeAttributes(serviceContext);
        this.layoutPersistence.update((BaseModel)layout);
        this.layoutFriendlyURLLocalService.updateLayoutFriendlyURLs(user.getUserId(), user.getCompanyId(), groupId, plid, privateLayout, friendlyURLMap, serviceContext);
        if (Validator.isNotNull((String)layoutPrototypeUuid) && !layoutPrototypeLinkEnabled) {
            LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.getLayoutPrototypeByUuidAndCompanyId(layoutPrototypeUuid, layout.getCompanyId());
            try {
                SitesUtil.applyLayoutPrototype((LayoutPrototype)layoutPrototype, (Layout)layout, (boolean)layoutPrototypeLinkEnabled);
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (SystemException se) {
                throw se;
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        boolean addGroupPermissions = true;
        Group group = this.groupLocalService.getGroup(groupId);
        if (privateLayout && (group.isUser() || group.isUserGroup())) {
            addGroupPermissions = false;
        }
        boolean addGuestPermissions = false;
        if (!privateLayout || type.equals("control_panel") || group.isLayoutSetPrototype()) {
            addGuestPermissions = true;
        }
        this.resourceLocalService.addResources(user.getCompanyId(), groupId, user.getUserId(), Layout.class.getName(), layout.getPlid(), false, addGroupPermissions, addGuestPermissions);
        this.groupLocalService.updateSite(groupId, true);
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
        layout.setLayoutSet(null);
        this.updateAsset(userId, layout, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return this.layoutLocalService.getLayout(layout.getPlid());
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(locale, name);
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(locale, title);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, description);
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        friendlyURLMap.put(LocaleUtil.getSiteDefault(), friendlyURL);
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, new HashMap<Locale, String>(), new HashMap<Locale, String>(), type, "", hidden, friendlyURLMap, serviceContext);
    }

    @SystemEvent(action=1, type=1)
    public void deleteLayout(Layout layout, boolean updateLayoutSet, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntry systemEventHierarchyEntry;
        Layout firstLayout;
        List rootLayouts;
        if (layout.getParentLayoutId() == 0L && (rootLayouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), 0L, 0, 2)).size() > 1 && (firstLayout = (Layout)rootLayouts.get(0)).getLayoutId() == layout.getLayoutId()) {
            Layout secondLayout = (Layout)rootLayouts.get(1);
            this.layoutLocalServiceHelper.validateFirstLayout(secondLayout);
        }
        List childLayouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        for (Layout childLayout : childLayouts) {
            this.layoutLocalService.deleteLayout(childLayout, updateLayoutSet, serviceContext);
        }
        this.layoutFriendlyURLLocalService.deleteLayoutFriendlyURLs(layout.getPlid());
        this.portletPreferencesLocalService.deletePortletPreferencesByPlid(layout.getPlid());
        this.assetEntryLocalService.deleteEntry(Layout.class.getName(), layout.getPlid());
        this.ratingsStatsLocalService.deleteStats(Layout.class.getName(), layout.getPlid());
        this.expandoRowLocalService.deleteRows(layout.getPlid());
        this.imageLocalService.deleteImage(layout.getIconImageId());
        Group scopeGroup = layout.getScopeGroup();
        if (scopeGroup != null) {
            this.groupLocalService.deleteGroup(scopeGroup.getGroupId());
        }
        String primKey = layout.getPlid() + "_LAYOUT_" + "%";
        List resourcePermissions = this.resourcePermissionPersistence.findByC_LikeP(layout.getCompanyId(), primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
        }
        this.resourceLocalService.deleteResource(layout.getCompanyId(), Layout.class.getName(), 4, layout.getPlid());
        this.layoutPersistence.remove((BaseModel)layout);
        if (updateLayoutSet) {
            this.layoutSetLocalService.updatePageCount(layout.getGroupId(), layout.isPrivateLayout());
        }
        if ((systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.peek()) != null && systemEventHierarchyEntry.hasTypedModel(Layout.class.getName(), layout.getPlid())) {
            systemEventHierarchyEntry.setExtraDataValue("privateLayout", StringUtil.valueOf((Object)layout.isPrivateLayout()));
        }
    }

    public void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        this.layoutLocalService.deleteLayout(layout, true, serviceContext);
    }

    public void deleteLayout(long plid, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        this.layoutLocalService.deleteLayout(layout, true, serviceContext);
    }

    public void deleteLayouts(long groupId, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, 0L, -1, -1, (OrderByComparator)new LayoutPriorityComparator(false));
        for (Layout layout : layouts) {
            try {
                this.layoutLocalService.deleteLayout(layout, false, serviceContext);
            }
            catch (NoSuchLayoutException nsle) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)nsle, (Throwable)nsle);
            }
        }
        if (GetterUtil.getBoolean((Object)serviceContext.getAttribute("updatePageCount"), (boolean)true)) {
            this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
        }
        this.counterLocalService.reset(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout));
    }

    @Deprecated
    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public byte[] exportLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public File exportLayoutsAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long exportLayoutsAsFileInBackground(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long exportLayoutsAsFileInBackground(long userId, long exportImportConfigurationId) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long exportLayoutsAsFileInBackground(long userId, String taskName, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long exportLayoutsAsFileInBackground(long userId, String taskName, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public byte[] exportPortletInfo(long companyId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public File exportPortletInfoAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public File exportPortletInfoAsFile(long companyId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long exportPortletInfoAsFileInBackground(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long exportPortletInfoAsFileInBackground(long userId, long exportImportConfigurationId) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long exportPortletInfoAsFileInBackground(long userId, String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long exportPortletInfoAsFileInBackground(long userId, String taskName, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public Layout fetchDefaultLayout(long groupId, boolean privateLayout) {
        List layouts;
        if (groupId > 0L && !(layouts = this.layoutPersistence.findByG_P(groupId, privateLayout, 0, 1)).isEmpty()) {
            return (Layout)layouts.get(0);
        }
        return null;
    }

    public Layout fetchFirstLayout(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.fetchByG_P_P_First(groupId, privateLayout, parentLayoutId, (OrderByComparator)new LayoutPriorityComparator());
    }

    public Layout fetchLayout(long groupId, boolean privateLayout, long layoutId) {
        return this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
    }

    public Layout fetchLayout(String uuid, long groupId, boolean privateLayout) {
        return this.layoutPersistence.fetchByUUID_G_P(uuid, groupId, privateLayout);
    }

    public Layout fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        return this.layoutPersistence.fetchByG_P_F(groupId, privateLayout, friendlyURL);
    }

    public Layout fetchLayoutByIconImageId(boolean privateLayout, long iconImageId) throws PortalException {
        return this.layoutPersistence.fetchByP_I(privateLayout, iconImageId);
    }

    public long getDefaultPlid(long groupId) {
        List layouts;
        if (groupId > 0L && !(layouts = this.layoutPersistence.findByGroupId(groupId, 0, 1)).isEmpty()) {
            Layout layout = (Layout)layouts.get(0);
            return layout.getPlid();
        }
        return 0L;
    }

    public long getDefaultPlid(long groupId, boolean privateLayout) {
        Layout layout = this.fetchDefaultLayout(groupId, privateLayout);
        if (layout != null) {
            return layout.getPlid();
        }
        return 0L;
    }

    public long getDefaultPlid(long groupId, boolean privateLayout, String portletId) throws PortalException {
        if (groupId > 0L) {
            List layouts = this.layoutPersistence.findByG_P(groupId, privateLayout);
            for (Layout layout : layouts) {
                LayoutTypePortlet layoutTypePortlet;
                if (!layout.isTypePortlet() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
                return layout.getPlid();
            }
        }
        return 0L;
    }

    public Layout getFriendlyURLLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        if (Validator.isNull((String)friendlyURL)) {
            StringBundler sb = new StringBundler(5);
            sb.append("{groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append("}");
            throw new NoSuchLayoutException(sb.toString());
        }
        friendlyURL = HttpUtil.decodeURL((String)friendlyURL);
        friendlyURL = this.layoutLocalServiceHelper.getFriendlyURL(friendlyURL);
        Layout layout = null;
        List layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByG_P_F(groupId, privateLayout, friendlyURL, 0, 1);
        if (!layoutFriendlyURLs.isEmpty()) {
            LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)layoutFriendlyURLs.get(0);
            layout = this.layoutPersistence.findByPrimaryKey(layoutFriendlyURL.getPlid());
        }
        if (layout == null && friendlyURL.startsWith("/") && Validator.isNumber((String)friendlyURL.substring(1))) {
            long layoutId = GetterUtil.getLong((String)friendlyURL.substring(1));
            layout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        }
        if (layout == null) {
            StringBundler sb = new StringBundler(7);
            sb.append("{groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append(", friendlyURL=");
            sb.append(friendlyURL);
            sb.append("}");
            throw new NoSuchLayoutException(sb.toString());
        }
        return layout;
    }

    @Override
    public Layout getLayout(long plid) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        if (this._mergeLayout(layout, plid)) {
            return this.layoutPersistence.findByPrimaryKey(plid);
        }
        return layout;
    }

    public Layout getLayout(long groupId, boolean privateLayout, long layoutId) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (this._mergeLayout(layout, groupId, privateLayout, layoutId)) {
            return this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        }
        return layout;
    }

    public Layout getLayoutByIconImageId(long iconImageId) throws PortalException {
        return this.layoutPersistence.findByIconImageId(iconImageId);
    }

    public Map<Long, List<Layout>> getLayoutChildLayouts(LayoutSet layoutSet, List<Layout> parentLayouts) {
        List<Layout> childLayouts = this._getChildLayouts(layoutSet, ListUtil.toLongArray(parentLayouts, LayoutModel::getLayoutId));
        HashMap<Long, List<Layout>> layoutChildLayouts = new HashMap<Long, List<Layout>>();
        for (Layout childLayout : childLayouts) {
            List layoutChildLayoutsList = layoutChildLayouts.computeIfAbsent(childLayout.getParentLayoutId(), parentLayoutId -> new ArrayList());
            layoutChildLayoutsList.add(childLayout);
        }
        for (List layoutChildLayoutsList : layoutChildLayouts.values()) {
            layoutChildLayoutsList.sort(Comparator.comparing(LayoutModel::getPriority));
        }
        return layoutChildLayouts;
    }

    public List<Layout> getLayouts(long companyId) {
        return this.layoutPersistence.findByCompanyId(companyId);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout) {
        return this.layoutPersistence.findByG_P(groupId, privateLayout);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
        }
        try {
            Group group = this.groupLocalService.getGroup(groupId);
            LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayout);
            if (layoutSet.isLayoutSetPrototypeLinkActive() && !this._mergeLayouts(group, layoutSet, groupId, privateLayout, parentLayoutId)) {
                return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
            }
            List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
            return this._injectVirtualLayouts(group, layoutSet, (List<Layout>)layouts, parentLayoutId);
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, start, end);
        }
        try {
            Group group = this.groupLocalService.getGroup(groupId);
            LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayout);
            if (!this._mergeLayouts(group, layoutSet, groupId, privateLayout, parentLayoutId, start, end)) {
                return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
            }
            List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
            return this._injectVirtualLayouts(group, layoutSet, (List<Layout>)layouts, parentLayoutId);
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long[] layoutIds) throws PortalException {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (long layoutId : layoutIds) {
            Layout layout = this.getLayout(groupId, privateLayout, layoutId);
            layouts.add(layout);
        }
        return layouts;
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String type) {
        return this.layoutPersistence.findByG_P_T(groupId, privateLayout, type);
    }

    public LayoutReference[] getLayouts(long companyId, String portletId, String preferencesKey, String preferencesValue) {
        List layoutReferences = this.layoutFinder.findByC_P_P(companyId, portletId, preferencesKey, preferencesValue);
        return layoutReferences.toArray(new LayoutReference[layoutReferences.size()]);
    }

    public List<Layout> getLayoutsByLayoutPrototypeUuid(String layoutPrototypeUuid) {
        return this.layoutPersistence.findByLayoutPrototypeUuid(layoutPrototypeUuid);
    }

    public int getLayoutsByLayoutPrototypeUuidCount(String layoutPrototypeUuid) {
        return this.layoutPersistence.countByLayoutPrototypeUuid(layoutPrototypeUuid);
    }

    public int getLayoutsCount(Group group, boolean privateLayout) throws PortalException {
        return this.getLayoutsCount(group, privateLayout, true);
    }

    public int getLayoutsCount(Group group, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(group.getGroupId(), privateLayout);
        int count = layoutSet.getPageCount();
        if (!group.isUser() || !includeUserGroups) {
            return count;
        }
        long[] userGroupIds = this.userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this.groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                layoutSet = this.layoutSetPersistence.findByG_P(userGroupGroup.getGroupId(), privateLayout);
                count += layoutSet.getPageCount();
            }
        }
        return count;
    }

    public int getLayoutsCount(Group group, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.countByG_P_P(group.getGroupId(), privateLayout, parentLayoutId);
    }

    public int getLayoutsCount(Group group, boolean privateLayout, long[] layoutIds) {
        if (ArrayUtil.isEmpty((long[])layoutIds)) {
            return 0;
        }
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(groupIdProperty.eq((Object)group.getGroupId()));
        Property privateLayoutProperty = PropertyFactoryUtil.forName((String)"privateLayout");
        dynamicQuery.add(privateLayoutProperty.eq((Object)privateLayout));
        Property layoutIdProperty = PropertyFactoryUtil.forName((String)"layoutId");
        dynamicQuery.add(layoutIdProperty.in(layoutIds));
        return GetterUtil.getInteger((Object)this.dynamicQueryCount(dynamicQuery));
    }

    public int getLayoutsCount(User user, boolean privateLayout) throws PortalException {
        return this.getLayoutsCount(user, privateLayout, true);
    }

    public int getLayoutsCount(User user, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(User.class);
        Group group = this.groupPersistence.findByC_C_C(user.getCompanyId(), classNameId, user.getUserId());
        return this.getLayoutsCount(group, privateLayout, includeUserGroups);
    }

    public long getNextLayoutId(long groupId, boolean privateLayout) {
        List layouts;
        long nextLayoutId = this.counterLocalService.increment(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout));
        if (nextLayoutId == 1L && !(layouts = this.layoutPersistence.findByG_P(groupId, privateLayout, 0, 1, (OrderByComparator)new LayoutComparator())).isEmpty()) {
            Layout layout = (Layout)layouts.get(0);
            nextLayoutId = layout.getLayoutId() + 1L;
            this.counterLocalService.reset(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout), nextLayoutId);
        }
        return nextLayoutId;
    }

    public List<Layout> getNoPermissionLayouts(long roleId) {
        return this.layoutFinder.findByNoPermissions(roleId);
    }

    public List<Layout> getNullFriendlyURLLayouts() {
        return this.layoutFinder.findByNullFriendlyURL();
    }

    public Layout getParentLayout(Layout layout) throws PortalException {
        Layout parentLayout = null;
        if (layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            Layout sourceLayout = virtualLayout.getSourceLayout();
            parentLayout = this.getLayout(sourceLayout.getGroupId(), sourceLayout.isPrivateLayout(), sourceLayout.getParentLayoutId());
            parentLayout = new VirtualLayout(parentLayout, layout.getGroup());
        } else {
            parentLayout = this.getLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        }
        return parentLayout;
    }

    public List<Layout> getScopeGroupLayouts(long parentGroupId) throws PortalException {
        int count;
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_ENABLED) {
            return this.layoutFinder.findByScopeGroup(parentGroupId);
        }
        Group parentGroup = this.groupPersistence.findByPrimaryKey(parentGroupId);
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD >= 0 && (count = this.groupLocalService.getGroupsCount(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId)) >= PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD) {
            return this.layoutFinder.findByScopeGroup(parentGroupId);
        }
        List groups = this.groupLocalService.getGroups(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId);
        ArrayList<Layout> layouts = new ArrayList<Layout>(groups.size());
        for (Group group : groups) {
            layouts.add(this.layoutPersistence.findByPrimaryKey(group.getClassPK()));
        }
        return layouts;
    }

    public List<Layout> getScopeGroupLayouts(long parentGroupId, boolean privateLayout) throws PortalException {
        int count;
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_ENABLED) {
            return this.layoutFinder.findByScopeGroup(parentGroupId, privateLayout);
        }
        Group parentGroup = this.groupPersistence.findByPrimaryKey(parentGroupId);
        if (PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD >= 0 && (count = this.groupLocalService.getGroupsCount(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId)) >= PropsValues.LAYOUT_SCOPE_GROUP_FINDER_THRESHOLD) {
            return this.layoutFinder.findByScopeGroup(parentGroupId, privateLayout);
        }
        List groups = this.groupLocalService.getGroups(parentGroup.getCompanyId(), Layout.class.getName(), parentGroupId);
        ArrayList<Layout> layouts = new ArrayList<Layout>(groups.size());
        for (Group group : groups) {
            Layout layout = this.layoutPersistence.findByPrimaryKey(group.getClassPK());
            if (layout.getPrivateLayout() != privateLayout) continue;
            layouts.add(layout);
        }
        return layouts;
    }

    public boolean hasLayouts(Group group) throws PortalException {
        List groupLayoutSets = this.layoutSetPersistence.findByGroupId(group.getGroupId());
        for (LayoutSet layoutSet : groupLayoutSets) {
            if (layoutSet.getPageCount() <= 0) continue;
            return true;
        }
        if (!group.isUser()) {
            return false;
        }
        long[] userGroupIds = this.userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this.groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                List userGroupGroupLayoutSets = this.layoutSetPersistence.findByGroupId(userGroupGroup.getGroupId());
                for (LayoutSet layoutSet : userGroupGroupLayoutSets) {
                    if (layoutSet.getPageCount() <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasLayouts(Group group, boolean privateLayout) throws PortalException {
        return this.hasLayouts(group, privateLayout, true);
    }

    public boolean hasLayouts(Group group, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(group.getGroupId(), privateLayout);
        if (layoutSet.getPageCount() > 0) {
            return true;
        }
        if (!group.isUser() || !includeUserGroups) {
            return false;
        }
        long[] userGroupIds = this.userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this.groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                layoutSet = this.layoutSetPersistence.findByG_P(userGroupGroup.getGroupId(), privateLayout);
                if (layoutSet.getPageCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLayouts(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.countByG_P_P(groupId, privateLayout, parentLayoutId) > 0;
    }

    public boolean hasLayouts(User user, boolean privateLayout) throws PortalException {
        return this.hasLayouts(user, privateLayout, true);
    }

    public boolean hasLayouts(User user, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(User.class);
        Group group = this.groupPersistence.findByC_C_C(user.getCompanyId(), classNameId, user.getUserId());
        return this.hasLayouts(group, privateLayout, includeUserGroups);
    }

    public boolean hasLayoutSetPrototypeLayout(long layoutSetPrototypeId, String layoutUuid) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId);
        return this.layoutLocalServiceHelper.hasLayoutSetPrototypeLayout(layoutSetPrototype, layoutUuid);
    }

    public boolean hasLayoutSetPrototypeLayout(String layoutSetPrototypeUuid, long companyId, String layoutUuid) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, companyId);
        return this.layoutLocalServiceHelper.hasLayoutSetPrototypeLayout(layoutSetPrototype, layoutUuid);
    }

    @Deprecated
    public void importLayouts(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importLayouts(ExportImportConfiguration exportImportConfiguration, InputStream is) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importLayoutsDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long importLayoutsInBackground(long userId, ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long importLayoutsInBackground(long userId, long exportImportConfigurationId, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long importLayoutsInBackground(long userId, String taskName, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long importLayoutsInBackground(long userId, String taskName, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importPortletDataDeletions(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream is) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importPortletInfo(long userId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void importPortletInfo(long userId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long importPortletInfoInBackground(long userId, ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long importPortletInfoInBackground(long userId, long exportImportConfigurationId, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long importPortletInfoInBackground(long userId, String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long importPortletInfoInBackground(long userId, String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long importPortletInfoInBackground(long userId, String taskName, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public long importPortletInfoInBackground(long userId, String taskName, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException {
        if (layoutIds == null) {
            return;
        }
        if (parentLayoutId == 0L) {
            if (layoutIds.length < 1) {
                throw new RequiredLayoutException(1);
            }
            Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutIds[0]);
            LayoutType layoutType = layout.getLayoutType();
            if (!layoutType.isFirstPageable()) {
                throw new RequiredLayoutException(3);
            }
        }
        LinkedHashSet<Long> layoutIdsSet = new LinkedHashSet<Long>();
        for (long layoutId : layoutIds) {
            layoutIdsSet.add(layoutId);
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
        for (Layout layout : layouts) {
            if (!layoutIdsSet.contains(layout.getLayoutId())) {
                this.deleteLayout(layout, true, serviceContext);
                continue;
            }
            hashSet.add(layout.getLayoutId());
        }
        int priority = 0;
        Iterator iterator = layoutIdsSet.iterator();
        while (iterator.hasNext()) {
            long layoutId = (Long)iterator.next();
            Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
            layout.setPriority(priority++);
            this.layoutPersistence.update((BaseModel)layout);
        }
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
    }

    public void updateAsset(long userId, Layout layout, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        this.assetEntryLocalService.updateEntry(userId, layout.getGroupId(), layout.getCreateDate(), layout.getModifiedDate(), Layout.class.getName(), layout.getPlid(), layout.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, null, "text/html", layout.getName(LocaleUtil.getDefault()), null, null, null, null, 0, 0, null);
    }

    public Layout updateFriendlyURL(long userId, long plid, String friendlyURL, String languageId) throws PortalException {
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        friendlyURL = this.layoutLocalServiceHelper.getFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), "", friendlyURL);
        this.layoutLocalServiceHelper.validateFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), friendlyURL);
        this.layoutFriendlyURLLocalService.updateLayoutFriendlyURL(userId, layout.getCompanyId(), layout.getGroupId(), layout.getPlid(), layout.isPrivateLayout(), friendlyURL, languageId, new ServiceContext());
        layout.setModifiedDate(now);
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        if (languageId.equals(defaultLanguageId)) {
            layout.setFriendlyURL(friendlyURL);
        }
        this.layoutPersistence.update((BaseModel)layout);
        return layout;
    }

    @Deprecated
    public Layout updateFriendlyURL(long plid, String friendlyURL, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updateFriendlyURL(layout.getUserId(), plid, friendlyURL, languageId);
    }

    public Layout updateIconImage(long plid, byte[] bytes) throws PortalException {
        Layout layout = this.layoutPersistence.fetchByPrimaryKey(plid);
        if (layout == null) {
            return null;
        }
        PortalUtil.updateImageId((BaseModel)layout, (boolean)true, (byte[])bytes, (String)"iconImageId", (long)0L, (int)0, (int)0);
        this.layoutPersistence.update((BaseModel)layout);
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException {
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        friendlyURLMap = this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = friendlyURLMap.get(LocaleUtil.getSiteDefault());
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURLMap, serviceContext);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(serviceContext.getModifiedDate(now));
        layout.setParentLayoutId(parentLayoutId);
        layout.setNameMap(nameMap);
        layout.setTitleMap(titleMap);
        layout.setDescriptionMap(descriptionMap);
        layout.setKeywordsMap(keywordsMap);
        layout.setRobotsMap(robotsMap);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        PortalUtil.updateImageId((BaseModel)layout, (boolean)iconImage, (byte[])iconBytes, (String)"iconImageId", (long)0L, (int)0, (int)0);
        boolean layoutUpdateable = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutUpdateable", (boolean)true);
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        typeSettingsProperties.put("layoutUpdateable", String.valueOf(layoutUpdateable));
        if (privateLayout) {
            typeSettingsProperties.put("privateLayout", String.valueOf(privateLayout));
        }
        layout.setTypeSettingsProperties(typeSettingsProperties);
        String layoutPrototypeUuid = ParamUtil.getString((ServiceContext)serviceContext, (String)"layoutPrototypeUuid");
        boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutPrototypeLinkEnabled");
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
            layout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
        }
        layout.setExpandoBridgeAttributes(serviceContext);
        this.layoutPersistence.update((BaseModel)layout);
        this.layoutFriendlyURLLocalService.updateLayoutFriendlyURLs(serviceContext.getUserId(), layout.getCompanyId(), layout.getGroupId(), layout.getPlid(), layout.isPrivateLayout(), friendlyURLMap, serviceContext);
        this.updateAsset(serviceContext.getUserId(), layout, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        Date now = new Date();
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(typeSettings);
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        this.validateTypeSettingsProperties(layout, typeSettingsProperties);
        layout.setModifiedDate(now);
        layout.setTypeSettings(typeSettingsProperties.toString());
        this.layoutPersistence.update((BaseModel)layout);
        return layout;
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        layout.setModifiedDate(now);
        layout.setThemeId(themeId);
        layout.setColorSchemeId(colorSchemeId);
        layout.setCss(css);
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateName(Layout layout, String name, String languageId) throws PortalException {
        Date now = new Date();
        this.layoutLocalServiceHelper.validateName(name, languageId);
        layout.setModifiedDate(now);
        layout.setName(name, LocaleUtil.fromLanguageId((String)languageId));
        layout = (Layout)this.layoutPersistence.update((BaseModel)layout);
        Group group = layout.getGroup();
        if (group.isLayoutPrototype()) {
            LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.getLayoutPrototype(group.getClassPK());
            layoutPrototype.setModifiedDate(now);
            layoutPrototype.setName(name, LocaleUtil.fromLanguageId((String)languageId));
            this.layoutPrototypePersistence.update((BaseModel)layoutPrototype);
        }
        return layout;
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        return this.updateName(layout, name, languageId);
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updateName(layout, name, languageId);
    }

    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException {
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(now);
        layout.setParentLayoutId(parentLayoutId);
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException {
        Layout parentLayout;
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        long parentLayoutId = 0L;
        if (parentPlid > 0L && (parentLayout = this.layoutPersistence.fetchByPrimaryKey(parentPlid)) != null) {
            parentLayoutId = parentLayout.getLayoutId();
        }
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId);
        this.layoutLocalServiceHelper.validateParentLayoutId(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), parentLayoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(now);
        layout.setParentLayoutId(parentLayoutId);
        return (Layout)this.layoutPersistence.update((BaseModel)layout);
    }

    public Layout updateParentLayoutIdAndPriority(long plid, long parentPlid, int priority) throws PortalException {
        Layout layout = this.updateParentLayoutId(plid, parentPlid);
        return this.layoutLocalService.updatePriority(layout, priority);
    }

    public void updatePriorities(long groupId, boolean privateLayout) throws PortalException {
        List layouts = this.layoutPersistence.findByG_P(groupId, privateLayout);
        for (Layout layout : layouts) {
            int nextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), layout.getPriority());
            layout.setPriority(nextPriority);
            this.layoutPersistence.update((BaseModel)layout);
        }
    }

    public Layout updatePriority(Layout layout, int priority) throws PortalException {
        int nextPriority;
        if (layout.getPriority() == priority) {
            return layout;
        }
        int oldPriority = layout.getPriority();
        if (oldPriority == (nextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), priority))) {
            return layout;
        }
        layout.setModifiedDate(new Date());
        layout.setPriority(nextPriority);
        layout = (Layout)this.layoutPersistence.update((BaseModel)layout);
        List layouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        boolean lessThan = false;
        if (oldPriority < nextPriority) {
            lessThan = true;
        }
        layouts = ListUtil.sort((List)layouts, (Comparator)new LayoutPriorityComparator(layout, lessThan));
        if (layout.getParentLayoutId() == 0L) {
            Layout firstLayout = (Layout)layouts.get(0);
            this.layoutLocalServiceHelper.validateFirstLayout(firstLayout);
        }
        int newPriority = 0;
        for (Layout curLayout : layouts) {
            int curNextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), curLayout.getSourcePrototypeLayoutUuid(), newPriority++);
            if (curLayout.getPriority() == curNextPriority) continue;
            curLayout.setModifiedDate(layout.getModifiedDate());
            curLayout.setPriority(curNextPriority);
            if (!(curLayout = (Layout)this.layoutPersistence.update((BaseModel)curLayout)).equals(layout)) continue;
            layout = curLayout;
        }
        return layout;
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        return this.updatePriority(layout, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws PortalException {
        Layout layout = this.getLayout(groupId, privateLayout, layoutId);
        int priority = layout.getPriority();
        Layout nextLayout = null;
        if (nextLayoutId > 0L) {
            nextLayout = this.getLayout(groupId, privateLayout, nextLayoutId);
        }
        Layout previousLayout = null;
        if (previousLayoutId > 0L) {
            previousLayout = this.getLayout(groupId, privateLayout, previousLayoutId);
        }
        if (nextLayout != null && priority > nextLayout.getPriority()) {
            priority = nextLayout.getPriority();
        } else if (previousLayout != null && priority < previousLayout.getPriority()) {
            priority = previousLayout.getPriority();
        }
        return this.updatePriority(layout, priority);
    }

    public Layout updatePriority(long plid, int priority) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updatePriority(layout, priority);
    }

    @Deprecated
    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public MissingReferences validateImportLayoutsFile(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public MissingReferences validateImportLayoutsFile(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream inputStream) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public MissingReferences validateImportPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public MissingReferences validateImportPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream inputStream) throws PortalException {
        throw new UnsupportedOperationException();
    }

    protected void validateTypeSettingsProperties(Layout layout, UnicodeProperties typeSettingsProperties) throws PortalException {
        String sitemapChangeFrequency = typeSettingsProperties.getProperty("sitemap-changefreq");
        if (!(!Validator.isNotNull((String)sitemapChangeFrequency) || sitemapChangeFrequency.equals("always") || sitemapChangeFrequency.equals("hourly") || sitemapChangeFrequency.equals("daily") || sitemapChangeFrequency.equals("weekly") || sitemapChangeFrequency.equals("monthly") || sitemapChangeFrequency.equals("yearly") || sitemapChangeFrequency.equals("never"))) {
            throw new SitemapChangeFrequencyException();
        }
        String sitemapInclude = typeSettingsProperties.getProperty("sitemap-include");
        if (Validator.isNotNull((String)sitemapInclude) && !sitemapInclude.equals("0") && !sitemapInclude.equals("1")) {
            throw new SitemapIncludeException();
        }
        String sitemapPriority = typeSettingsProperties.getProperty("sitemap-priority");
        if (Validator.isNotNull((String)sitemapPriority)) {
            try {
                double priority = Double.parseDouble(sitemapPriority);
                if (priority < 0.0 || priority > 1.0) {
                    throw new SitemapPagePriorityException();
                }
            }
            catch (NumberFormatException nfe) {
                throw new SitemapPagePriorityException((Throwable)nfe);
            }
        }
    }

    private List<Layout> _addChildUserGroupLayouts(Group group, List<Layout> layouts) throws PortalException {
        ArrayList<Layout> childLayouts = new ArrayList<Layout>(layouts.size());
        for (Layout layout : layouts) {
            Group layoutGroup = layout.getGroup();
            if (layoutGroup.isUserGroup()) {
                childLayouts.add((Layout)new VirtualLayout(layout, group));
                continue;
            }
            childLayouts.add(layout);
        }
        return childLayouts;
    }

    private List<Layout> _addUserGroupLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long parentLayoutId) throws PortalException {
        layouts = new ArrayList<Layout>(layouts);
        List userUserGroups = this.userGroupLocalService.getUserUserGroups(group.getClassPK());
        for (UserGroup userGroup : userUserGroups) {
            Group userGroupGroup = userGroup.getGroup();
            List<Layout> userGroupLayouts = this.getLayouts(userGroupGroup.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutId);
            for (Layout userGroupLayout : userGroupLayouts) {
                layouts.add((Layout)new VirtualLayout(userGroupLayout, group));
            }
        }
        return layouts;
    }

    private List<Layout> _addUserGroupLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long[] parentLayoutIds) throws PortalException {
        boolean copied = false;
        List userUserGroups = this.userGroupLocalService.getUserUserGroups(group.getClassPK());
        for (UserGroup userGroup : userUserGroups) {
            Group userGroupGroup = userGroup.getGroup();
            List<Layout> userGroupLayouts = this.getLayouts(userGroupGroup.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds);
            for (Layout userGroupLayout : userGroupLayouts) {
                if (!copied) {
                    layouts = new ArrayList<Layout>(layouts);
                    copied = true;
                }
                layouts.add((Layout)new VirtualLayout(userGroupLayout, group));
            }
        }
        return layouts;
    }

    private List<Layout> _getChildLayouts(LayoutSet layoutSet, long[] parentLayoutIds) {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return this.layoutPersistence.findByG_P_P(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds);
        }
        try {
            Group group = this.groupPersistence.findByPrimaryKey(layoutSet.getGroupId());
            if (layoutSet.isLayoutSetPrototypeLinkActive() && !this._mergeLayouts(group, layoutSet, layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds)) {
                return this.layoutPersistence.findByG_P_P(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds);
            }
            List layouts = this.layoutPersistence.findByG_P_P(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), parentLayoutIds);
            return this._injectVirtualLayouts(group, layoutSet, (List<Layout>)layouts, parentLayoutIds);
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    private List<Layout> _injectVirtualLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long parentLayoutId) throws PortalException {
        long targetGroupId;
        if (MergeLayoutPrototypesThreadLocal.isInProgress() || PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            return layouts;
        }
        if (group.isUser()) {
            _virtualLayoutTargetGroupId.set(group.getGroupId());
            if (parentLayoutId == 0L) {
                return this._addUserGroupLayouts(group, layoutSet, layouts, parentLayoutId);
            }
            return this._addChildUserGroupLayouts(group, layouts);
        }
        if (group.isUserGroup() && parentLayoutId != 0L && (targetGroupId = _virtualLayoutTargetGroupId.get().longValue()) != 0L) {
            Group targetGroup = this.groupLocalService.getGroup(targetGroupId);
            return this._addChildUserGroupLayouts(targetGroup, layouts);
        }
        return layouts;
    }

    private List<Layout> _injectVirtualLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long[] parentLayoutIds) throws PortalException {
        long targetGroupId;
        if (MergeLayoutPrototypesThreadLocal.isInProgress() || PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            return layouts;
        }
        if (group.isUser()) {
            _virtualLayoutTargetGroupId.set(group.getGroupId());
            if (ArrayUtil.contains((long[])parentLayoutIds, (long)0L)) {
                this._addUserGroupLayouts(group, layoutSet, layouts, parentLayoutIds);
                if (parentLayoutIds.length == 1) {
                    return layouts;
                }
            }
            return this._addChildUserGroupLayouts(group, layouts);
        }
        if (group.isUserGroup() && (targetGroupId = _virtualLayoutTargetGroupId.get().longValue()) != 0L) {
            Group targetGroup = this.groupLocalService.getGroup(targetGroupId);
            return this._addChildUserGroupLayouts(targetGroup, layouts);
        }
        return layouts;
    }

    private boolean _mergeLayout(Layout layout, Object ... arguments) throws PortalException {
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return false;
        }
        Group group = layout.getGroup();
        if (MergeLayoutPrototypesThreadLocal.isMergeComplete((String)"getLayout", (Object[])arguments) && (!group.isUser() || PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE)) {
            return false;
        }
        if (Validator.isNull((String)layout.getLayoutPrototypeUuid()) && Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) {
            return false;
        }
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        LayoutSet layoutSet = layout.getLayoutSet();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            SitesUtil.mergeLayoutPrototypeLayout((Group)group, (Layout)layout);
            if (Validator.isNotNull((String)layout.getSourcePrototypeLayoutUuid())) {
                SitesUtil.mergeLayoutSetPrototypeLayouts((Group)group, (LayoutSet)layoutSet);
            }
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setMergeComplete((String)"getLayout", (Object[])arguments);
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _mergeLayouts(Group group, LayoutSet layoutSet, Object ... arguments) {
        if (MergeLayoutPrototypesThreadLocal.isMergeComplete((String)"getLayouts", (Object[])arguments) && (!group.isUser() || PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE)) {
            return false;
        }
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            if (SitesUtil.isLayoutSetMergeable((Group)group, (LayoutSet)layoutSet)) {
                WorkflowThreadLocal.setEnabled((boolean)false);
                SitesUtil.mergeLayoutSetPrototypeLayouts((Group)group, (LayoutSet)layoutSet);
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to merge layouts for site template", (Throwable)e);
            }
        }
        finally {
            MergeLayoutPrototypesThreadLocal.setMergeComplete((String)"getLayouts", (Object[])arguments);
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
        return true;
    }
}

