/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.NoSuchLayoutFriendlyURLException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.LayoutFriendlyURLLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutFriendlyURLLocalServiceImpl
extends LayoutFriendlyURLLocalServiceBaseImpl {
    public LayoutFriendlyURL addLayoutFriendlyURL(long userId, long companyId, long groupId, long plid, boolean privateLayout, String friendlyURL, String languageId, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long layoutFriendlyURLId = this.counterLocalService.increment();
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.create(layoutFriendlyURLId);
        layoutFriendlyURL.setUuid(serviceContext.getUuid());
        layoutFriendlyURL.setGroupId(groupId);
        layoutFriendlyURL.setCompanyId(companyId);
        layoutFriendlyURL.setUserId(user.getUserId());
        layoutFriendlyURL.setUserName(user.getFullName());
        layoutFriendlyURL.setPlid(plid);
        layoutFriendlyURL.setPrivateLayout(privateLayout);
        layoutFriendlyURL.setFriendlyURL(friendlyURL);
        layoutFriendlyURL.setLanguageId(languageId);
        return (LayoutFriendlyURL)this.layoutFriendlyURLPersistence.update((BaseModel)layoutFriendlyURL);
    }

    public List<LayoutFriendlyURL> addLayoutFriendlyURLs(long userId, long companyId, long groupId, long plid, boolean privateLayout, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        ArrayList<LayoutFriendlyURL> layoutFriendlyURLs = new ArrayList<LayoutFriendlyURL>();
        for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
            String friendlyURL = friendlyURLMap.get(locale);
            if (Validator.isNull((String)friendlyURL)) continue;
            LayoutFriendlyURL layoutFriendlyURL = this.addLayoutFriendlyURL(userId, companyId, groupId, plid, privateLayout, friendlyURL, LocaleUtil.toLanguageId((Locale)locale), serviceContext);
            layoutFriendlyURLs.add(layoutFriendlyURL);
        }
        return layoutFriendlyURLs;
    }

    @Override
    public LayoutFriendlyURL deleteLayoutFriendlyURL(LayoutFriendlyURL layoutFriendlyURL) {
        return (LayoutFriendlyURL)this.layoutFriendlyURLPersistence.remove((BaseModel)layoutFriendlyURL);
    }

    public void deleteLayoutFriendlyURL(long plid, String languageId) {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL != null) {
            this.deleteLayoutFriendlyURL(layoutFriendlyURL);
        }
    }

    public void deleteLayoutFriendlyURLs(long plid) {
        List layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByPlid(plid);
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            this.deleteLayoutFriendlyURL(layoutFriendlyURL);
        }
    }

    public LayoutFriendlyURL fetchFirstLayoutFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        return this.layoutFriendlyURLPersistence.fetchByG_P_F_First(groupId, privateLayout, friendlyURL, null);
    }

    public LayoutFriendlyURL fetchLayoutFriendlyURL(long groupId, boolean privateLayout, String friendlyURL, String languageId) {
        return this.layoutFriendlyURLPersistence.fetchByG_P_F_L(groupId, privateLayout, friendlyURL, languageId);
    }

    public LayoutFriendlyURL fetchLayoutFriendlyURL(long plid, String languageId) {
        return this.fetchLayoutFriendlyURL(plid, languageId, true);
    }

    public LayoutFriendlyURL fetchLayoutFriendlyURL(long plid, String languageId, boolean useDefault) {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL == null && !useDefault) {
            return null;
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByPlid_First(plid, null);
        }
        return layoutFriendlyURL;
    }

    public LayoutFriendlyURL getLayoutFriendlyURL(long plid, String languageId) throws PortalException {
        return this.getLayoutFriendlyURL(plid, languageId, true);
    }

    public LayoutFriendlyURL getLayoutFriendlyURL(long plid, String languageId, boolean useDefault) throws PortalException {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL == null && !useDefault) {
            StringBundler sb = new StringBundler(5);
            sb.append("{plid=");
            sb.append(plid);
            sb.append(", languageId=");
            sb.append(languageId);
            sb.append("}");
            throw new NoSuchLayoutFriendlyURLException(sb.toString());
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
        }
        if (layoutFriendlyURL == null) {
            layoutFriendlyURL = this.layoutFriendlyURLPersistence.findByPlid_First(plid, null);
        }
        return layoutFriendlyURL;
    }

    public Map<Long, String> getLayoutFriendlyURLs(Group siteGroup, List<Layout> layouts, String languageId) {
        HashMap<Long, String> layoutFriendlyURLMap;
        block3: {
            block2: {
                layoutFriendlyURLMap = new HashMap<Long, String>();
                UnicodeProperties typeSettingsProperties = siteGroup.getTypeSettingsProperties();
                if (GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("inheritLocales"), (boolean)true)) break block2;
                Object[] locales = StringUtil.split((String)typeSettingsProperties.getProperty("locales"));
                if (ArrayUtil.contains((Object[])locales, (Object)languageId)) break block3;
                for (Layout layout : layouts) {
                    layoutFriendlyURLMap.put(layout.getPlid(), layout.getFriendlyURL());
                }
                break block3;
            }
            List layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByP_L(ListUtil.toLongArray(layouts, (Accessor)Layout.PLID_ACCESSOR), languageId);
            for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
                layoutFriendlyURLMap.put(layoutFriendlyURL.getPlid(), layoutFriendlyURL.getFriendlyURL());
            }
        }
        return layoutFriendlyURLMap;
    }

    public List<LayoutFriendlyURL> getLayoutFriendlyURLs(long plid) {
        return this.layoutFriendlyURLPersistence.findByPlid(plid);
    }

    public List<LayoutFriendlyURL> getLayoutFriendlyURLs(long plid, String friendlyURL, int start, int end) {
        return this.layoutFriendlyURLPersistence.findByP_F(plid, friendlyURL, start, end);
    }

    public LayoutFriendlyURL updateLayoutFriendlyURL(long userId, long companyId, long groupId, long plid, boolean privateLayout, String friendlyURL, String languageId, ServiceContext serviceContext) throws PortalException {
        LayoutFriendlyURL layoutFriendlyURL = this.layoutFriendlyURLPersistence.fetchByP_L(plid, languageId);
        if (layoutFriendlyURL == null) {
            return this.addLayoutFriendlyURL(userId, companyId, groupId, plid, privateLayout, friendlyURL, languageId, serviceContext);
        }
        layoutFriendlyURL.setFriendlyURL(friendlyURL);
        return (LayoutFriendlyURL)this.layoutFriendlyURLPersistence.update((BaseModel)layoutFriendlyURL);
    }

    public List<LayoutFriendlyURL> updateLayoutFriendlyURLs(long userId, long companyId, long groupId, long plid, boolean privateLayout, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        ArrayList<LayoutFriendlyURL> layoutFriendlyURLs = new ArrayList<LayoutFriendlyURL>();
        for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
            String friendlyURL = friendlyURLMap.get(locale);
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            if (Validator.isNull((String)friendlyURL)) {
                this.deleteLayoutFriendlyURL(plid, languageId);
                continue;
            }
            LayoutFriendlyURL layoutFriendlyURL = this.updateLayoutFriendlyURL(userId, companyId, groupId, plid, privateLayout, friendlyURL, languageId, serviceContext);
            layoutFriendlyURLs.add(layoutFriendlyURL);
        }
        return layoutFriendlyURLs;
    }
}

