/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.external;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.RepositoryConfiguration;
import com.liferay.portal.kernel.repository.RepositoryConfigurationBuilder;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.registry.BaseRepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.repository.util.ExternalRepositoryFactoryUtil;

public class LegacyExternalRepositoryDefiner
extends BaseRepositoryDefiner {
    private static volatile PortalCapabilityLocator _portalCapabilityLocator = (PortalCapabilityLocator)ServiceProxyFactory.newServiceTrackedInstance(PortalCapabilityLocator.class, LegacyExternalRepositoryDefiner.class, (String)"_portalCapabilityLocator", (boolean)false);
    private final String _className;
    private RepositoryConfiguration _repositoryConfiguration;
    private final RepositoryFactory _repositoryFactory;
    private final ResourceBundleLoader _resourceBundleLoader;

    public LegacyExternalRepositoryDefiner(String className, RepositoryFactory repositoryFactory, ResourceBundleLoader resourceBundleLoader) {
        this._className = className;
        this._repositoryFactory = repositoryFactory;
        this._resourceBundleLoader = resourceBundleLoader;
    }

    public String getClassName() {
        return this._className;
    }

    public RepositoryConfiguration getRepositoryConfiguration() {
        try {
            if (this._repositoryConfiguration != null) {
                return this._repositoryConfiguration;
            }
            BaseRepository baseRepository = ExternalRepositoryFactoryUtil.getInstance(this.getClassName());
            String[][] supportedParameters = baseRepository.getSupportedParameters();
            int size = 0;
            if (supportedParameters != null && supportedParameters[0] != null) {
                size = supportedParameters[0].length;
            }
            RepositoryConfigurationBuilder repositoryConfigurationBuilder = new RepositoryConfigurationBuilder(this._resourceBundleLoader, new String[0]);
            for (int i = 0; i < size; ++i) {
                repositoryConfigurationBuilder.addParameter(supportedParameters[0][i]);
            }
            this._repositoryConfiguration = repositoryConfigurationBuilder.build();
            return this._repositoryConfiguration;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public boolean isExternalRepository() {
        return true;
    }

    public void registerCapabilities(CapabilityRegistry<DocumentRepository> capabilityRegistry) {
        capabilityRegistry.addSupportedCapability(ProcessorCapability.class, (Capability)_portalCapabilityLocator.getProcessorCapability((DocumentRepository)capabilityRegistry.getTarget(), ProcessorCapability.ResourceGenerationStrategy.ALWAYS_GENERATE));
    }

    public void registerRepositoryFactory(RepositoryFactoryRegistry repositoryFactoryRegistry) {
        repositoryFactoryRegistry.setRepositoryFactory(this._repositoryFactory);
    }
}

