/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodNameCheck
extends com.puppycrawl.tools.checkstyle.checks.naming.MethodNameCheck {
    private static final String _MSG_RENAME_METHOD = "method.rename";
    private boolean _checkDoMethodName;
    private final Pattern _doMethodNamePattern = Pattern.compile("^_do([A-Z])(.*)$");

    public void setCheckDoMethodName(boolean checkDoMethodName) {
        this._checkDoMethodName = checkDoMethodName;
    }

    public void visitToken(DetailAST detailAST) {
        if (this._checkDoMethodName) {
            this._checkDoMethodName(detailAST);
        }
        super.visitToken(detailAST);
    }

    protected boolean mustCheckName(DetailAST detailAST) {
        if (AnnotationUtility.containsAnnotation((DetailAST)detailAST, (String)"Reference")) {
            return false;
        }
        DetailAST modifiersAST = detailAST.findFirstToken(5);
        return this.shouldCheckInScope(modifiersAST);
    }

    private void _checkDoMethodName(DetailAST detailAST) {
        String name = this._getMethodName(detailAST);
        Matcher matcher = this._doMethodNamePattern.matcher(name);
        if (!matcher.find()) {
            return;
        }
        String noDoName = "_" + StringUtil.toLowerCase(matcher.group(1)) + matcher.group(2);
        String noUnderscoreName = name.substring(1);
        DetailAST parentAST = detailAST.getParent();
        List<DetailAST> methodDefASTList = DetailASTUtil.getAllChildTokens(parentAST, false, 9);
        for (DetailAST methodDefAST : methodDefASTList) {
            String methodName = this._getMethodName(methodDefAST);
            if (!methodName.equals(noDoName) && !methodName.equals(noUnderscoreName)) continue;
            return;
        }
        this.log(detailAST.getLineNo(), _MSG_RENAME_METHOD, new Object[]{name, noDoName});
    }

    private String _getMethodName(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        return nameAST.getText();
    }
}

