/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class JSONNamingCheck
extends AbstractCheck {
    private static final String _MSG_RENAME_VARIABLE = "variable.rename";
    private static final String _MSG_RESERVED_VARIABLE_NAME = "variable.name.reserved";

    public int[] getDefaultTokens() {
        return new int[]{9, 21, 10};
    }

    public void visitToken(DetailAST detailAST) {
        String typeName = DetailASTUtil.getTypeName(detailAST);
        if (typeName.equals("boolean") || typeName.equals("void")) {
            return;
        }
        String name = this._getName(detailAST);
        String tokenTypeName = this._getTokenTypeName(detailAST);
        this._checkName(name, typeName, tokenTypeName, "String", "JSON", "Json", detailAST.getLineNo());
        this._checkName(name, typeName, tokenTypeName, "JSONArray", "JSONArray", "JsonArray", detailAST.getLineNo());
        this._checkName(name, typeName, tokenTypeName, "JSONObject", "JSONObject", "JsonObject", detailAST.getLineNo());
    }

    private void _checkName(String name, String typeName, String tokenTypeName, String type, String reservedNameEnding, String incorrectNameEnding, int lineNo) {
        String lowerCaseName = StringUtil.toLowerCase(name);
        if (!lowerCaseName.endsWith(StringUtil.toLowerCase(reservedNameEnding))) {
            return;
        }
        if (!typeName.equals(type) && !typeName.endsWith("." + type)) {
            String lowerCaseTypeName = StringUtil.toLowerCase(typeName);
            if (!lowerCaseTypeName.endsWith(StringUtil.toLowerCase(type))) {
                this.log(lineNo, _MSG_RESERVED_VARIABLE_NAME, new Object[]{tokenTypeName, reservedNameEnding, type});
            }
            return;
        }
        if (name.endsWith(incorrectNameEnding)) {
            this.log(lineNo, _MSG_RENAME_VARIABLE, new Object[]{StringUtil.toLowerCase(tokenTypeName), name, StringUtil.replaceLast(name, incorrectNameEnding, reservedNameEnding)});
        }
    }

    private String _getName(DetailAST detailAST) {
        DetailAST nameAST = detailAST.findFirstToken(58);
        return nameAST.getText();
    }

    private String _getTokenTypeName(DetailAST detailAST) {
        if (detailAST.getType() == 9) {
            return "Method";
        }
        if (detailAST.getType() == 21) {
            return "Parameter";
        }
        return "Variable";
    }
}

