/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.TagAttributesCheck;

public class XMLTagAttributesCheck
extends TagAttributesCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        content = this._formatTagAttributes(fileName, content);
        return content;
    }

    private String _formatTagAttributes(String fileName, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineCount = 0;
            boolean sortAttributes = true;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                String trimmedLine = StringUtil.trimLeading(line);
                if (sortAttributes) {
                    if (!(!trimmedLine.startsWith("<") || !trimmedLine.endsWith(">") || trimmedLine.startsWith("<?") || trimmedLine.startsWith("<%") || trimmedLine.startsWith("<!") || line.contains("<![CDATA[") && line.contains("]]>"))) {
                        line = this.formatTagAttributes(fileName, line, trimmedLine, lineCount, true);
                    } else if (trimmedLine.startsWith("<![CDATA[") && !trimmedLine.endsWith("]]>")) {
                        sortAttributes = false;
                    }
                } else if (trimmedLine.endsWith("]]>")) {
                    sortAttributes = true;
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

