/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLCustomSQLFileCheck
extends BaseFileCheck {
    private static final String _CUSTOM_FINDER_SCALABILITY_EXCLUDES = "custom.finder.scalability.excludes";
    private final Pattern _whereNotInSQLPattern = Pattern.compile("WHERE[ \t\n]+\\(*[a-zA-z0-9.]+ NOT IN");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.contains("/custom-sql/")) {
            this._checkCustomSQLXML(fileName, fileName, content);
        }
        return content;
    }

    private void _checkCustomSQLXML(String fileName, String absolutePath, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        this.checkElementOrder(fileName, document.getRootElement(), "sql", null, new CustomSQLElementComparator("id"));
        Matcher matcher = this._whereNotInSQLPattern.matcher(content);
        while (matcher.find()) {
            int x = content.lastIndexOf("<sql id=", matcher.start());
            int y = content.indexOf(34, x);
            int z = content.indexOf(34, y + 1);
            String id = content.substring(y + 1, z);
            String entityName = id.substring((y = id.lastIndexOf(46, (x = id.lastIndexOf(46)) - 1)) + 1, x);
            if (this.isExcludedPath(_CUSTOM_FINDER_SCALABILITY_EXCLUDES, absolutePath, entityName)) continue;
            this.addMessage(fileName, "Avoid using WHERE ... NOT IN: " + id + ", see LPS-51315");
        }
    }

    private class CustomSQLElementComparator
    extends ElementComparator {
        public CustomSQLElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public int compare(Element sqlElement1, Element sqlElement2) {
            String finderKeyName2;
            String sqlElementName1 = this.getElementName(sqlElement1);
            String sqlElementName2 = this.getElementName(sqlElement2);
            String finderObjectName1 = this._getFinderObjectName(sqlElementName1);
            String finderObjectName2 = this._getFinderObjectName(sqlElementName2);
            if (finderObjectName1 == null || finderObjectName2 == null) {
                return 0;
            }
            int value = finderObjectName1.compareToIgnoreCase(finderObjectName2);
            if (value != 0) {
                return value;
            }
            String finderKeyName1 = this._getFinderKeyName(sqlElementName1);
            int startsWithWeight = StringUtil.startsWithWeight(finderKeyName1, finderKeyName2 = this._getFinderKeyName(sqlElementName2));
            if (startsWithWeight == 0) {
                return finderKeyName1.compareTo(finderKeyName2);
            }
            String startFinder = finderKeyName1.substring(0, startsWithWeight);
            if (!startFinder.contains("By")) {
                NaturalOrderStringComparator comparator = new NaturalOrderStringComparator();
                return comparator.compare(finderKeyName1, finderKeyName2);
            }
            int columnCount1 = StringUtil.count(sqlElementName1, '_');
            int columnCount2 = StringUtil.count(sqlElementName2, '_');
            return columnCount1 - columnCount2;
        }

        private String _getFinderKeyName(String elementName) {
            if (Validator.isNull(elementName)) {
                return null;
            }
            int pos = elementName.lastIndexOf(".");
            if (pos == -1) {
                return null;
            }
            return elementName.substring(pos + 1);
        }

        private String _getFinderObjectName(String elementName) {
            if (Validator.isNull(elementName)) {
                return null;
            }
            int pos = elementName.lastIndexOf(".");
            if (pos == -1) {
                return null;
            }
            return elementName.substring(0, pos);
        }
    }
}

