/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringBundlerCheck
extends BaseFileCheck {
    private final Pattern _sbAppendPattern = Pattern.compile("\\s*\\w*(sb|SB)[0-9]?\\.append\\(\\s*(\\S.*?)\\);\n", 32);
    private final Pattern _sbAppendWithStartingSpacePattern = Pattern.compile("\n(\t*\\w*(sb|SB)[0-9]?\\.append\\(\".*\"\\);)\n\\s*\\w*(sb|SB)[0-9]?\\.append\\(\" .*\"\\);\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._formatStringBundler(fileName, content);
    }

    private String _formatStringBundler(String fileName, String content) {
        Matcher matcher = this._sbAppendPattern.matcher(content);
        block0: while (matcher.find()) {
            String[] appendValueParts;
            String appendValue = this.stripQuotes(matcher.group(2), '\"');
            if (!(appendValue = StringUtil.replace(appendValue, "+\n", "+ ")).contains(" + ")) continue;
            for (String appendValuePart : appendValueParts = StringUtil.split(appendValue, " + ")) {
                if (this.getLevel(appendValuePart) != 0 || Validator.isNumber(appendValuePart)) continue block0;
            }
            this.addMessage(fileName, "Incorrect use of '+' inside StringBundler", this.getLineCount(content, matcher.start(1)));
        }
        matcher = this._sbAppendWithStartingSpacePattern.matcher(content);
        while (matcher.find()) {
            String firstLine = matcher.group(1);
            if (firstLine.endsWith("\\n\");")) continue;
            if (this.getMaxLineLength() != -1 && this.getLineLength(firstLine) >= this.getMaxLineLength()) {
                this.addMessage(fileName, "Do not append string starting with space to StringBundler", this.getLineCount(content, matcher.start(3)));
                continue;
            }
            content = StringUtil.replaceFirst(content, "\");\n", " \");\n", matcher.start(2));
            content = StringUtil.replaceFirst(content, "(\" ", "(\"", matcher.start(3));
        }
        return content;
    }
}

