/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;

public class JavaServiceImplCheck
extends BaseJavaTermCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaClass javaClass = javaTerm.getParentJavaClass();
        String className = javaClass.getName();
        if (className.endsWith("ServiceImpl")) {
            return this._formatServiceImpl(javaTerm);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private String _formatServiceImpl(JavaTerm javaTerm) {
        String javaTermContent = javaTerm.getContent();
        String javaTermName = javaTerm.getName();
        if (!javaTermName.equals("afterPropertiesSet") && !javaTermName.equals("destroy") || !javaTerm.hasAnnotation("Override")) {
            return javaTermContent;
        }
        String superMethodCall = "super." + javaTermName + "();";
        if (javaTermContent.contains(superMethodCall)) {
            return javaTermContent;
        }
        String indent = SourceUtil.getIndent(javaTermContent) + "\t";
        return StringUtil.replaceFirst(javaTermContent, "{\n", "{\n" + indent + superMethodCall + "\n\n");
    }
}

