/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaModuleServiceReferenceCheck
extends BaseFileCheck {
    private final Pattern _serviceReferencePattern = Pattern.compile("@ServiceReference\\(\\s*type = ([\\w.]+)\\.class\\)\n");

    @Override
    public boolean isModulesCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        String packagePath = JavaSourceUtil.getPackagePath(content);
        int pos = packagePath.indexOf(".service.");
        if (pos == -1) {
            return content;
        }
        String servicePackagePath = packagePath.substring(0, pos + 8);
        this._checkServiceReferences(fileName, content, packagePath, servicePackagePath);
        return content;
    }

    private void _checkServiceReferences(String fileName, String content, String packagePath, String servicePackagePath) {
        Matcher matcher = this._serviceReferencePattern.matcher(content);
        while (matcher.find()) {
            String className = this._getFullClassName(content, matcher.group(1), packagePath);
            if (!className.startsWith(servicePackagePath)) continue;
            this.addMessage(fileName, "Use @BeanReference instead of @ServiceReference", this.getLineCount(content, matcher.start()));
        }
    }

    private String _getFullClassName(String content, String className, String packagePath) {
        if (className.contains(".")) {
            return className;
        }
        Pattern pattern = Pattern.compile("import (.*" + className + ");");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return packagePath + "." + className;
    }
}

