/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.EmptyLinesCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaEmptyLinesCheck
extends EmptyLinesCheck {
    private final Pattern _redundantEmptyLinePattern = Pattern.compile("-> \\{\n\n[\t ]*(?!// )\\S");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this.fixMissingEmptyLines(content);
        content = this.fixRedundantEmptyLines(content);
        content = this.fixIncorrectEmptyLineBeforeCloseCurlyBrace(content);
        content = this.fixMissingEmptyLineAfterSettingVariable(content);
        content = this._fixRedundantEmptyLineInLambdaExpression(content);
        return content;
    }

    private String _fixRedundantEmptyLineInLambdaExpression(String content) {
        Matcher matcher = this._redundantEmptyLinePattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }
}

