/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.portal.xml.SAXReaderFactory;
import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ToolsUtil {
    public static final String AUTHOR = "Brian Wing Shun Chan";
    public static final int PLUGINS_MAX_DIR_LEVEL = 3;
    public static final int PORTAL_MAX_DIR_LEVEL = 7;
    private static final String _TMP_DIR = System.getProperty("java.io.tmpdir");

    public static String getContent(String fileName) throws Exception {
        Document document = ToolsUtil._getContentDocument(fileName);
        Element rootElement = document.getRootElement();
        Element authorElement = null;
        Element namespaceElement = null;
        TreeMap<String, Element> entityElements = new TreeMap<String, Element>();
        TreeMap<String, Element> exceptionElements = new TreeMap<String, Element>();
        List elements = rootElement.elements();
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("author")) {
                element.detach();
                if (authorElement != null) {
                    throw new IllegalArgumentException("There can only be one author element");
                }
                authorElement = element;
                continue;
            }
            if (elementName.equals("namespace")) {
                element.detach();
                if (namespaceElement != null) {
                    throw new IllegalArgumentException("There can only be one namespace element");
                }
                namespaceElement = element;
                continue;
            }
            if (elementName.equals("entity")) {
                element.detach();
                String name = element.attributeValue("name");
                entityElements.put(StringUtil.toLowerCase(name), element);
                continue;
            }
            if (!elementName.equals("exceptions")) continue;
            element.detach();
            List exceptionElementsList = element.elements("exception");
            for (Element exceptionElement : exceptionElementsList) {
                exceptionElement.detach();
                exceptionElements.put(exceptionElement.getText(), exceptionElement);
            }
        }
        if (authorElement != null) {
            rootElement.add(authorElement);
        }
        if (namespaceElement == null) {
            throw new IllegalArgumentException("The namespace element is required");
        }
        rootElement.add(namespaceElement);
        ToolsUtil._addElements(rootElement, entityElements);
        if (!exceptionElements.isEmpty()) {
            Element exceptionsElement = rootElement.addElement("exceptions");
            ToolsUtil._addElements(exceptionsElement, exceptionElements);
        }
        return document.asXML();
    }

    public static String getPackagePath(File file) {
        String fileName = StringUtil.replace(file.toString(), '\\', '/');
        return ToolsUtil.getPackagePath(fileName);
    }

    public static String getPackagePath(String fileName) {
        int x = Math.max(fileName.lastIndexOf("/com/"), fileName.lastIndexOf("/org/"));
        int y = fileName.lastIndexOf(47);
        String packagePath = fileName.substring(x + 1, y);
        return StringUtil.replace(packagePath, '/', '.');
    }

    public static boolean isInsideQuotes(String s, int pos) {
        int end;
        int start = s.lastIndexOf(10, pos);
        if (start == -1) {
            start = 0;
        }
        if ((end = s.indexOf(10, pos)) == -1) {
            end = s.length();
        }
        String line = s.substring(start, end);
        pos -= start;
        char delimeter = ' ';
        boolean insideQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (insideQuotes) {
                if (c == delimeter) {
                    int precedingBackSlashCount = 0;
                    for (int j = i - 1; j >= 0 && line.charAt(j) == '\\'; --j) {
                        ++precedingBackSlashCount;
                    }
                    if (precedingBackSlashCount == 0 || precedingBackSlashCount % 2 == 0) {
                        insideQuotes = false;
                    }
                }
            } else if (c == '\'' || c == '\"') {
                delimeter = c;
                insideQuotes = true;
            }
            if (pos != i) continue;
            return insideQuotes;
        }
        return false;
    }

    @Deprecated
    public static String stripFullyQualifiedClassNames(String content) throws IOException {
        return ToolsUtil.stripFullyQualifiedClassNames(content, null);
    }

    public static String stripFullyQualifiedClassNames(String content, String packagePath) throws IOException {
        String imports = JavaImportsFormatter.getImports(content);
        return ToolsUtil.stripFullyQualifiedClassNames(content, imports, packagePath);
    }

    public static String stripFullyQualifiedClassNames(String content, String imports, String packagePath) throws IOException {
        if (Validator.isNull(content) || Validator.isNull(imports)) {
            return content;
        }
        Pattern pattern1 = Pattern.compile("\n(.*)" + StringUtil.replace(packagePath, '.', "\\.") + "\\.([A-Z]\\w+)\\W");
        block0: while (true) {
            Matcher matcher1 = pattern1.matcher(content);
            while (matcher1.find()) {
                String lineStart = StringUtil.trimLeading(matcher1.group(1));
                if (lineStart.startsWith("import ") || lineStart.contains("//") || ToolsUtil.isInsideQuotes(content, matcher1.start(2))) continue;
                String className = matcher1.group(2);
                Pattern pattern2 = Pattern.compile("import [\\w.]+\\." + className + ";");
                Matcher matcher2 = pattern2.matcher(imports);
                if (matcher2.find()) continue;
                content = StringUtil.replaceFirst(content, packagePath + ".", "", matcher1.start());
                continue block0;
            }
            break;
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(imports));
        String line = null;
        block2: while ((line = unsyncBufferedReader.readLine()) != null) {
            String importPackageAndClassName;
            int x = line.indexOf("import ");
            if (x == -1 || (importPackageAndClassName = line.substring(x + 7, line.lastIndexOf(";"))).contains("*")) continue;
            Pattern pattern3 = Pattern.compile("\n(.*)(" + StringUtil.replace(importPackageAndClassName, ".", "\\.") + ")\\W");
            block3: while (true) {
                Matcher matcher3 = pattern3.matcher(content);
                while (matcher3.find()) {
                    String lineStart = StringUtil.trimLeading(matcher3.group(1));
                    if (lineStart.startsWith("import ") || lineStart.contains("//") || ToolsUtil.isInsideQuotes(content, matcher3.start(2))) continue;
                    String importClassName = importPackageAndClassName.substring(importPackageAndClassName.lastIndexOf(".") + 1);
                    content = StringUtil.replaceFirst(content, importPackageAndClassName, importClassName, matcher3.start());
                    continue block3;
                }
                continue block2;
                break;
            }
        }
        return content;
    }

    public static void writeFile(File file, String content, Set<String> modifiedFileNames) throws IOException {
        ToolsUtil.writeFile(file, content, AUTHOR, modifiedFileNames);
    }

    public static void writeFile(File file, String content, String author, Map<String, Object> jalopySettings, Set<String> modifiedFileNames) throws IOException {
        String packagePath = ToolsUtil.getPackagePath(file);
        String className = file.getName();
        className = className.substring(0, className.length() - 5);
        JavaImportsFormatter importsFormatter = new JavaImportsFormatter();
        content = importsFormatter.format(content, packagePath, className);
        File tempFile = new File(_TMP_DIR, "ServiceBuilder.temp");
        ToolsUtil._write(tempFile, content);
        StringBuffer sb = new StringBuffer();
        Jalopy jalopy = new Jalopy();
        jalopy.setFileFormat(FileFormat.UNIX);
        jalopy.setInput(tempFile);
        jalopy.setOutput(sb);
        File jalopyXmlFile = new File("tools/jalopy.xml");
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("../tools/jalopy.xml");
        }
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("misc/jalopy.xml");
        }
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("../misc/jalopy.xml");
        }
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("../../misc/jalopy.xml");
        }
        if (jalopyXmlFile.exists()) {
            Jalopy.setConvention((File)jalopyXmlFile);
        } else {
            URL url = ToolsUtil._readJalopyXmlFromClassLoader();
            Jalopy.setConvention((URL)url);
        }
        if (jalopySettings == null) {
            jalopySettings = new HashMap<String, Object>();
        }
        Environment env = Environment.getInstance();
        author = GetterUtil.getString((String)jalopySettings.get("author"), author);
        env.set("author", (Object)author);
        boolean failOnFormatError = MapUtil.getBoolean(jalopySettings, "failOnFormatError");
        env.set("fileName", (Object)file.getName());
        Convention convention = Convention.getInstance();
        String classMask = "/**\n * @author $author$\n*/";
        convention.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, env.interpolate(classMask));
        convention.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, env.interpolate(classMask));
        boolean formatSuccess = jalopy.format();
        String newContent = sb.toString();
        newContent = newContent.replaceFirst("(?m)^[ \t]*((?:package|import) .*;)\\s*^[ \t]*/\\*\\*", "$1\n\n/**");
        ToolsUtil.writeFileRaw(file, newContent, modifiedFileNames);
        tempFile.deleteOnExit();
        if (failOnFormatError && !formatSuccess) {
            throw new IOException("Unable to beautify " + file);
        }
    }

    public static void writeFile(File file, String content, String author, Set<String> modifiedFileNames) throws IOException {
        ToolsUtil.writeFile(file, content, author, null, modifiedFileNames);
    }

    public static void writeFileRaw(File file, String content, Set<String> modifiedFileNames) throws IOException {
        if (!file.exists() || !content.equals(ToolsUtil._read(file))) {
            ToolsUtil._write(file, content);
            if (modifiedFileNames != null) {
                modifiedFileNames.add(file.getAbsolutePath());
            }
            System.out.println("Writing " + file);
        }
    }

    private static void _addElements(Element element, Map<String, Element> elements) {
        for (Map.Entry<String, Element> entry : elements.entrySet()) {
            Element childElement = entry.getValue();
            element.add(childElement);
        }
    }

    private static Document _getContentDocument(String fileName) throws Exception {
        SAXReader saxReader = ToolsUtil._getSAXReader();
        Document document = saxReader.read(new File(fileName));
        Element rootElement = document.getRootElement();
        List elements = rootElement.elements();
        for (Element element : elements) {
            String elementName = element.getName();
            if (!elementName.equals("service-builder-import")) continue;
            element.detach();
            String dirName = fileName.substring(0, fileName.lastIndexOf("/") + 1);
            String serviceBuilderImportFileName = element.attributeValue("file");
            Document serviceBuilderImportDocument = ToolsUtil._getContentDocument(dirName + serviceBuilderImportFileName);
            Element serviceBuilderImportRootElement = serviceBuilderImportDocument.getRootElement();
            List serviceBuilderImportElements = serviceBuilderImportRootElement.elements();
            for (Element serviceBuilderImportElement : serviceBuilderImportElements) {
                serviceBuilderImportElement.detach();
                rootElement.add(serviceBuilderImportElement);
            }
        }
        return document;
    }

    private static SAXReader _getSAXReader() {
        return SAXReaderFactory.getSAXReader(null, false, false);
    }

    private static String _read(File file) throws IOException {
        String s = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        return StringUtil.replace(s, "\r\n", "\n");
    }

    private static URL _readJalopyXmlFromClassLoader() {
        ClassLoader classLoader = ToolsUtil.class.getClassLoader();
        URL url = classLoader.getResource("jalopy.xml");
        if (url == null) {
            throw new RuntimeException("Unable to load jalopy.xml from the class loader");
        }
        return url;
    }

    private static void _write(File file, String s) throws IOException {
        Path path = file.toPath();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, s.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

