/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.NumberFormat;
import java.util.Locale;

public class TextFormatter {
    public static final int A = 0;
    public static final int B = 1;
    public static final int C = 2;
    public static final int D = 3;
    public static final int E = 4;
    public static final int F = 5;
    public static final int G = 6;
    public static final int H = 7;
    public static final int I = 8;
    public static final int J = 9;
    public static final int K = 10;
    public static final int L = 11;
    public static final int M = 12;
    public static final int N = 13;
    public static final int O = 14;
    public static final int P = 15;
    public static final int Q = 16;
    private static final double _STORAGE_SIZE_DENOMINATOR = 1024.0;
    private static final String _STORAGE_SIZE_SUFFIX_GB = "GB";
    private static final String _STORAGE_SIZE_SUFFIX_KB = "KB";
    private static final String _STORAGE_SIZE_SUFFIX_MB = "MB";

    public static String format(String s, int style) {
        if (Validator.isNull(s)) {
            return null;
        }
        s = s.trim();
        if (style == 0) {
            return TextFormatter._formatA(s);
        }
        if (style == 1) {
            return TextFormatter._formatB(s);
        }
        if (style == 2) {
            return TextFormatter._formatC(s);
        }
        if (style == 3) {
            return TextFormatter._formatD(s);
        }
        if (style == 4) {
            return TextFormatter._formatE(s);
        }
        if (style == 5) {
            return TextFormatter._formatF(s);
        }
        if (style == 6) {
            return TextFormatter._formatG(s);
        }
        if (style == 7) {
            return TextFormatter._formatH(s);
        }
        if (style == 8) {
            return TextFormatter._formatI(s);
        }
        if (style == 9) {
            return TextFormatter._formatJ(s);
        }
        if (style == 10) {
            return TextFormatter._formatK(s);
        }
        if (style == 11) {
            return TextFormatter._formatL(s);
        }
        if (style == 12) {
            return TextFormatter._formatM(s);
        }
        if (style == 13) {
            return TextFormatter._formatN(s);
        }
        if (style == 14) {
            return TextFormatter._formatO(s);
        }
        if (style == 15) {
            return TextFormatter._formatP(s);
        }
        if (style == 16) {
            return TextFormatter._formatQ(s);
        }
        return s;
    }

    @Deprecated
    public static String formatKB(double size, Locale locale) {
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumFractionDigits(1);
        numberFormat.setMinimumFractionDigits(1);
        return numberFormat.format(size / 1024.0);
    }

    @Deprecated
    public static String formatKB(int size, Locale locale) {
        return TextFormatter.formatKB((double)size, locale);
    }

    public static String formatName(String name) {
        if (Validator.isNull(name)) {
            return name;
        }
        char[] chars = StringUtil.toLowerCase(name).trim().toCharArray();
        if (chars.length > 0) {
            chars[0] = Character.toUpperCase(chars[0]);
        }
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != ' ') continue;
            chars[i + 1] = Character.toUpperCase(chars[i + 1]);
        }
        return new String(chars);
    }

    public static String formatPlural(String s) {
        if (Validator.isNull(s)) {
            return s;
        }
        s = s.endsWith("s") ? s.substring(0, s.length() - 1) + "ses" : (s.endsWith("y") ? s.substring(0, s.length() - 1) + "ies" : s + "s");
        return s;
    }

    public static String formatStorageSize(double size, Locale locale) {
        String suffix = _STORAGE_SIZE_SUFFIX_KB;
        if ((size /= 1024.0) >= 1024.0) {
            suffix = _STORAGE_SIZE_SUFFIX_MB;
            size /= 1024.0;
        }
        if (size >= 1024.0) {
            suffix = _STORAGE_SIZE_SUFFIX_GB;
            size /= 1024.0;
        }
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        if (suffix.equals(_STORAGE_SIZE_SUFFIX_KB)) {
            numberFormat.setMaximumFractionDigits(0);
        } else {
            numberFormat.setMaximumFractionDigits(1);
        }
        numberFormat.setMinimumFractionDigits(0);
        return numberFormat.format(size) + suffix;
    }

    public static String formatStorageSize(int size, Locale locale) {
        return TextFormatter.formatStorageSize((double)size, locale);
    }

    private static String _formatA(String s) {
        return StringUtil.replace(StringUtil.toUpperCase(s), ' ', '_');
    }

    private static String _formatB(String s) {
        return StringUtil.strip(StringUtil.toLowerCase(s), ' ');
    }

    private static String _formatC(String s) {
        return StringUtil.replace(StringUtil.toLowerCase(s), ' ', '_');
    }

    private static String _formatD(String s) {
        return StringUtil.strip(s, ' ');
    }

    private static String _formatE(String s) {
        return StringUtil.toLowerCase(s);
    }

    private static String _formatF(String s) {
        if (Character.isUpperCase((s = StringUtil.strip(s, ' ')).charAt(0))) {
            s = StringUtil.toLowerCase(s.substring(0, 1)).concat(s.substring(1));
        }
        return s;
    }

    private static String _formatG(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            s = StringUtil.toUpperCase(s.substring(0, 1)).concat(s.substring(1));
        }
        return s;
    }

    private static String _formatH(String s) {
        StringBuilder sb = new StringBuilder(s.length() * 2);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(' ');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString().trim();
    }

    private static String _formatI(String s) {
        if (s.length() == 1) {
            return StringUtil.toLowerCase(s);
        }
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        if (Character.isUpperCase(s.charAt(0)) && Character.isLowerCase(s.charAt(1))) {
            s = StringUtil.toLowerCase(s.substring(0, 1)).concat(s.substring(1));
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        for (int i = 0; !(i >= s.length() || i + 1 != s.length() && Character.isLowerCase(s.charAt(i + 1))); ++i) {
            char c = Character.toLowerCase(s.charAt(i));
            sb.setCharAt(i, c);
        }
        return sb.toString();
    }

    private static String _formatJ(String s) {
        s = StringUtil.replace(s, '-', ' ');
        s = StringUtil.replace(s, '_', ' ');
        StringBuilder sb = new StringBuilder(StringUtil.toLowerCase(s));
        for (int i = 0; i < s.length(); ++i) {
            if (i != 0 && s.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(s.charAt(i)));
        }
        return sb.toString();
    }

    private static String _formatK(String s) {
        s = TextFormatter._formatH(s);
        s = StringUtil.replace(s, ' ', '-');
        return s;
    }

    private static String _formatL(String s) {
        if (s.length() == 1) {
            return StringUtil.toLowerCase(s);
        }
        if (Character.isLowerCase(s.charAt(0)) || Character.isUpperCase(s.charAt(0)) && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        s = StringUtil.toLowerCase(s.substring(0, 1)).concat(s.substring(1));
        return s;
    }

    private static String _formatM(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '-') continue;
            if (i > 0 && s.charAt(i - 1) == '-') {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String _formatN(String s) {
        return StringUtil.replace(s, '-', '_');
    }

    private static String _formatO(String s) {
        return StringUtil.replace(s, '_', '-');
    }

    private static String _formatP(String s) {
        StringBuilder sb = new StringBuilder(s.length() + s.length() / 2);
        for (int i = 0; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
            if (!Character.isUpperCase(s.charAt(i + 1))) continue;
            sb.append('-');
        }
        sb.append(Character.toLowerCase(s.charAt(s.length() - 1)));
        return sb.toString();
    }

    private static String _formatQ(String s) {
        StringBuilder sb = new StringBuilder(StringUtil.toLowerCase(s));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isUpperCase(c) || i <= 0 || i + 1 >= s.length()) continue;
            int delta = sb.length() - s.length();
            if (Character.isLowerCase(s.charAt(i + 1))) {
                sb.insert(i + delta, '-');
                continue;
            }
            if (!Character.isLowerCase(s.charAt(i - 1))) continue;
            sb.insert(i + delta, '-');
        }
        return sb.toString();
    }
}

