/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class ThreadLocalVariableNameCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_ENDING_VARIABLE = "variable.incorrect.ending";
    private static final String _MSG_INCORRECT_LITERAL_STRING = "literal.string.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
        List<DetailAST> variableDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 10);
        for (DetailAST variableDefinitionDetailAST : variableDefinitionDetailASTList) {
            this._checkVariableDefinition(variableDefinitionDetailAST);
        }
    }

    private void _checkLiteralString(DetailAST detailAST, DetailAST literalNewDetailAST, String variableName) {
        String value;
        DetailAST elistDetailAST = literalNewDetailAST.findFirstToken(34);
        if (elistDetailAST == null) {
            return;
        }
        DetailAST firstChildDetailAST = elistDetailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 28) {
            return;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()) == null || firstChildDetailAST.getType() != 125) {
            return;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 59 && firstChildDetailAST.getType() != 27) {
            return;
        }
        DetailAST nextSiblingDetailAST = firstChildDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 139) {
            return;
        }
        String expectedLiteralString = "." + variableName;
        if (!StringUtil.equals(expectedLiteralString, value = StringUtil.unquote(nextSiblingDetailAST.getText()))) {
            this.log(detailAST, _MSG_INCORRECT_LITERAL_STRING, new Object[]{variableName, expectedLiteralString});
        }
    }

    private void _checkVariableAssign(DetailAST detailAST, String variableName) {
        List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(detailAST, variableName);
        for (DetailAST variableCallerDetailAST : variableCallerDetailASTList) {
            DetailAST nextSiblingDetailAST;
            DetailAST parentDetailAST = variableCallerDetailAST.getParent();
            if (parentDetailAST.getType() != 80 || (parentDetailAST = parentDetailAST.getParent()).getType() != 28 || (nextSiblingDetailAST = variableCallerDetailAST.getNextSibling()) == null || nextSiblingDetailAST.getType() != 136) continue;
            this._checkLiteralString(parentDetailAST, nextSiblingDetailAST, variableName);
        }
    }

    private void _checkVariableDefinition(DetailAST detailAST) {
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (!(modifiersDetailAST.branchContains(39) && modifiersDetailAST.branchContains(61) && modifiersDetailAST.branchContains(64))) {
            return;
        }
        String variableTypeName = this.getTypeName(detailAST, true);
        if (variableTypeName == null) {
            return;
        }
        int x = variableTypeName.indexOf("<");
        if (x == -1 || !StringUtil.endsWith(variableTypeName.substring(0, x), "ThreadLocal")) {
            return;
        }
        String genericTypes = variableTypeName.substring(x);
        String variableName = this.getName(detailAST);
        if (!genericTypes.contains("ThreadLocal") && variableName.endsWith("ThreadLocal")) {
            this.log(detailAST, _MSG_INCORRECT_ENDING_VARIABLE, new Object[]{"*ThreadLocal", "ThreadLocal"});
            return;
        }
        DetailAST assignDetailAST = detailAST.findFirstToken(80);
        if (assignDetailAST == null) {
            this._checkVariableAssign(detailAST, variableName);
            return;
        }
        DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 28) {
            return;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()) == null || firstChildDetailAST.getType() != 136) {
            return;
        }
        this._checkLiteralString(detailAST, firstChildDetailAST, variableName);
    }
}

