/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class CompanyThreadLocalCheck
extends BaseCheck {
    private static final String _MSG_AVOID_SET_COMPANY_ID_CALL = "set.company.id.call.avoid";
    private static final String _MSG_MISSING_CLOSE_CALL = "close.call.missing";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<DetailAST> methodCallDetailASTList = this.getMethodCalls(detailAST, "CompanyThreadLocal", "setCompanyId");
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            this.log(methodCallDetailAST, _MSG_AVOID_SET_COMPANY_ID_CALL, new Object[0]);
        }
        this._checkMissingCloseCall(detailAST);
    }

    private void _checkMissingCloseCall(DetailAST detailAST) {
        DetailAST variableDefinitionDetailAST = null;
        String variableName = null;
        List<DetailAST> methodCallDetailASTList = this.getMethodCalls(detailAST, "CompanyThreadLocal", new String[]{"lock", "setCompanyIdWithSafeCloseable"});
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            DetailAST parentDetailAST = methodCallDetailAST.getParent();
            if (parentDetailAST.getType() == 80) {
                variableName = this.getName(parentDetailAST);
                if (variableName == null) continue;
                variableDefinitionDetailAST = this.getVariableDefinitionDetailAST(detailAST, variableName, true);
            } else if (parentDetailAST.getType() == 28) {
                if ((parentDetailAST = parentDetailAST.getParent()).getType() != 80 || (parentDetailAST = parentDetailAST.getParent()).getType() != 10) continue;
                variableDefinitionDetailAST = parentDetailAST;
                variableName = this.getName(variableDefinitionDetailAST);
            }
            if (variableDefinitionDetailAST == null || variableName == null || !(methodCallDetailASTList = this.getMethodCalls(detailAST, variableName, "close")).isEmpty()) continue;
            this.log(variableDefinitionDetailAST, _MSG_MISSING_CLOSE_CALL, new Object[]{variableName, variableName});
        }
    }
}

