/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseBreakingChangesCheck;
import com.liferay.source.formatter.processor.SourceProcessor;

public class YMLRESTConfigFileBreakingChangeCommitMessageCheck
extends BaseBreakingChangesCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith("/rest-config.yaml")) {
            return content;
        }
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        SourceFormatterArgs sourceFormatterArgs = sourceProcessor.getSourceFormatterArgs();
        if (this._hasCompatibilityVersionBump(absolutePath, sourceFormatterArgs)) {
            this.checkCommitMessages(fileName, absolutePath, sourceFormatterArgs, "compatibilityVersion bumps up");
        }
        return content;
    }

    private boolean _hasCompatibilityVersionBump(String absolutePath, SourceFormatterArgs sourceFormatterArgs) throws Exception {
        for (String currentBranchFileName : this.getCurrentBranchFileNames(sourceFormatterArgs)) {
            String[] lines;
            if (!absolutePath.endsWith(currentBranchFileName)) continue;
            String newCompatibilityVersion = null;
            String oldCompatibilityVersion = null;
            for (String line : lines = StringUtil.splitLines(GitUtil.getCurrentBranchFileDiff(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getGitWorkingBranchName(), absolutePath))) {
                if (!line.contains("compatibilityVersion:")) continue;
                int pos = line.indexOf(":");
                String version = StringUtil.trim(line.substring(pos + 1));
                if (line.startsWith("+")) {
                    newCompatibilityVersion = version;
                    continue;
                }
                if (!line.startsWith("-")) continue;
                oldCompatibilityVersion = version;
            }
            return !StringUtil.equals(newCompatibilityVersion, oldCompatibilityVersion);
        }
        return false;
    }
}

