/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.Objects;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLUpgradeDeclarativeServicesCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith("/service.xml")) {
            return content;
        }
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return content;
        }
        Element rootElement = document.getRootElement();
        Attribute attribute = rootElement.attribute("dependency-injector");
        if (attribute == null) {
            return content.replaceFirst("(<service-builder)", "$1 dependency-injector=\"ds\"");
        }
        String dependencyInjector = attribute.getValue();
        if (!Objects.equals(dependencyInjector, "ds")) {
            return content.replaceFirst("dependency-injector\\s*=\\s*\".*?\"", "dependency-injector=\"ds\"");
        }
        return content;
    }
}

