/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLTestIgnorableErrorLinesFileCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/test-ignorable-error-lines.xml")) {
            this._checkTestIgnorableErrorLinesXml(fileName, content);
        }
        return content;
    }

    private void _checkTestIgnorableErrorLinesXml(String fileName, String content) {
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return;
        }
        IgnoreErrorElementComparator ignoreErrorElementComparator = new IgnoreErrorElementComparator();
        Element rootElement = document.getRootElement();
        List javaScriptElements = rootElement.elements("javascript");
        for (Element javaScriptElement : javaScriptElements) {
            this.checkElementOrder(fileName, javaScriptElement, "ignore-error", null, ignoreErrorElementComparator);
        }
        List logElements = rootElement.elements("log");
        for (Element logElement : logElements) {
            this.checkElementOrder(fileName, logElement, "ignore-error", null, ignoreErrorElementComparator);
        }
    }

    private class IgnoreErrorElementComparator
    extends ElementComparator {
        private IgnoreErrorElementComparator() {
        }

        @Override
        public int compare(Element element1, Element element2) {
            String contains2;
            String description2;
            String description1 = element1.attributeValue("description");
            if (!description1.equals(description2 = element2.attributeValue("description"))) {
                return super.compare(description1, description2);
            }
            String contains1 = this.getTagValue(element1, "contains");
            if (!contains1.equals(contains2 = this.getTagValue(element2, "contains"))) {
                return super.compare(contains1, contains2);
            }
            String matches1 = this.getTagValue(element1, "matches");
            String matches2 = this.getTagValue(element2, "matches");
            return super.compare(matches1, matches2);
        }

        @Override
        public String getElementName(Element element) {
            return StringBundler.concat("{description=", element.attributeValue("description"), ", contains=", this.getTagValue(element, "contains"), ", matches=", this.getTagValue(element, "matches"), "}");
        }
    }
}

