/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.File;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLSuppressionsFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith("-suppressions.xml")) {
            return content;
        }
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return content;
        }
        Element rootElement = document.getRootElement();
        SuppressElementComparator suppressElementComparator = new SuppressElementComparator();
        this.checkElementOrder(fileName, rootElement, "suppress", null, suppressElementComparator);
        Element checkstyleElement = rootElement.element("checkstyle");
        this.checkElementOrder(fileName, checkstyleElement, "suppress", "checkstyle", suppressElementComparator);
        int x = absolutePath.lastIndexOf(47);
        String fileLocation = absolutePath.substring(0, x + 1);
        content = this._formatFilesPropertyValue(fileName, content, fileLocation, checkstyleElement);
        Element sourceCheckElement = rootElement.element("source-check");
        this.checkElementOrder(fileName, sourceCheckElement, "suppress", "source-check", suppressElementComparator);
        return this._formatFilesPropertyValue(fileName, content, fileLocation, sourceCheckElement);
    }

    private void _addMessage(String fileName, String content, String value, String expectedName, String type) {
        int x = content.indexOf("\"" + value + "\"");
        if (x != -1) {
            x = this.getLineNumber(content, x);
        }
        this.addMessage(fileName, StringBundler.concat("Incorrect value \"", value, "\". Relative path to file (from ", "location of suppressions file) expected for value of ", "property \"files\". ", type, " \"", expectedName, "\" does not exist."), x);
    }

    private String _formatFilesPropertyValue(String fileName, String content, String fileLocation, Element element) {
        if (element == null) {
            return content;
        }
        for (Element suppressElement : element.elements("suppress")) {
            String originalValue = suppressElement.attributeValue("files");
            if (originalValue == null) continue;
            String value = StringUtil.replace(originalValue, "\\.", ".");
            int x = value.indexOf(42);
            if (x == -1) {
                String expectedFileName = fileLocation + value;
                File file = new File(expectedFileName);
                if (file.exists()) continue;
                String relativeValue = this._getRelativeValue(originalValue, fileLocation);
                if (relativeValue != null) {
                    return StringUtil.replace(content, "\"" + originalValue + "\"", "\"" + relativeValue + "\"");
                }
                this._addMessage(fileName, content, originalValue, expectedFileName, "File");
                continue;
            }
            int y = value.lastIndexOf(47, x);
            if (y == -1) continue;
            String directoryValue = value.substring(0, y + 1);
            String expectedFolderName = fileLocation + directoryValue;
            File file = new File(expectedFolderName);
            if (file.exists()) continue;
            String relativeValue = this._getRelativeValue(originalValue, fileLocation, directoryValue);
            if (relativeValue != null) {
                return StringUtil.replace(content, "\"" + originalValue + "\"", "\"" + relativeValue + "\"");
            }
            this._addMessage(fileName, content, originalValue, expectedFolderName, "Directory");
        }
        return content;
    }

    private String _getRelativeValue(String originalvalue, String fileLocation) {
        String relativeValue;
        int x = -1;
        while (true) {
            if ((x = originalvalue.indexOf(47, x + 1)) == -1) {
                return null;
            }
            String s = originalvalue.substring(0, x + 1);
            if (!fileLocation.endsWith(s)) continue;
            relativeValue = originalvalue.substring(x + 1);
            File file = new File(fileLocation + StringUtil.replace(relativeValue, "\\.", "."));
            if (file.exists()) break;
        }
        return relativeValue;
    }

    private String _getRelativeValue(String originalValue, String fileLocation, String directoryValue) {
        File file;
        String relativeValue;
        String s;
        int x = -1;
        do {
            if ((x = directoryValue.indexOf(47, x + 1)) != -1) continue;
            return null;
        } while (!fileLocation.endsWith(s = directoryValue.substring(0, x + 1)) || Validator.isNotNull(relativeValue = directoryValue.substring(x + 1)) && !(file = new File(fileLocation + relativeValue)).exists());
        return StringUtil.replaceFirst(originalValue, directoryValue, relativeValue);
    }

    private class SuppressElementComparator
    extends ElementComparator {
        private SuppressElementComparator() {
        }

        @Override
        public String getElementName(Element suppressElement) {
            StringBundler sb = new StringBundler(3);
            sb.append(suppressElement.attributeValue("checks"));
            sb.append("#");
            sb.append(suppressElement.attributeValue("files"));
            return sb.toString();
        }
    }
}

