/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLFriendlyURLRoutesFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("routes.xml")) {
            this._checkOrder(fileName, content);
        }
        return content;
    }

    private void _checkOrder(String fileName, String content) {
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        List routeElements = rootElement.elements("route");
        ElementComparator elementComparator = new ElementComparator();
        for (Element routeElement : routeElements) {
            this.checkElementOrder(fileName, routeElement, "ignored-parameter", null, elementComparator);
            this.checkElementOrder(fileName, routeElement, "implicit-parameter", null, elementComparator);
            this.checkElementOrder(fileName, routeElement, "overridden-parameter", null, elementComparator);
        }
    }
}

