/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TFBlockOrderCheck
extends BaseFileCheck {
    private static final Pattern _blockPattern = Pattern.compile("(?<=\\A|\n)\\w.+\\{[\\s\\S]*?\n\\}");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        BlockComparator blockComparator = new BlockComparator();
        Matcher matcher = _blockPattern.matcher(content);
        String previousBlock = "";
        int previousBlockStartPosition = 0;
        while (matcher.find()) {
            String block = matcher.group();
            int blockStartPosition = matcher.start();
            if (Validator.isNull(previousBlock)) {
                previousBlock = block;
                previousBlockStartPosition = blockStartPosition;
                continue;
            }
            if (blockComparator.compare(previousBlock, block) > 0) {
                content = StringUtil.replaceFirst(content, block, previousBlock, matcher.start());
                return StringUtil.replaceFirst(content, previousBlock, block, previousBlockStartPosition);
            }
            previousBlock = block;
            previousBlockStartPosition = blockStartPosition;
        }
        return content;
    }

    private class BlockComparator
    extends NaturalOrderStringComparator {
        private BlockComparator() {
        }

        @Override
        public int compare(String block1, String block2) {
            String blockName1 = this._getBlockName(block1);
            String blockName2 = this._getBlockName(block2);
            return super.compare(blockName1, blockName2);
        }

        private String _getBlockName(String block) {
            int x = block.indexOf(123);
            if (x == -1) {
                return "";
            }
            return StringUtil.removeChars(block.substring(0, x - 1), '\"');
        }
    }
}

