/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SessionKeysCheck
extends BaseFileCheck {
    protected final Pattern sessionKeyPattern = Pattern.compile("SessionErrors.(?:add|contains|get)\\([^;%&|!]+|SessionMessages.(?:add|contains|get)\\([^;%&|!]+", 8);
    private static final String[] _ALLOWED_SUFFIXES = new String[]{"_requestProcessedSuccess", "_requestProcessedWarning"};

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._fixSessionKeys(content, this.getPatterns());
    }

    protected List<Pattern> getPatterns() {
        return Arrays.asList(this.sessionKeyPattern);
    }

    private String _fixSessionKey(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String newContent = content;
        do {
            String match = matcher.group();
            String s = null;
            s = pattern.equals(this.sessionKeyPattern) ? "," : "key=";
            int x = match.indexOf(s);
            if (x == -1) continue;
            String substring = StringUtil.trim(match.substring(x += s.length()));
            String quote = "";
            if (substring.startsWith("'")) {
                quote = "'";
            } else {
                if (!substring.startsWith("\"")) continue;
                quote = "\"";
            }
            int y = match.indexOf(quote, x);
            int z = match.indexOf(quote, y + 1);
            if (y == -1 || z == -1) continue;
            String prefix = match.substring(0, y + 1);
            String suffix = match.substring(z);
            String oldKey = match.substring(y + 1, z);
            String oldKeySuffix = "";
            for (String allowedSuffix : _ALLOWED_SUFFIXES) {
                if (!oldKey.endsWith(allowedSuffix)) continue;
                oldKey = oldKey.substring(0, oldKey.lastIndexOf(allowedSuffix));
                oldKeySuffix = allowedSuffix;
                break;
            }
            boolean alphaNumericKey = true;
            for (char c : oldKey.toCharArray()) {
                if (Validator.isChar(c) || Validator.isDigit(c) || c == '-' || c == '_') continue;
                alphaNumericKey = false;
            }
            if (!alphaNumericKey) continue;
            String newKey = TextFormatter.format(oldKey, 14);
            if ((newKey = TextFormatter.format(newKey, 12)).equals(oldKey)) continue;
            if (Validator.isNotNull(oldKeySuffix)) {
                newKey = newKey + oldKeySuffix;
                oldKey = oldKey + oldKeySuffix;
            }
            String oldSub = StringBundler.concat(prefix, oldKey, suffix);
            String newSub = StringBundler.concat(prefix, newKey, suffix);
            newContent = StringUtil.replaceFirst(newContent, oldSub, newSub);
        } while (matcher.find());
        return newContent;
    }

    private String _fixSessionKeys(String content, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            content = this._fixSessionKey(content, pattern);
        }
        return content;
    }
}

