/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.processor.SourceProcessor;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.GradleBuildFile;
import com.liferay.source.formatter.util.GradleDependency;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.dom4j.Document;
import org.dom4j.Element;

public class LibraryVulnerabilitiesCheck
extends BaseFileCheck {
    private static final String _ALLOWED_VULNERABILITIES_KEY = "allowedVulnerabilities";
    private static final String _BUILD_PROPERTIES_FILE_NAME = "build." + System.getProperty("user.name") + ".properties";
    private static final String _CI_PROPERTIES_URL = "http://mirrors.lax.liferay.com/github.com/liferay/liferay-jenkins-ee/commands/build.properties";
    private static final String _SEVERITIES_KEY = "severities";
    private static final Log _log = LogFactoryUtil.getLog(LibraryVulnerabilitiesCheck.class);
    private String _cachedKnownVulnerabilities;
    private final Map<String, List<SecurityVulnerabilityNode>> _cachedVulnerableVersionMap = new ConcurrentHashMap<String, List<SecurityVulnerabilityNode>>();
    private String _githubAccessToken;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        SourceFormatterArgs sourceFormatterArgs = sourceProcessor.getSourceFormatterArgs();
        if (!sourceFormatterArgs.isCheckVulnerabilities()) {
            return content;
        }
        this._githubAccessToken = this._getGithubAccessToken(sourceFormatterArgs);
        if (fileName.endsWith(".gradle")) {
            this._checkGradleLibraryVulnerabilities(fileName, absolutePath, content);
        } else if (fileName.endsWith(".json")) {
            this._checkJsonLibraryVulnerabilities(fileName, absolutePath, content);
        } else if (fileName.endsWith(".properties")) {
            this._checkPropertiesLibraryVulnerabilities(fileName, absolutePath, content);
        } else if (fileName.endsWith("ivy.xml")) {
            this._checkIvyXmlLibraryVulnerabilities(fileName, absolutePath, content);
        } else if (fileName.endsWith("pom.xml")) {
            this._checkPomXmlLibraryVulnerabilities(fileName, absolutePath, content);
        }
        return content;
    }

    private static boolean _isGenerateVulnerableLibrariesCacheFile() {
        if (Validator.isNull(System.getenv("JENKINS_HOME"))) {
            return false;
        }
        String jobName = System.getenv("JOB_NAME");
        if (Validator.isNull(jobName)) {
            return false;
        }
        return jobName.contains("liferay-binaries-cache-upstream");
    }

    private void _checkGradleLibraryVulnerabilities(String fileName, String absolutePath, String content) throws Exception {
        GradleBuildFile gradleBuildFile = new GradleBuildFile(content);
        List<GradleDependency> gradleDependencies = gradleBuildFile.getGradleDependencies();
        gradleDependencies.addAll(gradleBuildFile.getBuildScriptDependencies());
        for (GradleDependency gradleDependency : gradleDependencies) {
            String gradleDependencyGroup = gradleDependency.getGroup();
            String gradleDependencyName = gradleDependency.getName();
            String gradleDependencyVersion = gradleDependency.getVersion();
            if (Validator.isNull(gradleDependencyGroup) || Validator.isNull(gradleDependencyName) || Validator.isNull(gradleDependencyVersion)) continue;
            this._checkVulnerabilities(fileName, absolutePath, gradleDependencyGroup + ":" + gradleDependencyName, gradleDependencyVersion, SecurityAdvisoryEcosystemEnum.MAVEN);
        }
    }

    private void _checkIvyXmlLibraryVulnerabilities(String fileName, String absolutePath, String content) throws Exception {
        if (Validator.isNull(content)) {
            return;
        }
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        for (Element dependenciesElement : rootElement.elements("dependencies")) {
            for (Element dependencyElement : dependenciesElement.elements("dependency")) {
                String name = dependencyElement.attributeValue("name");
                String org = dependencyElement.attributeValue("org");
                String rev = dependencyElement.attributeValue("rev");
                if (Validator.isNull(name) || Validator.isNull(org) || Validator.isNull(rev)) continue;
                this._checkVulnerabilities(fileName, absolutePath, org + ":" + name, rev, SecurityAdvisoryEcosystemEnum.MAVEN);
            }
        }
    }

    private void _checkJsonLibraryVulnerabilities(String fileName, String absolutePath, String content) throws Exception {
        block3: {
            if (Validator.isNull(content)) {
                return;
            }
            try {
                JSONObjectImpl contentJSONObject = new JSONObjectImpl(content);
                this._checkVersionInJsonFile(fileName, absolutePath, contentJSONObject.getJSONObject("dependencies"));
                this._checkVersionInJsonFile(fileName, absolutePath, contentJSONObject.getJSONObject("devDependencies"));
            }
            catch (JSONException jsonException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug(jsonException);
            }
        }
    }

    private void _checkPomXmlLibraryVulnerabilities(String fileName, String absolutePath, String content) throws Exception {
        if (Validator.isNull(content)) {
            return;
        }
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        for (Element dependenciesElement : rootElement.elements("dependencies")) {
            for (Element dependencyElement : dependenciesElement.elements("dependency")) {
                String version;
                Element artifactIdElement = dependencyElement.element("artifactId");
                Element groupIdElement = dependencyElement.element("groupId");
                Element versionElement = dependencyElement.element("version");
                if (artifactIdElement == null || groupIdElement == null || versionElement == null || (version = versionElement.getText()).startsWith("$")) continue;
                this._checkVulnerabilities(fileName, absolutePath, groupIdElement.getText() + ":" + artifactIdElement.getText(), version, SecurityAdvisoryEcosystemEnum.MAVEN);
            }
        }
        for (Element buildsElement : rootElement.elements("build")) {
            for (Element pluginsElement : buildsElement.elements("plugins")) {
                for (Element pluginElement : pluginsElement.elements("plugin")) {
                    String version;
                    Element artifactIdElement = pluginElement.element("artifactId");
                    Element groupIdElement = pluginElement.element("groupId");
                    Element versionElement = pluginElement.element("version");
                    if (artifactIdElement == null || groupIdElement == null || versionElement == null || (version = versionElement.getText()).startsWith("$")) continue;
                    this._checkVulnerabilities(fileName, absolutePath, groupIdElement.getText() + ":" + artifactIdElement.getText(), version, SecurityAdvisoryEcosystemEnum.MAVEN);
                }
            }
        }
    }

    private void _checkPropertiesLibraryVulnerabilities(String fileName, String absolutePath, String content) throws Exception {
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String[] dependency;
            String key = (String)enumeration.nextElement();
            String value = properties.getProperty(key);
            if (Validator.isNull(value) || (dependency = value.split(":")).length < 3) continue;
            this._checkVulnerabilities(fileName, absolutePath, dependency[0] + ":" + dependency[1], dependency[2], SecurityAdvisoryEcosystemEnum.MAVEN);
        }
    }

    private void _checkVersionInJsonFile(String fileName, String absolutePath, JSONObject jsonObject) throws Exception {
        if (jsonObject == null) {
            return;
        }
        for (String dependencyName : jsonObject.keySet()) {
            String version = jsonObject.getString(dependencyName);
            if (version.startsWith("^") || version.startsWith("~") || version.startsWith("*")) continue;
            this._checkVulnerabilities(fileName, absolutePath, dependencyName, version, SecurityAdvisoryEcosystemEnum.NPM);
        }
    }

    private void _checkVulnerabilities(String fileName, String packageName, SecurityAdvisoryEcosystemEnum securityAdvisoryEcosystemEnum, DefaultArtifactVersion version) {
        List<SecurityVulnerabilityNode> securityVulnerabilityNodes = this._cachedVulnerableVersionMap.get((Object)((Object)securityAdvisoryEcosystemEnum) + ":" + packageName);
        for (SecurityVulnerabilityNode securityVulnerabilityNode : securityVulnerabilityNodes) {
            VersionRange versionRange = securityVulnerabilityNode.getVersionRange();
            if (!versionRange.containsVersion((ArtifactVersion)version)) continue;
            this.addMessage(fileName, StringBundler.concat("Library \"", packageName, ":", version, "\" contains known vulnerabilities(", securityVulnerabilityNode.getSummary(), ", ", securityVulnerabilityNode.getPermalink(), ")"));
            return;
        }
    }

    private void _checkVulnerabilities(String fileName, String absolutePath, String packageName, String version, SecurityAdvisoryEcosystemEnum securityAdvisoryEcosystemEnum) throws Exception {
        List<String> allowedVulnerabilities = this.getAttributeValues(_ALLOWED_VULNERABILITIES_KEY, absolutePath);
        if (allowedVulnerabilities.contains(packageName + ":" + version) || !version.matches("(\\d|v).+")) {
            return;
        }
        for (String line : StringUtil.splitLines(this._getCachedKnownVulnerabilities())) {
            String[] parts = StringUtil.split(line, ";");
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)parts[2]);
            DefaultArtifactVersion defaultArtifactVersion = new DefaultArtifactVersion(version);
            if (parts.length != 5 || !Objects.equals(securityAdvisoryEcosystemEnum.name(), parts[0]) || !packageName.equals(parts[1]) || !versionRange.containsVersion((ArtifactVersion)defaultArtifactVersion)) continue;
            this.addMessage(fileName, StringBundler.concat("Library \"", packageName, ":", version, "\" contains known vulnerabilities(", parts[3], ", ", parts[4], ")"));
            return;
        }
        if (Validator.isNull(this._githubAccessToken)) {
            return;
        }
        if (!this._cachedVulnerableVersionMap.containsKey((Object)((Object)securityAdvisoryEcosystemEnum) + ":" + packageName)) {
            this._generateVulnerableVersionMap(packageName, securityAdvisoryEcosystemEnum, this.getAttributeValues(_SEVERITIES_KEY, absolutePath));
        }
        this._checkVulnerabilities(fileName, packageName, securityAdvisoryEcosystemEnum, new DefaultArtifactVersion(version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateVulnerableVersionMap(String packageName, SecurityAdvisoryEcosystemEnum securityAdvisoryEcosystemEnum, List<String> severities) throws Exception {
        if (this._cachedVulnerableVersionMap.containsKey((Object)((Object)securityAdvisoryEcosystemEnum) + ":" + packageName)) {
            return;
        }
        List<SecurityVulnerabilityNode> securityVulnerabilityNodes = this._getSecurityVulnerabilityNodes(packageName, null, securityAdvisoryEcosystemEnum, severities, this._githubAccessToken);
        this._cachedVulnerableVersionMap.put((Object)((Object)securityAdvisoryEcosystemEnum) + ":" + packageName, securityVulnerabilityNodes);
        if (!LibraryVulnerabilitiesCheck._isGenerateVulnerableLibrariesCacheFile()) {
            return;
        }
        for (SecurityVulnerabilityNode securityVulnerabilityNode : securityVulnerabilityNodes) {
            Object[] items = new String[]{securityAdvisoryEcosystemEnum.toString(), packageName, String.valueOf(securityVulnerabilityNode.getVersionRange()), securityVulnerabilityNode.getSummary(), securityVulnerabilityNode.getPermalink()};
            String vulnerabilityContent = StringUtil.merge(items, ";") + "\n";
            LibraryVulnerabilitiesCheck libraryVulnerabilitiesCheck = this;
            synchronized (libraryVulnerabilitiesCheck) {
                this._write(new File(this.getPortalDir(), "vulnerable_libraries.txt"), vulnerabilityContent);
            }
        }
    }

    private synchronized String _getCachedKnownVulnerabilities() throws Exception {
        File vulnerableLibrariesFile;
        if (Validator.isNotNull(this._cachedKnownVulnerabilities)) {
            return this._cachedKnownVulnerabilities;
        }
        this._cachedKnownVulnerabilities = "";
        if (!LibraryVulnerabilitiesCheck._isGenerateVulnerableLibrariesCacheFile() && (vulnerableLibrariesFile = new File(this.getPortalDir(), "../liferay-binaries-cache-2020/vulnerable_libraries.txt")).exists()) {
            this._cachedKnownVulnerabilities = FileUtil.read(vulnerableLibrariesFile);
        }
        return this._cachedKnownVulnerabilities;
    }

    private String _getCiGithubAccessToken() {
        Properties properties;
        block2: {
            properties = new Properties();
            try {
                URL url = new URL(_CI_PROPERTIES_URL);
                URLConnection urlConnection = url.openConnection();
                urlConnection.connect();
                properties.load(urlConnection.getInputStream());
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug(ioException);
            }
        }
        return properties.getProperty("github.access.token");
    }

    private synchronized String _getGithubAccessToken(SourceFormatterArgs sourceFormatterArgs) throws Exception {
        if (Validator.isNotNull(this._githubAccessToken)) {
            return this._githubAccessToken;
        }
        this._githubAccessToken = sourceFormatterArgs.isUseCiGithubAccessToken() || LibraryVulnerabilitiesCheck._isGenerateVulnerableLibrariesCacheFile() ? this._getCiGithubAccessToken() : this._getLocalGithubAccessToken();
        return this._githubAccessToken;
    }

    private String _getLocalGithubAccessToken() throws Exception {
        File file = this.getPortalDir();
        if (file == null) {
            return "";
        }
        File buildPropertiesFile = new File(file.getAbsolutePath(), _BUILD_PROPERTIES_FILE_NAME);
        if (!buildPropertiesFile.exists()) {
            return null;
        }
        Properties properties = new Properties();
        properties.load(Files.newInputStream(buildPropertiesFile.toPath(), new OpenOption[0]));
        return properties.getProperty("github.access.token");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<SecurityVulnerabilityNode> _getSecurityVulnerabilityNodes(String packageName, String cursor, SecurityAdvisoryEcosystemEnum securityAdvisoryEcosystemEnum, List<String> severities, String githubToken) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        try (CloseableHttpClient closeableHttpClient = httpClientBuilder.build();){
            String queryArguments = StringBundler.concat("first: 100, package:\\\"", packageName, "\\\", ecosystem: ", securityAdvisoryEcosystemEnum.name(), ", severities: ", severities);
            if (Validator.isNotNull(cursor)) {
                queryArguments = queryArguments + "after: \\\"" + cursor + "\\\"";
            }
            String resultArguments = "{nodes { advisory {summary, permalink} package {name} severity vulnerableVersionRange } pageInfo {endCursor hasNextPage } totalCount }";
            HttpPost httpPost = new HttpPost("https://api.github.com/graphql");
            httpPost.setEntity(new StringEntity(StringBundler.concat("{\"query\": \"{ securityVulnerabilities(", queryArguments, ") ", resultArguments, "}\" }"), ContentType.APPLICATION_JSON));
            httpPost.addHeader("Authorization", "bearer " + githubToken);
            httpPost.addHeader("Content-Type", "application/json; charset=utf-8");
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(httpPost);
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            if (statusLine.getStatusCode() != 200) {
                List<SecurityVulnerabilityNode> list = Collections.emptyList();
                return list;
            }
            JSONObjectImpl jsonObject = new JSONObjectImpl(EntityUtils.toString(closeableHttpResponse.getEntity(), "UTF-8"));
            JSONObject dataJSONObject = jsonObject.getJSONObject("data");
            if (dataJSONObject == null) {
                List<SecurityVulnerabilityNode> list = Collections.emptyList();
                return list;
            }
            JSONObject securityVulnerabilitiesJSONObject = dataJSONObject.getJSONObject("securityVulnerabilities");
            if (securityVulnerabilitiesJSONObject == null) {
                List<SecurityVulnerabilityNode> list = Collections.emptyList();
                return list;
            }
            int totalCount = securityVulnerabilitiesJSONObject.getInt("totalCount");
            if (totalCount == 0) {
                List<SecurityVulnerabilityNode> list = Collections.emptyList();
                return list;
            }
            ArrayList<SecurityVulnerabilityNode> securityVulnerabilityNodes = new ArrayList<SecurityVulnerabilityNode>();
            JSONArray nodesJSONArray = securityVulnerabilitiesJSONObject.getJSONArray("nodes");
            for (JSONObject nodeJSONObject : nodesJSONArray) {
                SecurityVulnerabilityNode securityVulnerabilityNode = new SecurityVulnerabilityNode();
                JSONObject advisoryJSONObject = nodeJSONObject.getJSONObject("advisory");
                securityVulnerabilityNode.setPermalink(advisoryJSONObject.getString("permalink"));
                securityVulnerabilityNode.setSummary(advisoryJSONObject.getString("summary"));
                securityVulnerabilityNode.setVersionRange(nodeJSONObject.getString("vulnerableVersionRange"));
                securityVulnerabilityNodes.add(securityVulnerabilityNode);
            }
            JSONObject pageInfoJSONObject = securityVulnerabilitiesJSONObject.getJSONObject("pageInfo");
            if (pageInfoJSONObject.getBoolean("hasNextPage")) {
                securityVulnerabilityNodes.addAll(this._getSecurityVulnerabilityNodes(packageName, pageInfoJSONObject.getString("endCursor"), securityAdvisoryEcosystemEnum, severities, githubToken));
            }
            if (securityVulnerabilityNodes.isEmpty()) return Collections.emptyList();
            ArrayList<SecurityVulnerabilityNode> arrayList = securityVulnerabilityNodes;
            return arrayList;
        }
        catch (Exception exception) {
            _log.error(exception);
        }
        return Collections.emptyList();
    }

    private void _write(File file, String content) throws Exception {
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(file.toURI()), StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            outputStream.write(content.getBytes());
        }
    }

    private static enum SecurityAdvisoryEcosystemEnum {
        MAVEN,
        NPM;

    }

    private static class SecurityVulnerabilityNode {
        private String _permalink;
        private String _summary;
        private VersionRange _versionRange;

        private SecurityVulnerabilityNode() {
        }

        public String getPermalink() {
            return this._permalink;
        }

        public String getSummary() {
            return this._summary;
        }

        public VersionRange getVersionRange() {
            return this._versionRange;
        }

        public void setPermalink(String permalink) {
            this._permalink = permalink;
        }

        public void setSummary(String summary) {
            this._summary = summary;
        }

        public void setVersionRange(String vulnerableVersionRange) throws InvalidVersionSpecificationException {
            if (!vulnerableVersionRange.contains(",")) {
                String[] versionArray = vulnerableVersionRange.split(" ", 2);
                if (versionArray[0].equals("=")) {
                    this._versionRange = VersionRange.createFromVersion((String)versionArray[1]);
                } else if (versionArray[0].equals("<")) {
                    this._versionRange = VersionRange.createFromVersionSpec((String)("(," + versionArray[1] + ")"));
                } else if (versionArray[0].equals("<=")) {
                    this._versionRange = VersionRange.createFromVersionSpec((String)("(," + versionArray[1] + "]"));
                } else if (versionArray[0].equals(">")) {
                    this._versionRange = VersionRange.createFromVersionSpec((String)("(" + versionArray[1] + ",)"));
                } else if (versionArray[0].equals(">=")) {
                    this._versionRange = VersionRange.createFromVersionSpec((String)("[" + versionArray[1] + ",)"));
                }
            } else {
                vulnerableVersionRange = vulnerableVersionRange.replaceAll("([=<>]+.+?, )([=<>]+)(.+)", "$1$3$2");
                vulnerableVersionRange = StringUtil.replace(vulnerableVersionRange, new String[]{">=", ">", "<=", "<"}, new String[]{"[", "(", "]", ")"});
                this._versionRange = VersionRange.createFromVersionSpec((String)vulnerableVersionRange);
            }
        }
    }
}

