/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.io.IOException;
import java.util.List;

public class JavaModuleExposureCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        BNDSettings bndSettings = this.getBNDSettings(fileName);
        if (bndSettings == null) {
            return javaTerm.getContent();
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(bndSettings.getContent(), "Bundle-SymbolicName");
        if (!bundleSymbolicName.endsWith(".api")) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = javaTerm.getParentJavaClass();
        while (javaClass.getParentJavaClass() != null) {
            javaClass = javaClass.getParentJavaClass();
        }
        if (!this._hasExportPackage(javaClass.getPackageName(), bndSettings)) {
            return javaTerm.getContent();
        }
        String exposedSPIType = this._getExposedSPIType(javaTerm, javaClass.getImportNames());
        if (exposedSPIType != null) {
            this.addMessage(fileName, "Do not expose \"" + exposedSPIType + "\" in \"api\" module");
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }

    private String _getExposedSPIType(JavaTerm javaTerm, List<String> importNames) {
        JavaSignature signature = javaTerm.getSignature();
        if (signature == null) {
            return null;
        }
        for (String importName : importNames) {
            if (!importName.contains(".spi.")) continue;
            if (importName.equals(signature.getReturnType()) || importName.endsWith("." + signature.getReturnType())) {
                return signature.getReturnType();
            }
            for (JavaParameter javaParameter : signature.getParameters()) {
                if (!importName.equals(javaParameter.getParameterType()) && !importName.endsWith("." + javaParameter.getParameterType())) continue;
                return javaParameter.getParameterType();
            }
        }
        return null;
    }

    private boolean _hasExportPackage(String packageName, BNDSettings bndSettings) {
        List<String> exportPackages = BNDSourceUtil.getDefinitionValues(bndSettings.getContent(), "Export-Package");
        if (exportPackages.contains(packageName)) {
            return true;
        }
        for (String exportPackage : exportPackages) {
            if (!exportPackage.endsWith(".*") || !packageName.startsWith(exportPackage.substring(0, exportPackage.length() - 2))) continue;
            return true;
        }
        return false;
    }
}

