/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;

public class JavaModuleComponentCheck
extends BaseJavaTermCheck {
    private static final String _ALLOWED_CLASS_NAMES_KEY = "allowedClassNames";

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        if (javaTerm.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        String packageName = JavaSourceUtil.getPackageName(fileContent);
        List<String> allowedClassNames = this.getAttributeValues(_ALLOWED_CLASS_NAMES_KEY, absolutePath);
        if (allowedClassNames.contains(packageName + "." + javaTerm.getName())) {
            return javaTerm.getContent();
        }
        if (javaTerm.hasAnnotation("Component")) {
            if (absolutePath.contains("-api/") || absolutePath.contains("-spi/")) {
                this.addMessage(fileName, "Do not use @Component in \"-api\" or \"-spi\" module");
            }
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.hasAnnotation("Reference")) continue;
            if (!javaTerm.isAbstract()) {
                this.addMessage(fileName, "@Reference should not be used in a class without @Component");
                break;
            }
            if (!StringUtil.startsWith(javaClass.getName(), "Base") || !childJavaTerm.isJavaVariable() || !childJavaTerm.isPrivate()) continue;
            this.addMessage(fileName, StringBundler.concat("@Reference variable \"", childJavaTerm.getName(), "\" should be protected instead of private in a class ", "without @Component"), childJavaTerm.getLineNumber());
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }
}

