/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;

public class JSONDeprecatedPackagesCheck
extends BaseFileCheck {
    private static final String _DEPRECATED_PACKAGE_NAMES_KEY = "deprecatedPackageNames";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!absolutePath.endsWith("/package.json")) {
            return content;
        }
        List<String> deprecatedPackageNames = this.getAttributeValues(_DEPRECATED_PACKAGE_NAMES_KEY, absolutePath);
        for (String deprecatedPackageName : deprecatedPackageNames) {
            int x = -1;
            while ((x = content.indexOf("\"" + deprecatedPackageName + "\":", x + 1)) != -1) {
                this.addMessage(fileName, "Do not use deprecated package \"" + deprecatedPackageName + "\"", SourceUtil.getLineNumber(content, x));
            }
        }
        return content;
    }
}

