/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseTagAttributesCheck;
import java.util.List;

public class CSPTagMissingAttributesCheck
extends BaseTagAttributesCheck {
    private static final String _NONCE_ATTRIBUTE_TAG_NAMES_KEY = "nonceAttributeTagNames";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith(".ftl") && !fileName.endsWith(".vm")) {
            return content;
        }
        String lowerCaseContent = StringUtil.toLowerCase(content);
        List<String> nonceAttributeTagNames = this.getAttributeValues(_NONCE_ATTRIBUTE_TAG_NAMES_KEY, absolutePath);
        for (String nonceAttributeTagName : nonceAttributeTagNames) {
            int x = -1;
            while ((x = lowerCaseContent.indexOf("<" + nonceAttributeTagName, x + 1)) != -1) {
                String tagString = this.getTag(content, x);
                if (Validator.isNull(tagString) || nonceAttributeTagName.equals("link") && !tagString.contains("rel=\"stylesheet\"")) continue;
                int lineNumber = this.getLineNumber(content, x);
                if (fileName.endsWith(".ftl")) {
                    this._checkMissingAttribute(fileName, nonceAttributeTagName, "${nonceAttribute}", tagString, lineNumber);
                    continue;
                }
                if (!fileName.endsWith(".vm")) continue;
                this._checkMissingAttribute(fileName, nonceAttributeTagName, "$nonceAttribute", tagString, lineNumber);
            }
        }
        return content;
    }

    private void _checkMissingAttribute(String fileName, String tagName, String attribute, String tagString, int lineNumber) {
        if (tagString.contains(attribute)) {
            return;
        }
        this.addMessage(fileName, StringBundler.concat("Missing attribute \"", attribute, "\" in <", tagName, "> tag, see LPD-18227"), lineNumber);
    }
}

