/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.elements.PoshiComment;
import com.liferay.poshi.core.script.PoshiScriptParserException;
import com.liferay.poshi.core.util.StringUtil;
import org.dom4j.Comment;

public class InlinePoshiComment
extends PoshiComment {
    @Override
    public PoshiComment clone(Comment comment) {
        String commentText = comment.getText();
        if (!commentText.contains("\n")) {
            return new InlinePoshiComment(comment);
        }
        return null;
    }

    @Override
    public PoshiComment clone(String poshiScript) throws PoshiScriptParserException {
        if (this.isPoshiScriptComment(poshiScript)) {
            return new InlinePoshiComment(poshiScript);
        }
        return null;
    }

    @Override
    public boolean isPoshiScriptComment(String poshiScript) {
        return (poshiScript = poshiScript.trim()).startsWith("//");
    }

    @Override
    public void parsePoshiScript(String poshiScript) throws PoshiScriptParserException {
        if (this.isPoshiScriptComment(poshiScript)) {
            this.setText(poshiScript.substring(2));
        }
    }

    @Override
    public String toPoshiScript() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n\t//");
        String comment = this.getText();
        sb.append(StringUtil.trimTrailing(comment));
        return sb.toString();
    }

    protected InlinePoshiComment() {
    }

    protected InlinePoshiComment(Comment comment) {
        super(comment);
    }

    protected InlinePoshiComment(String poshiScript) throws PoshiScriptParserException {
        super(poshiScript);
    }
}

