/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util.comparator;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.OrderByComparator;

public class UserIdComparator
extends OrderByComparator<User> {
    public static final String ORDER_BY_ASC = "User_.userId ASC";
    public static final String ORDER_BY_DESC = "User_.userId DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"userId"};
    private static final UserIdComparator _INSTANCE_ASCENDING = new UserIdComparator(true);
    private static final UserIdComparator _INSTANCE_DESCENDING = new UserIdComparator(false);
    private final boolean _ascending;

    public static UserIdComparator getInstance(boolean ascending) {
        if (ascending) {
            return _INSTANCE_ASCENDING;
        }
        return _INSTANCE_DESCENDING;
    }

    @Override
    public int compare(User userGroup1, User userGroup2) {
        long userId1 = userGroup1.getUserId();
        long userId2 = userGroup2.getUserId();
        int value = 0;
        if (userId1 < userId2) {
            value = -1;
        } else if (userId1 > userId2) {
            value = 1;
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    private UserIdComparator(boolean ascending) {
        this._ascending = ascending;
    }
}

