/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.regex.Pattern;

@StatelessCheck
public class PackageNameCheck
extends AbstractCheck {
    public static final String MSG_KEY = "name.invalidPattern";
    private Pattern format = Pattern.compile("^[a-z]+(\\.[a-zA-Z_][a-zA-Z0-9_]*)*$");

    public void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{16};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nameAST = ast.getLastChild().getPreviousSibling();
        FullIdent full = FullIdent.createFullIdent(nameAST);
        if (!this.format.matcher(full.getText()).find()) {
            this.log(full.getDetailAst(), MSG_KEY, full.getText(), this.format.pattern());
        }
    }
}

